/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.restv2.model.mappers.documentreport;

import com.atlassian.confluence.user.UserAccessor;
import com.comalatech.confluence.workflow.documentReport.UsersContentPropertiesKeys;
import com.comalatech.confluence.workflow.restv2.model.documentreport.WorkflowsReportData;
import com.comalatech.confluence.workflow.restv2.model.mappers.documentreport.DocumentReportJsonPropertyMapper;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;

public class UsersMapper
implements DocumentReportJsonPropertyMapper {
    private final UserAccessor userAccessor;

    public UsersMapper(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }

    @Override
    public WorkflowsReportData map(String key, String json, WorkflowsReportData result) {
        Optional<UsersContentPropertiesKeys> userDataEnum = UsersContentPropertiesKeys.fromString(key);
        if (result == null) {
            result = new WorkflowsReportData();
        }
        if (userDataEnum.isPresent()) {
            List userContentPropertyModels = userDataEnum.map(dataEnum -> dataEnum.getUserData(json, this.userAccessor)).orElse(Collections.emptyList());
            switch (userDataEnum.get()) {
                case COMALA_WORKFLOWS_PENDING_APPROVERS: {
                    result.pendingApprovers = new HashSet(userContentPropertyModels);
                    break;
                }
                case COMALA_WORKFLOWS_FINISHED_APPROVERS: {
                    result.finishedApprovers = new HashSet(userContentPropertyModels);
                    break;
                }
                case COMALA_WORKFLOWS_LAST_FINAL_VERSION_APPROVERS: {
                    result.lastFinalVersionApprovers = new HashSet(userContentPropertyModels);
                }
            }
        }
        return result;
    }
}

