/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.restv2.model.mappers;

import com.comalatech.confluence.readack.model.ReadAck;
import com.comalatech.confluence.workflow.model.AbstractUserGroupApproverCondition;
import com.comalatech.confluence.workflow.model.Condition;
import com.comalatech.confluence.workflow.model.GroupCondition;
import com.comalatech.confluence.workflow.model.UserCondition;
import com.comalatech.confluence.workflow.restv2.model.RestItemList;
import com.comalatech.confluence.workflow.restv2.model.RestReadAck;
import com.comalatech.confluence.workflow.restv2.model.mappers.Mapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class ReadAckMapper
implements Mapper<ReadAck, RestReadAck> {
    @Override
    public RestReadAck toRest(ReadAck readAck) {
        RestReadAck restReadAck = new RestReadAck();
        restReadAck.dueDate = readAck.getDueDate();
        restReadAck.approverRequestOption = readAck.getApproverRequestOption();
        restReadAck.changeDueDate = readAck.isChangeDueDate();
        if (readAck.getConditions() != null && readAck.getConditions().size() > 0) {
            List<Condition> pendingConditions = this.toRestFlattenConditions(restReadAck, readAck);
            restReadAck.conditions = this.parseConditionsToRest(pendingConditions);
            if (restReadAck.conditions.isEmpty()) {
                restReadAck.conditions = null;
            }
        }
        return restReadAck;
    }

    @Override
    public ReadAck fromRest(RestReadAck restReadAck) {
        List<Condition> conditions = this.parseConditionsFromRest(restReadAck.conditions);
        conditions.addAll(this.fromRestUnflattenConditions(restReadAck));
        ReadAck readAck = new ReadAck(conditions);
        this.parseDueDateFromRest(restReadAck.dueDate, readAck);
        readAck.setChangeDueDate(restReadAck.changeDueDate);
        readAck.setApproverRequestOption(restReadAck.approverRequestOption);
        return readAck;
    }

    private List<Condition> toRestFlattenConditions(RestReadAck restReadAck, ReadAck readAck) {
        ArrayList<Condition> conditions = new ArrayList<Condition>(readAck.getConditions());
        Iterator i = conditions.iterator();
        while (i.hasNext()) {
            Condition condition = (Condition)i.next();
            if (condition instanceof UserCondition) {
                UserCondition userCondition = (UserCondition)condition;
                restReadAck.users = new RestItemList(userCondition.getUserNames());
                i.remove();
                continue;
            }
            if (!(condition instanceof GroupCondition)) continue;
            GroupCondition groupCondition = (GroupCondition)condition;
            restReadAck.groups = new RestItemList(groupCondition.getGroupNames());
            i.remove();
        }
        return conditions;
    }

    private Collection<? extends Condition> fromRestUnflattenConditions(RestReadAck restReadAck) {
        ArrayList<AbstractUserGroupApproverCondition> conditions = new ArrayList<AbstractUserGroupApproverCondition>();
        if (restReadAck.users != null && restReadAck.users.verifyContentValid() != null) {
            conditions.add(new UserCondition(false, StringUtils.join((Object[])restReadAck.users.items, (String)",")));
        }
        if (restReadAck.groups != null && restReadAck.groups.verifyContentValid() != null) {
            conditions.add(new GroupCondition(false, StringUtils.join((Object[])restReadAck.groups.items, (String)",")));
        }
        return conditions;
    }
}

