/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.restv2.model.mappers;

import com.atlassian.confluence.labels.Label;
import com.comalatech.confluence.workflow.WorkflowException;
import com.comalatech.confluence.workflow.model.AllowedAssignerGroupCondition;
import com.comalatech.confluence.workflow.model.AllowedAssignerUserCondition;
import com.comalatech.confluence.workflow.model.ApproverCondition;
import com.comalatech.confluence.workflow.model.Condition;
import com.comalatech.confluence.workflow.model.ExcludeCondition;
import com.comalatech.confluence.workflow.model.GroupCondition;
import com.comalatech.confluence.workflow.model.HasApprovalCondition;
import com.comalatech.confluence.workflow.model.HasLabelCondition;
import com.comalatech.confluence.workflow.model.HasPendingTasksCondition;
import com.comalatech.confluence.workflow.model.HasViewWorkflowPermission;
import com.comalatech.confluence.workflow.model.IsAssignmentCondition;
import com.comalatech.confluence.workflow.model.IsChildOfCondition;
import com.comalatech.confluence.workflow.model.IsHomePageCondition;
import com.comalatech.confluence.workflow.model.IsMinorChangeCondition;
import com.comalatech.confluence.workflow.model.IsOrphanCondition;
import com.comalatech.confluence.workflow.model.IsValueAsUserSetCondition;
import com.comalatech.confluence.workflow.model.MetadataCondition;
import com.comalatech.confluence.workflow.model.PageTitleCondition;
import com.comalatech.confluence.workflow.model.ParentHasLabelCondition;
import com.comalatech.confluence.workflow.model.PermissionCondition;
import com.comalatech.confluence.workflow.model.Selector;
import com.comalatech.confluence.workflow.model.SpaceKeyCondition;
import com.comalatech.confluence.workflow.model.StateCondition;
import com.comalatech.confluence.workflow.model.StateInDraftSpaceCondition;
import com.comalatech.confluence.workflow.model.StateInitializedCondition;
import com.comalatech.confluence.workflow.model.UserCondition;
import com.comalatech.confluence.workflow.restv2.model.RestCondition;
import com.comalatech.confluence.workflow.restv2.model.mappers.Mapper;
import com.comalatech.confluence.workflow.restv2.model.mappers.MapperException;
import com.comalatech.confluence.workflowcontainer.model.SerializableMacro;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConditionMapper
implements Mapper<Condition, RestCondition> {
    private static final Logger log = LoggerFactory.getLogger(ConditionMapper.class);

    @Override
    public RestCondition toRest(Condition condition) {
        if (condition instanceof ExcludeCondition) {
            return this.toRest((ExcludeCondition)condition);
        }
        if (condition instanceof AllowedAssignerGroupCondition) {
            return this.toRest((AllowedAssignerGroupCondition)condition);
        }
        if (condition instanceof AllowedAssignerUserCondition) {
            return this.toRest((AllowedAssignerUserCondition)condition);
        }
        if (condition instanceof UserCondition) {
            return this.toRest((UserCondition)condition);
        }
        if (condition instanceof GroupCondition) {
            return this.toRest((GroupCondition)condition);
        }
        if (condition instanceof HasViewWorkflowPermission) {
            return null;
        }
        if (condition instanceof ParentHasLabelCondition) {
            return this.toRest((ParentHasLabelCondition)condition);
        }
        if (condition instanceof HasLabelCondition) {
            return this.toRest((HasLabelCondition)condition);
        }
        if (condition instanceof HasApprovalCondition) {
            return this.toRest((HasApprovalCondition)condition);
        }
        if (condition instanceof ApproverCondition) {
            return this.toRest((ApproverCondition)condition);
        }
        if (condition instanceof StateInDraftSpaceCondition) {
            return this.toRest((StateInDraftSpaceCondition)condition);
        }
        if (condition instanceof StateCondition) {
            return this.toRest((StateCondition)condition);
        }
        if (condition instanceof StateInitializedCondition) {
            return this.toRest((StateInitializedCondition)condition);
        }
        if (condition instanceof IsValueAsUserSetCondition) {
            return this.toRest((IsValueAsUserSetCondition)condition);
        }
        if (condition instanceof PermissionCondition) {
            return this.toRest((PermissionCondition)condition);
        }
        if (condition instanceof PageTitleCondition) {
            return this.toRest((PageTitleCondition)condition);
        }
        if (condition instanceof IsHomePageCondition) {
            return this.toRest((IsHomePageCondition)condition);
        }
        if (condition instanceof IsOrphanCondition) {
            return this.toRest((IsOrphanCondition)condition);
        }
        if (condition instanceof IsChildOfCondition) {
            return this.toRest((IsChildOfCondition)condition);
        }
        if (condition instanceof IsAssignmentCondition) {
            return this.toRest((IsAssignmentCondition)condition);
        }
        if (condition instanceof IsMinorChangeCondition) {
            return this.toRest((IsMinorChangeCondition)condition);
        }
        if (condition instanceof HasPendingTasksCondition) {
            return this.toRest((HasPendingTasksCondition)condition);
        }
        if (condition instanceof SpaceKeyCondition) {
            return this.toRest((SpaceKeyCondition)condition);
        }
        if (condition instanceof MetadataCondition) {
            return this.toRest((MetadataCondition)condition);
        }
        log.warn("Unknown concrete Condition subclass: " + condition.getClass());
        return null;
    }

    @Override
    public Condition fromRest(RestCondition restCondition) {
        if (restCondition instanceof RestCondition.ExcludeCondition) {
            return this.fromRest((RestCondition.ExcludeCondition)restCondition);
        }
        if (restCondition instanceof RestCondition.AllowedAssignerGroupCondition) {
            return this.fromRest((RestCondition.AllowedAssignerGroupCondition)restCondition);
        }
        if (restCondition instanceof RestCondition.AllowedAssignerUserCondition) {
            return this.fromRest((RestCondition.AllowedAssignerUserCondition)restCondition);
        }
        if (restCondition instanceof RestCondition.UserCondition) {
            return this.fromRest((RestCondition.UserCondition)restCondition);
        }
        if (restCondition instanceof RestCondition.GroupCondition) {
            return this.fromRest((RestCondition.GroupCondition)restCondition);
        }
        if (restCondition instanceof RestCondition.HasViewWorkflowPermissionCondition) {
            return null;
        }
        if (restCondition instanceof RestCondition.HasLabelCondition) {
            return this.fromRest((RestCondition.HasLabelCondition)restCondition);
        }
        if (restCondition instanceof RestCondition.ParentHasLabelCondition) {
            return this.fromRest((RestCondition.ParentHasLabelCondition)restCondition);
        }
        if (restCondition instanceof RestCondition.HasApprovalCondition) {
            return this.fromRest((RestCondition.HasApprovalCondition)restCondition);
        }
        if (restCondition instanceof RestCondition.ApproverCondition) {
            return this.fromRest((RestCondition.ApproverCondition)restCondition);
        }
        if (restCondition instanceof RestCondition.StateCondition) {
            return this.fromRest((RestCondition.StateCondition)restCondition);
        }
        if (restCondition instanceof RestCondition.StateInDraftSpaceCondition) {
            return this.fromRest((RestCondition.StateInDraftSpaceCondition)restCondition);
        }
        if (restCondition instanceof RestCondition.StateInitializedCondition) {
            return this.fromRest((RestCondition.StateInitializedCondition)restCondition);
        }
        if (restCondition instanceof RestCondition.IsValueAsUserSetCondition) {
            return this.fromRest((RestCondition.IsValueAsUserSetCondition)restCondition);
        }
        if (restCondition instanceof RestCondition.PermissionCondition) {
            return this.fromRest((RestCondition.PermissionCondition)restCondition);
        }
        if (restCondition instanceof RestCondition.TitleCondition) {
            return this.fromRest((RestCondition.TitleCondition)restCondition);
        }
        if (restCondition instanceof RestCondition.IsHomePageCondition) {
            return this.fromRest((RestCondition.IsHomePageCondition)restCondition);
        }
        if (restCondition instanceof RestCondition.IsOrphanCondition) {
            return this.fromRest((RestCondition.IsOrphanCondition)restCondition);
        }
        if (restCondition instanceof RestCondition.IsChildOfCondition) {
            return this.fromRest((RestCondition.IsChildOfCondition)restCondition);
        }
        if (restCondition instanceof RestCondition.IsAssignmentCondition) {
            return this.fromRest((RestCondition.IsAssignmentCondition)restCondition);
        }
        if (restCondition instanceof RestCondition.IsMinorChangeCondition) {
            return this.fromRest((RestCondition.IsMinorChangeCondition)restCondition);
        }
        if (restCondition instanceof RestCondition.HasPendingTasksCondition) {
            return this.fromRest((RestCondition.HasPendingTasksCondition)restCondition);
        }
        if (restCondition instanceof RestCondition.SpaceCondition) {
            return this.fromRest((RestCondition.SpaceCondition)restCondition);
        }
        if (restCondition instanceof RestCondition.MetadataCondition) {
            return this.fromRest((RestCondition.MetadataCondition)restCondition);
        }
        log.warn("Unknown concrete RestCondition subclass: " + restCondition.getClass());
        return null;
    }

    @Override
    public RestCondition.PermissionCondition toRest(PermissionCondition condition) {
        return new RestCondition.PermissionCondition(condition.isNot() ? Boolean.valueOf(true) : null, Arrays.asList(condition.getPermissions()).stream().map(p -> p.toString()).collect(Collectors.joining(",")));
    }

    @Override
    public PermissionCondition fromRest(RestCondition.PermissionCondition restCondition) {
        try {
            return new PermissionCondition(BooleanUtils.isTrue((Boolean)restCondition.negate), restCondition.value);
        }
        catch (WorkflowException e) {
            throw new MapperException("Error creating PermissionException", e);
        }
    }

    @Override
    public RestCondition.ExcludeCondition toRest(ExcludeCondition excludeCondition) {
        return new RestCondition.ExcludeCondition(ConditionMapper.getMacro(excludeCondition).getParameterValue("exclude"));
    }

    @Override
    public ExcludeCondition fromRest(RestCondition.ExcludeCondition restCondition) {
        return new ExcludeCondition(restCondition.value);
    }

    @Override
    public RestCondition.UserCondition toRest(UserCondition condition) {
        return new RestCondition.UserCondition(condition.isNot() ? Boolean.valueOf(true) : null, ConditionMapper.join(condition.getUserNames()));
    }

    @Override
    public UserCondition fromRest(RestCondition.UserCondition restCondition) {
        return new UserCondition(BooleanUtils.isTrue((Boolean)restCondition.negate), restCondition.value);
    }

    @Override
    public RestCondition.GroupCondition toRest(GroupCondition condition) {
        return new RestCondition.GroupCondition(condition.isNot() ? Boolean.valueOf(true) : null, ConditionMapper.join(condition.getGroupNames()));
    }

    @Override
    public GroupCondition fromRest(RestCondition.GroupCondition restCondition) {
        return new GroupCondition(BooleanUtils.isTrue((Boolean)restCondition.negate), restCondition.value);
    }

    @Override
    public RestCondition.AllowedAssignerUserCondition toRest(AllowedAssignerUserCondition condition) {
        return new RestCondition.AllowedAssignerUserCondition(condition.isNot() ? Boolean.valueOf(true) : null, ConditionMapper.join(condition.getUserNames()));
    }

    @Override
    public AllowedAssignerUserCondition fromRest(RestCondition.AllowedAssignerUserCondition restCondition) {
        return new AllowedAssignerUserCondition(restCondition.negate, restCondition.value);
    }

    @Override
    public RestCondition.AllowedAssignerGroupCondition toRest(AllowedAssignerGroupCondition condition) {
        return new RestCondition.AllowedAssignerGroupCondition(condition.isNot() ? Boolean.valueOf(true) : null, ConditionMapper.join(condition.getGroupNames()));
    }

    @Override
    public AllowedAssignerGroupCondition fromRest(RestCondition.AllowedAssignerGroupCondition restCondition) {
        return new AllowedAssignerGroupCondition(restCondition.negate, restCondition.value);
    }

    @Override
    public RestCondition.HasViewWorkflowPermissionCondition toRest(HasViewWorkflowPermission condition) {
        return new RestCondition.HasViewWorkflowPermissionCondition(condition.isNot() ? Boolean.valueOf(true) : null);
    }

    @Override
    public HasViewWorkflowPermission fromRest(RestCondition.HasViewWorkflowPermissionCondition restCondition) {
        boolean isNegated = BooleanUtils.isTrue((Boolean)restCondition.negate);
        return new HasViewWorkflowPermission(isNegated, "true");
    }

    @Override
    public RestCondition.HasLabelCondition toRest(HasLabelCondition condition) {
        String labels = Arrays.asList(condition.getLabels()).stream().map(label -> label.getName()).collect(Collectors.joining(","));
        return new RestCondition.HasLabelCondition(condition.isNot() ? Boolean.valueOf(true) : null, labels);
    }

    @Override
    public HasLabelCondition fromRest(RestCondition.HasLabelCondition restCondition) {
        Label[] labels = (Label[])Arrays.asList(ConditionMapper.split(restCondition.value)).stream().map(labelName -> new Label(labelName)).toArray(Label[]::new);
        return new HasLabelCondition(BooleanUtils.isTrue((Boolean)restCondition.negate), labels);
    }

    @Override
    public RestCondition.ParentHasLabelCondition toRest(ParentHasLabelCondition condition) {
        String labels = Arrays.asList(condition.getLabels()).stream().map(label -> label.getName()).collect(Collectors.joining(","));
        return new RestCondition.ParentHasLabelCondition(condition.isNot() ? Boolean.valueOf(true) : null, labels);
    }

    @Override
    public ParentHasLabelCondition fromRest(RestCondition.ParentHasLabelCondition restCondition) {
        Label[] labels = (Label[])Arrays.asList(ConditionMapper.split(restCondition.value)).stream().map(labelName -> new Label(labelName)).toArray(Label[]::new);
        return new ParentHasLabelCondition(BooleanUtils.isTrue((Boolean)restCondition.negate), labels);
    }

    @Override
    public RestCondition.HasApprovalCondition toRest(HasApprovalCondition condition) {
        return new RestCondition.HasApprovalCondition(condition.isNot() ? Boolean.valueOf(true) : null, ConditionMapper.join(condition.getApprovalNames()), condition.isCurrent());
    }

    @Override
    public HasApprovalCondition fromRest(RestCondition.HasApprovalCondition restCondition) {
        return new HasApprovalCondition(BooleanUtils.isTrue((Boolean)restCondition.negate), restCondition.value, restCondition.current);
    }

    @Override
    public RestCondition.ApproverCondition toRest(ApproverCondition condition) {
        RestCondition.ApproverCondition restCondition = new RestCondition.ApproverCondition(condition.getSelector().getUsers());
        try {
            int selectorMinimum = Integer.parseInt(condition.getSelector().getMinimum());
            if (selectorMinimum > 0) {
                restCondition.minimum = condition.getSelector().getMinimum();
            }
        }
        catch (NumberFormatException ex) {
            restCondition.minimum = condition.getSelector().getMinimum();
        }
        switch (condition.getSelector().getType()) {
            case 3: {
                restCondition.approveType = RestCondition.ApproverCondition.ApproveType.ALL_APPROVE;
                break;
            }
            case 0: {
                restCondition.approveType = RestCondition.ApproverCondition.ApproveType.ANY_APPROVE;
                break;
            }
            case 1: {
                restCondition.approveType = RestCondition.ApproverCondition.ApproveType.ONE_APPROVE;
                break;
            }
            case 2: {
                restCondition.approveType = RestCondition.ApproverCondition.ApproveType.ONE_OR_MANY_APPROVE;
            }
        }
        restCondition.conditionType = condition.getConditionType().toString();
        return restCondition;
    }

    @Override
    public ApproverCondition fromRest(RestCondition.ApproverCondition restCondition) {
        int type = 0;
        switch (restCondition.approveType) {
            case ALL_APPROVE: {
                type = 3;
                break;
            }
            case ANY_APPROVE: {
                type = 0;
                break;
            }
            case ONE_APPROVE: {
                type = 1;
                break;
            }
            case ONE_OR_MANY_APPROVE: {
                type = 2;
            }
        }
        Selector selector = new Selector(restCondition.value, type, restCondition.minimum);
        return new ApproverCondition(selector, ApproverCondition.ApproverConditionType.fromString(restCondition.conditionType));
    }

    @Override
    public RestCondition.StateCondition toRest(StateCondition condition) {
        return new RestCondition.StateCondition(condition.isNot() ? Boolean.valueOf(true) : null, ConditionMapper.join(condition.getStates()));
    }

    @Override
    public StateCondition fromRest(RestCondition.StateCondition restCondition) {
        return new StateCondition(BooleanUtils.isTrue((Boolean)restCondition.negate), restCondition.value);
    }

    @Override
    public RestCondition.StateInDraftSpaceCondition toRest(StateInDraftSpaceCondition condition) {
        return new RestCondition.StateInDraftSpaceCondition(condition.isNot() ? Boolean.valueOf(true) : null, ConditionMapper.join(condition.getStates()));
    }

    @Override
    public StateInDraftSpaceCondition fromRest(RestCondition.StateInDraftSpaceCondition restCondition) {
        return new StateInDraftSpaceCondition(BooleanUtils.isTrue((Boolean)restCondition.negate), restCondition.value);
    }

    @Override
    public RestCondition.StateInitializedCondition toRest(StateInitializedCondition condition) {
        return new RestCondition.StateInitializedCondition(condition.isNot() ? Boolean.valueOf(true) : null);
    }

    @Override
    public StateInitializedCondition fromRest(RestCondition.StateInitializedCondition restCondition) {
        return new StateInitializedCondition(BooleanUtils.isTrue((Boolean)restCondition.negate), "true");
    }

    @Override
    public RestCondition.IsValueAsUserSetCondition toRest(IsValueAsUserSetCondition condition) {
        return new RestCondition.IsValueAsUserSetCondition(condition.isNot() ? Boolean.valueOf(true) : null, ConditionMapper.join(condition.getValueNames()));
    }

    @Override
    public IsValueAsUserSetCondition fromRest(RestCondition.IsValueAsUserSetCondition restCondition) {
        return new IsValueAsUserSetCondition(BooleanUtils.isTrue((Boolean)restCondition.negate), restCondition.value);
    }

    @Override
    public RestCondition.TitleCondition toRest(PageTitleCondition condition) {
        return new RestCondition.TitleCondition(condition.isNot() ? Boolean.valueOf(true) : null, condition.getTitle());
    }

    @Override
    public PageTitleCondition fromRest(RestCondition.TitleCondition restCondition) {
        return new PageTitleCondition(BooleanUtils.isTrue((Boolean)restCondition.negate), restCondition.value);
    }

    @Override
    public RestCondition.IsHomePageCondition toRest(IsHomePageCondition condition) {
        return new RestCondition.IsHomePageCondition(condition.isNot() ? Boolean.valueOf(true) : null);
    }

    @Override
    public IsHomePageCondition fromRest(RestCondition.IsHomePageCondition restCondition) {
        return new IsHomePageCondition(BooleanUtils.isTrue((Boolean)restCondition.negate), "true");
    }

    @Override
    public RestCondition.IsOrphanCondition toRest(IsOrphanCondition condition) {
        return new RestCondition.IsOrphanCondition(condition.isNot() ? Boolean.valueOf(true) : null);
    }

    @Override
    public IsOrphanCondition fromRest(RestCondition.IsOrphanCondition restCondition) {
        return new IsOrphanCondition(BooleanUtils.isTrue((Boolean)restCondition.negate), "true");
    }

    @Override
    public RestCondition.IsChildOfCondition toRest(IsChildOfCondition condition) {
        return new RestCondition.IsChildOfCondition(condition.isNot() ? Boolean.valueOf(true) : null, condition.getParentName());
    }

    @Override
    public IsChildOfCondition fromRest(RestCondition.IsChildOfCondition restCondition) {
        return new IsChildOfCondition(BooleanUtils.isTrue((Boolean)restCondition.negate), restCondition.value);
    }

    @Override
    public RestCondition.IsAssignmentCondition toRest(IsAssignmentCondition condition) {
        return new RestCondition.IsAssignmentCondition(condition.isNot() ? Boolean.valueOf(true) : null);
    }

    @Override
    public IsAssignmentCondition fromRest(RestCondition.IsAssignmentCondition restCondition) {
        return new IsAssignmentCondition(BooleanUtils.isTrue((Boolean)restCondition.negate), "true");
    }

    @Override
    public RestCondition.IsMinorChangeCondition toRest(IsMinorChangeCondition condition) {
        return new RestCondition.IsMinorChangeCondition(condition.isNot() ? Boolean.valueOf(true) : null);
    }

    @Override
    public IsMinorChangeCondition fromRest(RestCondition.IsMinorChangeCondition restCondition) {
        return new IsMinorChangeCondition(BooleanUtils.isTrue((Boolean)restCondition.negate), "true");
    }

    @Override
    public RestCondition.HasPendingTasksCondition toRest(HasPendingTasksCondition condition) {
        return new RestCondition.HasPendingTasksCondition(condition.isNot() ? Boolean.valueOf(true) : null);
    }

    @Override
    public HasPendingTasksCondition fromRest(RestCondition.HasPendingTasksCondition restCondition) {
        return new HasPendingTasksCondition(BooleanUtils.isTrue((Boolean)restCondition.negate), "true");
    }

    @Override
    public RestCondition.SpaceCondition toRest(SpaceKeyCondition condition) {
        return new RestCondition.SpaceCondition(condition.isNot() ? Boolean.valueOf(true) : null, condition.getSpaceKey());
    }

    @Override
    public SpaceKeyCondition fromRest(RestCondition.SpaceCondition restCondition) {
        return new SpaceKeyCondition(BooleanUtils.isTrue((Boolean)restCondition.negate), restCondition.value);
    }

    @Override
    public RestCondition.MetadataCondition toRest(MetadataCondition condition) {
        return new RestCondition.MetadataCondition(condition.isNot() ? Boolean.valueOf(true) : null, condition.getReferredValue(), condition.getComparedValue(), condition.isGreaterThan() ? Boolean.valueOf(true) : null, condition.isLessThan() ? Boolean.valueOf(true) : null, condition.isSupplierReference() ? Boolean.valueOf(true) : null);
    }

    @Override
    public MetadataCondition fromRest(RestCondition.MetadataCondition restCondition) {
        return new MetadataCondition(BooleanUtils.isTrue((Boolean)restCondition.negate), restCondition.value, restCondition.comparedValue, BooleanUtils.isTrue((Boolean)restCondition.greaterThan), BooleanUtils.isTrue((Boolean)restCondition.lessThan), BooleanUtils.isTrue((Boolean)restCondition.supplierReference));
    }

    private static String[] split(String str) {
        return StringUtils.split((String)str, (String)",");
    }

    private static String join(String[] str) {
        return StringUtils.join((Object[])str, (String)",");
    }

    private static SerializableMacro getMacro(Condition condition) {
        SerializableMacro macro = new SerializableMacro();
        condition.addMacroParameters(macro);
        return macro;
    }
}

