/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.macros.actions;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.core.util.DateUtils;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.macro.MacroException;
import com.atlassian.user.Group;
import com.comalatech.confluence.messaging.Message;
import com.comalatech.confluence.messaging.PageMessageManager;
import com.comalatech.confluence.timers.TimerUtils;
import com.comalatech.confluence.workflow.ValueReferenceResolver;
import com.comalatech.confluence.workflow.ValueStore;
import com.comalatech.confluence.workflow.WorkflowException;
import com.comalatech.confluence.workflow.macros.actions.AbstractMessageMacro;
import com.opensymphony.util.TextUtils;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetMessageMacro
extends AbstractMessageMacro {
    private static final Logger log = LoggerFactory.getLogger(SetMessageMacro.class);
    public static final String MACRO_NAME = "set-message";
    @Deprecated
    public static final String PARAM_0 = "0";
    public static final String PARAM_USER = "user";
    public static final String PARAM_GROUP = "group";
    public static final String PARAM_DURATION = "duration";
    public static final String PARAM_STYLE = "style";
    public static final String PARAM_TITLE = "title";
    public static final String PARAM_VIEW = "view";

    @Override
    protected String getName() {
        return MACRO_NAME;
    }

    public String execute(Map parameters, String body, RenderContext renderContext) throws MacroException {
        long duration;
        AbstractPage page = (AbstractPage)((PageContext)renderContext).getEntity();
        String userName = (String)parameters.get(PARAM_0);
        if (!TextUtils.stringSet((String)userName)) {
            userName = (String)parameters.get(PARAM_USER);
        }
        String group = (String)parameters.get(PARAM_GROUP);
        String strDuration = (String)parameters.get(PARAM_DURATION);
        String style = (String)parameters.get(PARAM_STYLE);
        String view = (String)parameters.get(PARAM_VIEW);
        if (TextUtils.stringSet((String)strDuration)) {
            try {
                duration = TimerUtils.parsePeriod(strDuration).toStandardSeconds().getSeconds();
            }
            catch (Exception e) {
                try {
                    duration = DateUtils.getDuration((String)strDuration);
                }
                catch (Exception e2) {
                    throw new MacroException("Invalid Period " + strDuration + ". It must follow ISO8601 Duration Format");
                }
            }
        } else {
            duration = TextUtils.stringSet((String)userName) || TextUtils.stringSet((String)group) ? 0L : Long.MAX_VALUE;
        }
        if (TextUtils.stringSet((String)style)) {
            if (!Message.isValidStyle(style)) {
                throw new MacroException("invalid style " + style + " it should be any of " + Message.VALID_STYLES_ERRORMSG);
            }
        } else {
            style = "info";
        }
        String title = (String)parameters.get(PARAM_TITLE);
        if (!this.inExecuteMode(renderContext)) {
            return "";
        }
        if (TextUtils.stringSet((String)view)) {
            if (!Message.isValidMessageView(view)) {
                throw new MacroException("invalid message view '" + view + "' it should be any of " + Message.VALID_VIEW_MODES_ERRORMSG);
            }
        } else {
            view = null;
        }
        try {
            body = body.trim();
            String wikiMessage = Message.MacroParamStyle.CAPTION.param.equals(style) ? this.replaceReferences(renderContext, body) : this.renderMessageBody(renderContext, PageMessageManager.RENDER_MODE, body);
            if (SetMessageMacro.hasError(wikiMessage)) {
                throw new WorkflowException(wikiMessage);
            }
            boolean existsUserName = TextUtils.stringSet((String)userName);
            boolean existsGroup = TextUtils.stringSet((String)group);
            if (existsUserName || existsGroup) {
                if (existsUserName) {
                    ConfluenceUser[] users;
                    if (userName.equalsIgnoreCase(PARAM_USER)) {
                        users = new ConfluenceUser[]{AuthenticatedUserThreadLocal.get()};
                    } else {
                        ConfluenceUser[] valueStore = (ConfluenceUser[])renderContext.getParam((Object)"valueStore");
                        users = this.usersListResolver.getValueAsUsers((ValueReferenceResolver)valueStore, valueStore.getPage(), userName);
                    }
                    for (ConfluenceUser user : users) {
                        this.pageMessageManager.setMessage(page, title, user, wikiMessage, style, duration, view);
                    }
                }
                if (existsGroup) {
                    ValueStore valueStore = (ValueStore)renderContext.getParam((Object)"valueStore");
                    List<Group> groups = this.usersListResolver.getValueAsGroups(valueStore, group);
                    for (Group g : groups) {
                        this.pageMessageManager.setMessage(page, title, g, wikiMessage, style, duration, view);
                    }
                }
            } else {
                this.pageMessageManager.setMessage(page, title, wikiMessage, style, duration, view);
            }
        }
        catch (Exception e) {
            log.error("Error on page " + page.getId() + ": " + e.getMessage(), (Throwable)e);
            this.logMessage(renderContext, e);
        }
        return "";
    }
}

