/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.util;

import com.atlassian.confluence.spring.transaction.interceptor.TransactionalHostContextAccessor;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class ReadWriteTransactionService {
    private static final Logger log = LoggerFactory.getLogger(ReadWriteTransactionService.class);
    TransactionalHostContextAccessor transactionalHostContextAccessor;

    public ReadWriteTransactionService(TransactionalHostContextAccessor transactionalHostContextAccessor) {
        this.transactionalHostContextAccessor = transactionalHostContextAccessor;
    }

    public <T> T executeInReadWriteTransaction(Supplier<T> callback) {
        if (TransactionSynchronizationManager.isActualTransactionActive() && !TransactionSynchronizationManager.isCurrentTransactionReadOnly()) {
            log.debug("Detected existing read-write transaction");
            return callback.get();
        }
        log.debug("Running within a readonly transaction, propagating new read/write transaction");
        return this.wrapInTransaction(callback);
    }

    private <T> T wrapInTransaction(Supplier<T> callback) {
        return (T)this.transactionalHostContextAccessor.doInTransaction(TransactionalHostContextAccessor.Propagation.REQUIRES_NEW, TransactionalHostContextAccessor.Permission.READ_WRITE, () -> callback.get());
    }
}

