/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.readack.actions;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.spaces.actions.AbstractSpaceAction;
import com.atlassian.confluence.util.longrunning.LongRunningTaskId;
import com.atlassian.fugue.Either;
import com.comalatech.confluence.adhoc.dao.ComalatechBandanaContext;
import com.comalatech.confluence.upgrade.readConfirmation.migration.ReadConfirmationDataMigration;
import com.comalatech.confluence.upgrade.readConfirmation.migration.status.ReadConfirmationMigrationStatusManager;
import com.comalatech.confluence.upgrade.readConfirmation.migration.status.ReadConfirmationMigrationTableCheck;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrateDeprecatedReadConfirmationRecordsAction
extends AbstractSpaceAction {
    private static final Logger log = LoggerFactory.getLogger(MigrateDeprecatedReadConfirmationRecordsAction.class);
    private LongRunningTaskId longRunningTaskId;
    private ReadConfirmationDataMigration readConfirmationDataMigration;
    private ReadConfirmationMigrationStatusManager readConfirmationMigrationStatusManager;
    private BandanaManager bandanaManager;
    private boolean tableExist = false;
    private ReadConfirmationMigrationTableCheck.MigrationState migrationStatus;
    private String previousTablesErrors = "";

    public String askForMigrationConfirmation() {
        this.migrationStatus = (ReadConfirmationMigrationTableCheck.MigrationState)this.bandanaManager.getValue((BandanaContext)ComalatechBandanaContext.COMALATECH_CONTEXT, "com.comalatech.workflows.readConfirmation.migration", false);
        if (this.migrationStatus == null) {
            this.migrationStatus = new ReadConfirmationMigrationTableCheck.MigrationState(ReadConfirmationMigrationTableCheck.MigrationState.STATUS.PENDING);
        }
        Either<Boolean, Exception> previousTableAvailable = this.readConfirmationMigrationStatusManager.isPreviousTableAvailable();
        previousTableAvailable.left().map(this::countRecords).right().map(s -> {
            this.previousTablesErrors = s.getMessage();
            return this.previousTablesErrors;
        });
        return "success";
    }

    public String execute() {
        try {
            this.longRunningTaskId = this.readConfirmationDataMigration.launchMigrationTask();
            log.info("Running ReadConfirmation Migration task with id {} ", (Object)this.longRunningTaskId.asLongTaskId());
        }
        catch (Exception e) {
            log.error("Error executing Read Conformation Migration task", (Throwable)e);
        }
        return "success";
    }

    private Boolean countRecords(Boolean tableIsAvailable) {
        this.tableExist = tableIsAvailable;
        if (this.tableExist) {
            this.readConfirmationMigrationStatusManager.getNumberOfRecordToMigrate().right().map(s -> {
                this.previousTablesErrors = s.getMessage();
                return this.previousTablesErrors;
            }).left().map(this::updateMigrationStatus);
        }
        return tableIsAvailable;
    }

    private Integer updateMigrationStatus(Integer integer) {
        if (this.migrationStatus.getNumRecords() == null) {
            this.migrationStatus.setNumRecords(integer);
        } else if (integer != null && integer != 0) {
            this.migrationStatus.setNumRecords(integer);
        }
        return integer;
    }

    public String getTaskId() {
        if (this.longRunningTaskId != null) {
            return this.longRunningTaskId.toString();
        }
        return "";
    }

    public void setReadConfirmationDataMigration(ReadConfirmationDataMigration readConfirmationDataMigration) {
        this.readConfirmationDataMigration = readConfirmationDataMigration;
    }

    public void setReadConfirmationMigrationStatusManager(ReadConfirmationMigrationStatusManager readConfirmationMigrationStatusManager) {
        this.readConfirmationMigrationStatusManager = readConfirmationMigrationStatusManager;
    }

    public void setBandanaManager(BandanaManager bandanaManager) {
        this.bandanaManager = bandanaManager;
    }

    public boolean isTableExist() {
        return this.tableExist;
    }

    public ReadConfirmationMigrationTableCheck.MigrationState getMigrationStatus() {
        return this.migrationStatus;
    }

    public void setMigrationStatus(ReadConfirmationMigrationTableCheck.MigrationState migrationStatus) {
        this.migrationStatus = migrationStatus;
    }

    public String getPreviousTablesErrors() {
        return this.previousTablesErrors;
    }
}

