/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.documentActivity.mapper.approval;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.comalatech.confluence.documentActivity.domain.entities.Activity;
import com.comalatech.confluence.documentActivity.mapper.approval.ApprovalApprovedMapper;
import com.comalatech.confluence.documentActivity.mapper.approval.ApprovalAssignedMapper;
import com.comalatech.confluence.documentActivity.mapper.approval.ApprovalRejectedMapper;
import com.comalatech.confluence.documentActivity.mapper.approval.ApprovalUnassignedMapper;
import com.comalatech.confluence.documentActivity.util.ActorUtils;
import com.comalatech.confluence.states.model.PageState;
import com.comalatech.confluence.workflow.model.ApprovalCheck;
import com.comalatech.confluence.workflow.model.Approver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ApprovalsMapper {
    private final PageManager pageManager;
    private final ApprovalApprovedMapper approvalApprovedMapper;
    private final ApprovalAssignedMapper approvalAssignedMapper;
    private final ApprovalRejectedMapper approvalRejectedMapper;
    private final ApprovalUnassignedMapper approvalUnassignedMapper;

    public ApprovalsMapper(PageManager pageManager, ActorUtils actorUtils) {
        this.pageManager = pageManager;
        this.approvalApprovedMapper = new ApprovalApprovedMapper(actorUtils);
        this.approvalAssignedMapper = new ApprovalAssignedMapper(actorUtils);
        this.approvalRejectedMapper = new ApprovalRejectedMapper(actorUtils);
        this.approvalUnassignedMapper = new ApprovalUnassignedMapper(actorUtils);
    }

    public List<Activity> buildApprovalActivities(PageState state, ApprovalCheck approvalCheck) throws Exception {
        ArrayList<Activity> activities = new ArrayList<Activity>();
        AbstractPage page = state.getPage();
        ContentEntityObject content = this.pageManager.getOtherVersion((ContentEntityObject)page, approvalCheck.getVersion());
        List<Approver> approvers = Arrays.asList(approvalCheck.getApprovers());
        if (!approvers.isEmpty()) {
            for (Approver approver : approvers) {
                if (approver.isApproved()) {
                    activities.add(this.approvalApprovedMapper.buildActivity((AbstractPage)content, state, approvalCheck, approver));
                    continue;
                }
                activities.add(this.approvalRejectedMapper.buildActivity((AbstractPage)content, state, approvalCheck, approver));
            }
        }
        content = this.pageManager.getOtherVersion((ContentEntityObject)page, state.getVersion());
        List<ApprovalCheck.AssigneeHistory> assignments = approvalCheck.getAssigneeHistory();
        if (assignments != null && !assignments.isEmpty()) {
            for (ApprovalCheck.AssigneeHistory assignment : assignments) {
                if (ApprovalCheck.AssigneeHistoryType.ASSIGNMENT.equals((Object)assignment.getType())) {
                    if (assignment.getAssignee() == null) continue;
                    activities.add(this.approvalAssignedMapper.buildActivity((AbstractPage)content, state, approvalCheck, assignment));
                    continue;
                }
                if (!ApprovalCheck.AssigneeHistoryType.UNASSIGNMENT.equals((Object)assignment.getType()) || assignment.getAssignee() == null) continue;
                activities.add(this.approvalUnassignedMapper.buildActivity((AbstractPage)content, approvalCheck, state, assignment));
            }
        }
        return activities;
    }
}

