/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.documentActivity.mapper.approval;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.event.events.ConfluenceEvent;
import com.atlassian.confluence.pages.AbstractPage;
import com.comalatech.confluence.documentActivity.domain.entities.Action;
import com.comalatech.confluence.documentActivity.domain.entities.ActionDetail;
import com.comalatech.confluence.documentActivity.domain.entities.ActionDetails;
import com.comalatech.confluence.documentActivity.domain.entities.ActionType;
import com.comalatech.confluence.documentActivity.domain.entities.Activity;
import com.comalatech.confluence.documentActivity.domain.entities.Actor;
import com.comalatech.confluence.documentActivity.mapper.EventActivityMapper;
import com.comalatech.confluence.documentActivity.mapper.GenericEventActivityMapper;
import com.comalatech.confluence.documentActivity.util.ActorUtils;
import com.comalatech.confluence.states.model.PageState;
import com.comalatech.confluence.workflow.WorkflowUserException;
import com.comalatech.confluence.workflow.events.BlogPostApprovalApproveEvent;
import com.comalatech.confluence.workflow.events.PageApprovalApproveEvent;
import com.comalatech.confluence.workflow.model.ApprovalCheck;
import com.comalatech.confluence.workflow.model.Approver;
import com.comalatech.workflow.model.SignatureType;

public class ApprovalApprovedMapper
extends GenericEventActivityMapper
implements EventActivityMapper {
    public ApprovalApprovedMapper(ActorUtils actorUtils) {
        super(actorUtils);
    }

    @Override
    public Activity map(ConfluenceEvent event) throws WorkflowUserException {
        BlogPostApprovalApproveEvent blogPostApprovalApproveEvent;
        if (event instanceof PageApprovalApproveEvent) {
            PageApprovalApproveEvent pageApprovalApproveEvent = (PageApprovalApproveEvent)event;
            if (pageApprovalApproveEvent.isPartial()) {
                return this.buildActivity(pageApprovalApproveEvent.getAbstractPage(), pageApprovalApproveEvent.getState(), pageApprovalApproveEvent.getApprovalCheck(), pageApprovalApproveEvent.getApprovalCheck().getLastApprover());
            }
        } else if (event instanceof BlogPostApprovalApproveEvent && (blogPostApprovalApproveEvent = (BlogPostApprovalApproveEvent)event).isPartial()) {
            return this.buildActivity(blogPostApprovalApproveEvent.getAbstractPage(), blogPostApprovalApproveEvent.getState(), blogPostApprovalApproveEvent.getApprovalCheck(), blogPostApprovalApproveEvent.getApprovalCheck().getLastApprover());
        }
        return null;
    }

    protected Activity buildActivity(AbstractPage abstractPage, PageState state, ApprovalCheck approvalCheck, Approver approver) throws WorkflowUserException {
        Actor actor = this.actorUtils.buildActor(approver.getPerformer());
        ActionDetails details = this.buildApprovalsActionDetails(approvalCheck.getName(), approvalCheck.getId(), approver.getComment());
        if (approver != null && approver.getSignatureType() != SignatureType.NONE) {
            details.addDetail(ActionDetail.Type.APPROVAL_SIGNATURE_MODE, approver.getESignature().toString());
            details.addDetail(ActionDetail.Type.APPROVAL_SIGNATURE_TYPE, approver.getSignatureType().toString());
        }
        details.addAll(this.buildRoleNameActionDetails(approver.getRole()));
        details.addAll(this.buildStateActionDetails(state));
        Action action = new Action(new ActionType(ActionType.Type.APPROVAL, ActionType.Subtype.APPROVAL_APPROVED), actor, details);
        return new Activity(ApprovalApprovedMapper.buildTarget((ContentEntityObject)abstractPage), approver.getDate().getTime(), action);
    }
}

