/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.cloud.migration.usecases.listener;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.migration.app.tracker.AccessScope;
import com.atlassian.migration.app.tracker.CloudMigrationAccessor;
import com.atlassian.migration.app.tracker.CloudMigrationListenerV1;
import com.atlassian.migration.app.tracker.MigrationDetailsV1;
import com.atlassian.migration.app.tracker.PaginatedContainers;
import com.atlassian.migration.app.tracker.container.ConfluenceSpaceContainerV1;
import com.atlassian.migration.app.tracker.container.ContainerType;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.comalatech.confluence.cloud.migration.entity.domain.migration.Migration;
import com.comalatech.confluence.cloud.migration.entity.domain.migration.MigrationEntity;
import com.comalatech.confluence.cloud.migration.usecases.accessor.LocalCloudMigrationAccessor;
import com.comalatech.confluence.cloud.migration.usecases.contracts.GenerateCloudMappings;
import com.comalatech.confluence.cloud.migration.usecases.contracts.GeneratePageActivityMigrationData;
import com.comalatech.confluence.cloud.migration.usecases.contracts.Presenter;
import com.comalatech.confluence.documentActivity.domain.entities.Activity;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PreDestroy;
import org.apache.commons.io.IOUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Qualifier;

public class WorkflowsCloudMigrationListener
implements CloudMigrationListenerV1,
InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(WorkflowsCloudMigrationListener.class);
    private CloudMigrationAccessor accessor;
    private final PluginLicenseManager licenseManager;
    private final Presenter<File> fileJsonPresenter;
    private final Presenter<String> jsonPresenter;
    private final GeneratePageActivityMigrationData pageActivityGeneratorUseCase;
    private final GenerateCloudMappings generateCloudMappings;
    private final ObjectMapper objectMapper;
    private static final int SPACE_CONTAINERS_BATCH = 50;

    public WorkflowsCloudMigrationListener(LocalCloudMigrationAccessor accessor, PluginLicenseManager pluginLicenseManager, @Qualifier(value="fileJsonPresenter") Presenter<File> fileJsonPresenter, @Qualifier(value="jsonPresenter") Presenter<String> jsonPresenter, GeneratePageActivityMigrationData generatePageActivity, GenerateCloudMappings generateCloudMappings) {
        this.accessor = accessor.getCloudMigrationAccessor();
        this.licenseManager = pluginLicenseManager;
        this.fileJsonPresenter = fileJsonPresenter;
        this.jsonPresenter = jsonPresenter;
        this.pageActivityGeneratorUseCase = generatePageActivity;
        this.generateCloudMappings = generateCloudMappings;
        this.objectMapper = new ObjectMapper();
    }

    @Override
    public void onRegistrationAccepted() {
        log.info("Nice! The migration listener is ready to take migrations events");
    }

    @Override
    public void onStartAppMigration(String transferId, MigrationDetailsV1 migrationDetails) {
        try {
            List<MigrationEntity> migrationEntities;
            log.info("Migration context summary: " + this.objectMapper.writeValueAsString((Object)migrationDetails));
            HashMap<AbstractPage, List<Activity>> pageActivitiesMap = new HashMap<AbstractPage, List<Activity>>();
            PaginatedContainers paginatedSiteContainers = this.accessor.getCloudMigrationGateway().getPaginatedContainers(transferId, ContainerType.ConfluenceSpace, 50);
            while (paginatedSiteContainers.next()) {
                List<String> spaceKeys = paginatedSiteContainers.getContainers().stream().filter(container -> container instanceof ConfluenceSpaceContainerV1).map(container -> ((ConfluenceSpaceContainerV1)container).getKey()).collect(Collectors.toList());
                pageActivitiesMap.putAll(this.pageActivityGeneratorUseCase.generatePageCurrentActivityForSpace(spaceKeys));
            }
            Migration migration = this.generateCloudMappings.generateMigrationData(pageActivitiesMap, transferId);
            if (log.isDebugEnabled() && (migrationEntities = migration.migrationEntities) != null) {
                log.debug("Number of entities to send:" + migrationEntities.size());
                for (MigrationEntity entity : migrationEntities) {
                    if (entity == null) continue;
                    log.debug("Activities for migration entity: " + entity.getContentId());
                    Set<com.comalatech.confluence.cloud.migration.entity.domain.activity.Activity> activities = entity.getActivities();
                    for (com.comalatech.confluence.cloud.migration.entity.domain.activity.Activity activity : activities) {
                        log.debug("Activity: " + this.jsonPresenter.present(activity));
                    }
                }
            }
            File jsonActivities = this.fileJsonPresenter.present(migration);
            log.info("Sending {} bytes of data for transferId {} ", (Object)jsonActivities.length(), (Object)transferId);
            this.sendActivitiesToMigrationService(transferId, jsonActivities);
        }
        catch (Exception e) {
            log.error("Error during the migration process", (Throwable)e);
        }
    }

    private void sendActivitiesToMigrationService(String transferId, File jsonActivities) throws IOException {
        OutputStream atlassianMigrationDataStream = this.accessor.getCloudMigrationGateway().createAppData(transferId);
        FileInputStream activitiesDataStream = new FileInputStream(jsonActivities);
        IOUtils.copy((InputStream)activitiesDataStream, (OutputStream)atlassianMigrationDataStream);
        atlassianMigrationDataStream.close();
    }

    @Override
    public void onRegistrarRemoved() {
        log.info("The listener is no longer active");
    }

    @Override
    public String getCloudAppKey() {
        return this.licenseManager.getPluginKey();
    }

    @Override
    public String getServerAppKey() {
        return this.licenseManager.getPluginKey();
    }

    @Override
    public Set<AccessScope> getDataAccessScopes() {
        return Stream.of(AccessScope.APP_DATA_OTHER, AccessScope.PRODUCT_DATA_OTHER, AccessScope.MIGRATION_TRACING_PRODUCT, AccessScope.MIGRATION_TRACING_IDENTITY).collect(Collectors.toCollection(HashSet::new));
    }

    public void afterPropertiesSet() {
        this.accessor.registerListener(this);
    }

    public void destroy() {
        this.unregister();
    }

    @PreDestroy
    public void shutdown() {
        this.unregister();
    }

    private void unregister() {
        if (this.accessor != null) {
            this.accessor.deregisterListener(this);
            this.accessor = null;
        }
    }
}

