/*
 * Copyright (c) 2022 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

var AWP = AWP || {};

jQuery(document).ready(function() {
    jQuery(".workflow-selection").change(changeCustomWorkflow);
});

function changeCustomWorkflow() {
    if (jQuery("input[name='workflowId']:checked").val() == "empty") {
        jQuery("#initialStateName").removeAttr("disabled");
    } else {
        jQuery("#initialStateName").attr("disabled","disabled");
    }
}

function getContextPath() {
    return jQuery("#confluence-context-path").attr("content") || "";
}

function makeAction(actionName) {
    var cpath = getContextPath();
    return cpath + "/plugins/approvalsworkflow/" + actionName + ".action";
}

function makeSafeAction(url, params){
    var query = params && params.length > 0 ? params : '';
    return url + "?atl_token=" + AJS.params.atlToken + "&" + query;
}

// actual workflow designer

jQuery.fn.extend({
    isDebug : function() {
        return window.location.href.indexOf("debug=true") >= 0;
    },

    taskName : function() {
        return jQuery(this).find("input[name='taskName']");
    },
    newTaskName : function() {
        return jQuery(this).find("input[name='newTaskName']");
    },
    stateName : function() {
        return jQuery(this).find("input[name='stateName']");
    },
    updatedStateName  : function() {
        return jQuery(this).find("input[name='updatedStateName']");
    },
    position : function() {
        return jQuery(this).find("input[name='position']");
    },
    operation : function() {
        return jQuery(this).find("input[name='operation']").val();
    },

    updatedState : function() {
        return jQuery(this).find("input[name='updatedState']");
    },

    completedState : function() {
        return jQuery(this).find("input[name='completedState']");
    },

    expiredState : function() {
        return jQuery(this).find("input[name='expiredState']");
    },

    updatedStateSelection : function() {
        return jQuery(this).find("select[name='updatedState']");
    },

    completedStateSelection : function() {
        return jQuery(this).find("select[name='completedState']");
    },

    expiredStateSelection : function() {
        return jQuery(this).find("select[name='expiredState']");
    },

    stateSelected : function() {
        var selected = jQuery(this).find("option:selected");
        if (selected.length == 0) {
            return "";
        } else {
            return selected.html();
        }
    },

    errorMessage : function(response, responseStatus) {
        var messageBox = jQuery(this).find(".workflowMessage:first");
        if (response != undefined && response.message) {
            messageBox.html(AWP.Templates.Designer.message({msg : response.message}));
        } else if (response.actionErrors) {
            messageBox.html(response.actionErrors[0]); // action errror are escaped
        } else {
            messageBox.html("error connecting to server (" + responseStatus + ")");
        }
        messageBox.addClass("show errorMessage");
    },

    showErrorMessage: function(message) {
        var messageBox = jQuery(this).find(".workflowMessage:first");
        messageBox.html(AWP.Templates.Designer.message({msg : message}));
        messageBox.addClass("show errorMessage");
    },

    successMessage : function(message) {
        var messageBox = jQuery(this).find(".workflowMessage:first");
        messageBox.html(AWP.Templates.Designer.message({msg : message}));
        messageBox.removeClass("show errorMessage");
        messageBox.addClass("show successMessage");
        setTimeout(function() {
            messageBox.removeClass("show successMessage");
        },2000);
    },

    setStatesOptions : function(selectedState) {
        var jthis = jQuery(this);
        var state = jthis.parents("li.state");
        jthis.html("");
        jthis.append("<option value=''></option>");
        jQuery("#states input[name='stateName'].state").each(function() {
            var stateName = jQuery(this).val();
            if (stateName != state.stateName().val()) {
                jthis.append("<option" + (stateName == selectedState ? " selected='selected'" : "")+ ">"+ stateName + "</option>");
            }
        });
    },

    doWorkflowOperation : function() {
        var operation = jQuery(this).operation();
        if (operation == "addstate") {
            jQuery(this).disableInput();
            jQuery("#newelements").find("li.state").addClass("new").clone().appendTo(jQuery("#states"));
            var newState = jQuery("#states li.state.new");
            newState.addClass("empty");
            newState.find(".operations").initOperationsMenu();
            newState.find(".newStateName").addClass("new").focus(function() {
                if (jQuery(this).hasClass("new")) {
                    jQuery(this).val("");
                    jQuery(this).removeClass("new");
                }
            }).keyup(function() {
                if (jQuery(this).val().length >= 1) {
                    newState.find("button.state.add").removeAttr("disabled");
                } else {
                    newState.find("button.state.add").attr("disabled","disabled");
                }
            });
            newState.find("button.state.cancel").initCancelStateOperation();
            newState.find("button.state.save").initSaveStateOperation();
            newState.find("a.stateName").initEnableStateSEdit();
            newState.initMoreLessOperation();
            newState.find("button.state.add").click(function() {
                var newStateName = newState.find(".newStateName").val();
                var uri = makeAction("addstate");
                AJS.safe.getJSON(uri, {
                    pageId: AJS.params.pageId,
                    key: AJS.params.spaceKey,
                    production : AJS.params.productionWorkflow,
                    workflowName : AJS.params.workflowName,
                    stateName: newStateName},
                        function(response, responseStatus) {
                            if (response && response.ok) {
                                newState.stateName().val(newStateName);
                                newState.updatedStateName().val(newStateName);
                                newState.find("a.stateName").html(newStateName);
                                newState.removeClass("new empty");
                            } else {
                                newState.errorMessage(response, responseStatus);
                            }
                        });
                return false;
            });
        } else if (operation == "edit") {
            jQuery(this).toggleEditProperties();
        }
    },

    toggleEditProperties: function() {
        jQuery("#workflowProperties .view, #workflowProperties .edit").toggleClass("editing");
    },

    disableInput : function() {
        jQuery(".states").sortable('destroy');
        jQuery(".tasks").sortable('destroy');
        jQuery(".moving").removeClass("moving");
        jQuery(".empty").remove();
    },

    enableStateEdit : function() {
        jQuery(this).disableSortables();
        state = jQuery(this);
        state.addClass("edit");
        state.removeClass("delete");
        state.updatedStateSelection().setStatesOptions(state.updatedState().val());
        state.completedStateSelection().setStatesOptions(state.completedState().val());
        state.expiredStateSelection().setStatesOptions(state.expiredState().val());
    },

    enableArrangeStates: function() {
        jQuery(this).initStatesSortable();
        jQuery(".states").sortable('enable');
        jQuery("li.state").addClass("moving");
    },

    enableArrangeTasks: function() {
        jQuery(this).initTasksSortable();
        jQuery(".tasks").sortable('enable');
        jQuery("li.task").addClass("moving");
    },

    disableSortables : function() {
        jQuery(".states").sortable('destroy');
        jQuery(".tasks").sortable('destroy');
    },

    doStateOperation : function() {
        var operation = jQuery(this).operation();
        var state = jQuery(this).parents("li.state");
        if (operation == "arrange") {
            jQuery(this).disableInput();
            jQuery(this).enableArrangeStates();
        } else if (operation == "addtask") {
            jQuery(this).disableInput();
            jQuery("#newelements").find("li.task").addClass("new").clone().appendTo(state.find("ul.tasks"));
            var newTask = state.find("li.task.new");
            newTask.newTaskName().addClass("new").focus(function() {
                if (jQuery(this).hasClass("new")) {
                    jQuery(this).val("");
                    jQuery(this).removeClass("new");
                }
            }).keyup(function() {
                if (jQuery(this).val().length >= 1) {
                    newTask.find("button.add").removeAttr("disabled");
                } else {
                    newTask.find("button.add").attr("disabled","disabled");
                }
            });
            newTask.addClass("empty").find(".task-type-menu").clickMenu({onClick : function() {
                jQuery("li.task-types input[name='type']").each(function() {
                    newTask.find("td.taskName").removeClass(jQuery(this).val());
                });
            }});
            newTask.find("button.add").click(function() {
                var uri = makeAction("newtask");
                var newTaskName = newTask.newTaskName().val();
                AJS.safe.getJSON(uri, {
                    pageId: AJS.params.pageId,
                    key: AJS.params.spaceKey,
                    production : AJS.params.productionWorkflow,
                    workflowName : AJS.params.workflowName,
                    stateName: state.stateName().val(),
                    taskName: newTaskName,
                    taskTypeName : "default"
                },function(response, responseStatus) {
                    if (response && response.ok) {
                        newTask.find(".taskName").html(AWP.Templates.Designer.message({msg : newTaskName}));
                        newTask.taskName().val(newTaskName);
                        newTask.stateName().val(state.stateName().val());
                        newTask.position().val(state.find("li.task").length - 1);
                        newTask.find("ul.operations").initOperationsMenu();
                        newTask.removeClass("new empty");
                        jQuery(this).enableArrangeTasks();
                    } else {
                        newTask.errorMessage(response,responseStatus);
                    }
                });
                return false;
            });
            newTask.find("button.cancel").initCancelTaskOperation();
        } else if (operation == "edit") {
            state.enableStateEdit();
        } else if (operation == "delete") {
            state.addClass("delete");
            state.removeClass("edit");
        }
    },

    initCancelTaskOperation : function() {
        jQuery(this).click(function() {
            var task = jQuery(this).parents("li.task");
            if (task.hasClass("new")) {
                task.remove();
            } else {
                task.removeClass("edit delete");
            }
            return false;
        });
    },

    initCancelStateOperation : function() {
        jQuery(this).click(function() {
            var state = jQuery(this).parents("li.state");
            if (state.hasClass("new")) {
                state.remove();
            } else {
                state.removeClass("edit delete");
            }
            return false;
        });
    },

    initSaveStateOperation : function() {
        jQuery(this).click(function() {
            var state = jQuery(this).parents("li.state");
            var uri = makeAction("savestate");
            var updatedState = state.updatedStateSelection().stateSelected();
            var expiredState = state.expiredStateSelection().stateSelected();
            var completedState = state.completedStateSelection().stateSelected();
            AJS.safe.getJSON(uri,{
                pageId: AJS.params.pageId,
                key: AJS.params.spaceKey,
                production : AJS.params.productionWorkflow,
                workflowName : AJS.params.workflowName,
                stateName: state.stateName().val(),
                updatedStateName: state.updatedStateName().val(),
                taskable: state.find("input[name='taskable']").is(":checked"),
                finalFlag: state.find("input[name='final']").is(":checked"),
                dueDateCount: state.find("input[name='durationCount']").val(),
                dueDatePeriod: state.find("select[name='durationPeriod'] option:selected").val(),
                updatedState : updatedState,
                completedState : completedState,
                expiredState : expiredState
            },function(response, responseStatus) {
                if (response != undefined && response.ok) {
                    state.stateName().val(state.updatedStateName().val());
                    state.find("a.stateName").html(state.updatedStateName().val());
                    state.updatedState().val(updatedState);
                    state.expiredState().val(expiredState);
                    state.completedState().val(completedState);
                    state.removeClass("edit");
                } else {
                    state.updatedStateName().val(state.stateName().val());
                    state.errorMessage(response,responseStatus);
                }
            });
            return false;
        });
    },

    initMoreLessOperation: function() {
        jQuery(this).find("tr.input.advanced.more a").click(function() {
            jQuery(this).parents("li.state").find("tr.input.attributes.advanced").addClass("showing");
            return false;
        });
        jQuery(this).find("tr.input.advanced.less a").click(function() {
            jQuery(this).parents("li.state").find("tr.input.attributes.advanced").removeClass("showing");
            return false;
        });
    },

    initEnableStateSEdit: function() {
        jQuery(this).click(function() {
            var state = jQuery(this).parents("li.state");
            state.enableStateEdit();
            return false;
        });
    },

    initDeleteStateOperation : function() {
        jQuery(this).click(function() {
            var state = jQuery(this).parents("li.state");
            var stateName = state.stateName().val();
            var uri = makeAction("removestate");
            AJS.safe.getJSON(uri, {
                pageId: AJS.params.pageId,
                key: AJS.params.spaceKey,
                production : AJS.params.productionWorkflow,
                workflowName : AJS.params.workflowName,
                stateName: state.stateName().val()
            },function(response, responseStatus) {
                if (response && response.ok) {
                    state.remove();
                } else {
                    state.errorMessage(response,responseStatus);
                }
            });
            return false;
        })
    },

    initDeleteTaskOperation : function() {
        jQuery(this).click(function() {
            var state = jQuery(this).parents("li.state");
            var task = jQuery(this).parents("li.task");
            var uri = makeAction("removetask");
            AJS.safe.getJSON(uri, {
                pageId: AJS.params.pageId,
                key: AJS.params.spaceKey,
                production : AJS.params.productionWorkflow,
                workflowName : AJS.params.workflowName,
                stateName: state.stateName().val(),
                taskName: task.taskName().val()
            },function(response, responseStatus) {
                if (response && response.ok) {
                    task.remove();
                } else {
                    task.errorMessage(response,responseStatus);
                }
            });
            return false;
        });
    },

    doTaskOperation : function() {
        var operation = jQuery(this).operation();
        if (operation == "arrange") {
            jQuery(this).disableInput();
            jQuery(this).enableArrangeTasks();
        } else if (operation == "delete") {
            var task = jQuery(this).parents("li.task");
            task.addClass("delete");
        }
    },

    initOperationsMenu : function () {
        jQuery(this).clickMenu({shiftLeft: true, onClick : function() {
            var menu = jQuery(this).parents(".operations");
            if (menu.hasClass("workflow")) {
                jQuery(this).doWorkflowOperation();
            } else if (menu.hasClass("state")) {
                jQuery(this).doStateOperation();
            } else if (menu.hasClass("task")) {
                jQuery(this).doTaskOperation();
            }
        }});
    },
    initStatesSortable : function() {
        jQuery(".wdtab-content.editable .states").sortable({
            stop: function(event, ui) {
                var stateName = ui.item.stateName().val();
                var position = 0;
                jQuery(".states").find("li.state").each(function() {
                    if (jQuery(this).stateName().val() == stateName) {
                        return false;
                    }
                    position++;
                });
                var uri = makeAction("movestate");
                AJS.safe.getJSON(uri, {
                    pageId: AJS.params.pageId,
                    key: AJS.params.spaceKey,
                    production : AJS.params.productionWorkflow,
                    workflowName : AJS.params.workflowName,
                    stateName: stateName,
                    position: position
                }, function(response,responseStatus) {
                    if (response && response.ok) {
                    } else {
                        ui.item.errorMessage(response,responseStatus);
                    }
                });
            }
        }).disableSelection();
    },

    initTasksSortable : function() {
        jQuery(".wdtab-content.editable .tasks").sortable({connectWith : ['.tasks'],
            receive: function(event, ui)  {
                var taskName = ui.item.taskName().val();
                var count = 0;
                var items = 0;
                var names = "";
                ui.item.parent("ul").find("li").each(function() {
                    items++;
                    if (jQuery(this).taskName().val() == taskName) {
                        count++;
                    }
                    names = names + " " + jQuery(this).taskName().val();
                });
                if (count > 1) {
                    ui.item.appendTo(ui.sender);
                }
            },
            stop: function(event, ui) {
                var thisStateName = ui.item.parents("li").stateName().val();
                var thatStateName = ui.item.stateName().val();
                var position = 0;
                ui.item.parent("ul").find("li").each(function() {
                    jQuery(this).position().val(position++);
                });
                var uri = makeAction("movetask");
                AJS.safe.getJSON(uri, {
                    pageId: AJS.params.pageId,
                    key: AJS.params.spaceKey,
                    production : AJS.params.productionWorkflow,
                    workflowName : AJS.params.workflowName,
                    fromState: thatStateName,
                    toState: thisStateName,
                    taskName:
                            ui.item.taskName().val(),
                    position: ui.item.position().val()
                }, function (response,responseStatus) {
                    if (response == undefined) {
                        alert("error "  + responseStatus);
                    } else if (! response.ok) {
                        alert("error " + response.message);
                    }
                });
                ui.item.stateName().val(thisStateName);
            }
        }).disableSelection().sortable('disable');
    }
});

jQuery(document).ready(function() {

    // define save as template modal dialog
    var saveasDialog = new AJS.Dialog({
        width: 600,
        height: 275,
        id: "saveas-dialog",
        closeOnOutsideClick: true
    });
    saveasDialog.addHeader(jQuery("#templateInfo .aui-dialog2-header-main").html());
    saveasDialog.addPanel("Panel 1", jQuery("#templateInfo .aui-dialog2-content").html(), "panel-body");
    saveasDialog.addButton(jQuery("#saveWorkflow").html(), function(dialog) {
        jQuery("#saveas-dialog .aui-button-primary").attr('disabled', 'disabled');
        window.location = makeSafeAction(makeAction("saveworkflowtemplate") , "pageId=" + AJS.params.pageId +
                          "&spaceKey=" + jQuery("#saveas-dialog input[name='spaceKey']").val() +
                          "&debug=" + jQuery(this).isDebug() +
                          "&templateName=" + encodeURIComponent(jQuery("#saveas-dialog input[name='templateName']").val()) +
                          "&templateDescription=" + encodeURIComponent(jQuery("#saveas-dialog textarea[name='templateDescription']").val()));
    }, 'aui-button aui-button-primary');
    // adds "Cancel" button to page 1
    saveasDialog.addButton(jQuery(".cw-designer__closedialog").html(), function (dialog) {
        saveasDialog.hide();
    }, 'aui-button aui-button-link');

    jQuery("#saveas-dialog .button-panel-button").removeClass('button-panel-button');


    jQuery("#saveWorkflow").click(function() {
        if (AJS.params.productionWorkflow) {
            window.location = makeSafeAction( makeAction(AJS.params.saveWorkflowAction), "pageId=" + AJS.params.pageId +
                              "&key=" + AJS.params.spaceKey +
                              "&production=true" +
                              "&debug=" + jQuery(this).isDebug() +
                              "&workflowName=" +  encodeURIComponent(AJS.params.workflowName) );

        } else if (jQuery(this).hasClass("template")) {
            jQuery("#saveWorkflow").attr('disabled', 'disabled');
            window.location = makeSafeAction(makeAction("saveworkflowtemplate") , "pageId=" + AJS.params.pageId +
                              "&spaceKey=" + jQuery("#templateInfo input[name='spaceKey']").val() +
                              "&debug=" + jQuery(this).isDebug() +
                              "&templateName=" + encodeURIComponent(jQuery("#templateInfo input[name='templateName']").val()) +
                              "&templateDescription=" + encodeURIComponent(jQuery("#templateDescription").val()));
        } else {
            window.location = makeSafeAction(makeAction(AJS.params.saveWorkflowAction) , "pageId=" + AJS.params.pageId +
                              "&key="+  AJS.params.spaceKey +
                              "&workflowName=" +  encodeURIComponent(AJS.params.workflowName)  +
                              "&debug=" + jQuery(this).isDebug());
        }
        return false;
    });
    jQuery("#cancelWorkflow").click(function() {
        window.location = getContextPath() + AJS.params.cancelWorkflowAction;
        return false;
    });
    jQuery("#saveAsTemplate").click(function(e) {
        e.preventDefault();
        saveasDialog.gotoPage(0);
        saveasDialog.gotoPanel(0);
        saveasDialog.show();
        jQuery('input[name="templateName"]').focus();
        jQuery("#saveWorkflow").addClass("template");
    });
    jQuery(".cw-designer__closedialog").click(function(e) {
        e.preventDefault();
        AJS.dialog2("#templateInfo").hide();
    });
    jQuery(".wdtab-content ul.operations").each(function() {
        jQuery(this).initOperationsMenu();
    });
    // task operations actions
    jQuery("li.task button.cancel").each(function() {
        jQuery(this).initCancelTaskOperation();
    });

    jQuery("li.task button.yes").each(function() {
        jQuery(this).initDeleteTaskOperation();
    });

    // state operations actions
    jQuery("li.state tr.input.buttons button.cancel").each(function() {
        jQuery(this).initCancelStateOperation();
    });

    jQuery("li.state tr.input.buttons button.save").each(function() {
        jQuery(this).initSaveStateOperation();
    });

    jQuery("li.state").each(function() {
        jQuery(this).initMoreLessOperation();
    });

    jQuery("li.state tr.input.buttons button.yes").each(function() {
        jQuery(this).initDeleteStateOperation();
    });
    jQuery("a.stateName").initEnableStateSEdit();
    // workflow markup stuff
    jQuery("#saveWorkflowMarkup").click(function() {
        var form = jQuery("#workflowMarkupForm");
        var uri = makeAction("saveworkflowmarkup");
        var content = AWP.markupEditor.getValue();

        // replace
        content = content.replace('&amp;', '&');

        if(isSpace) {
            AWP.Analytics.trackEvent('markup', 'saved', 'space');
        }
        else {
            AWP.Analytics.trackEvent('markup', 'saved', 'page');
        }


        AJS.safe.post(uri, {
                    pageId: AJS.params.pageId,
                    key: AJS.params.spaceKey,
                    production : AJS.params.productionWorkflow,
                    workflowName : jQuery("#newWorkflowName").val(),
                    workflowMarkup: content
                    },
                        function(response, responseStatus) {
                            if (response && response.ok) {
                                jQuery("#workflowMarkupText").val(response.markup);
                                form.successMessage(response.message);
                                if (AJS.params.newWorkflow) {
                                    window.location = getContextPath() + AJS.params.cancelWorkflowAction;
                                }
                            } else {
                                form.errorMessage(response,responseStatus);
                            }
                        },"json");
        return false;
    });
    // workflow operations
    jQuery("#workflowName").click(function() {
        jQuery(this).toggleEditProperties();
        return false;
    });
    jQuery("#workflowProperties button.save").click(function() {
        var form = jQuery("#workflowProperties");
        var uri = makeAction("saveproperties");
        AJS.safe.getJSON(uri, {
                    pageId: AJS.params.pageId,
                    key: AJS.params.spaceKey,
                    production : AJS.params.productionWorkflow,
                    workflowName : AJS.params.workflowName,
                    newLabelName : jQuery("#newLabelName").val(),
                    newWorkflowName : jQuery("#newWorkflowName").val(),
                    newWorkflowDescription : jQuery("#newWorkflowDescription").val()
                },
                function(response, responseStatus) {
                    if (response != undefined && response.ok) {
                        jQuery("#workflowName").html(AWP.Templates.Designer.message({msg : jQuery("#newWorkflowName").val()}));
                        jQuery("#workflowDescription").html(jQuery("#newWorkflowDescription").html());
                        jQuery("#renderedWorkflowDescription").html(response.renderedDescription);
                        jQuery("#labelName").html(jQuery("#newLabelName").val());
                        if (jQuery("#newLabelName").val() != undefined && jQuery("#newLabelName").val().length > 0) {
                            jQuery("#workflowLabel").css("display","inline");
                        } else {
                            jQuery("#workflowLabel").css("display","none");
                        }
                    } else {
                        console.log(response);
                        form.errorMessage(response,responseStatus);
                    }
                    jQuery(this).toggleEditProperties();
                });
        return false;
    });
    jQuery("#workflowProperties button.cancel").click(function() {
        jQuery("#newWorkflowName").val(jQuery("#workflowName").html());
        jQuery("#newWorkflowDescription").html(jQuery("#workflowDescription").html());
        jQuery(this).toggleEditProperties();
        return false;
    });
    if (jQuery(this).isDebug()) {
        jQuery("table.editworkflow").successMessage("Debug mode");
    }
    if (jQuery.browser.msie) {
            jQuery("table.editworkflow").showErrorMessage("Workflow Designer is not supported in Internet Explorer, use Firefox or the wiki markup for modifying the workflow");
    }

});

// Highligt Workflow Markup

(function($, AJS) {
    AJS.toInit(function() {
        $textarea = document.getElementById("workflowMarkupText");
        if($textarea) {
            AWP.markupEditor = CodeMirror.fromTextArea($textarea, {
                lineNumbers: true,
                lineWrapping: true,
                mode: "workflow"
            });
        }

        // Analytics
        AWP.Analytics.init(AJS.params.workflowStatsUAKey, 'AWP', 'Comala Workflows');
        isSpace = (CML.getUrlParameters()['key'])? true : false;
        if(CML.getUrlParameters()['tab']) {
            if(CML.getUrlParameters()['tab'] === 'states') {
                if(isSpace) {
                    AWP.Analytics.trackEvent('designer', 'loaded', 'space');
                }
                else {
                    AWP.Analytics.trackEvent('designer', 'loaded', 'page');
                }
            }
            else if(CML.getUrlParameters()['tab'] === 'markup') {
                if(isSpace) {
                    AWP.Analytics.trackEvent('markup', 'viewed', 'space');
                }
                else {
                    AWP.Analytics.trackEvent('markup', 'viewed', 'page');
                }
            }
        }
        else {
            if(isSpace) {
                AWP.Analytics.trackEvent('designer', 'loaded', 'space');
            }
            else {
                AWP.Analytics.trackEvent('designer', 'loaded', 'page');
            }
        }
    });
})(AJS.$, AJS);
