var requirejs = require || requirejs;
requirejs(['common', 'ajs', 'jquery'], function (common, AJS, $) {
    AJS.toInit(function () {
        var URL_DEV = 'http://localhost:3000/evaluation', // For local testing
            URL_PROD = 'https://evaluation.comalatech.io/evaluation',
            MAX_RETRIES_BEFORE_ACK = 5,
            stats = {},
            comalatechToken,
            pluginKey = '${pluginKey}', // Replaced in transformer
            prefix = pluginKey.replace('-', ''), // Slashes not supported in AJS-metas
            trace = AJS.params[prefix + 'Trace'],
            devMode = !!AJS.params[prefix + 'DevMode'],
            ack = common.analyticsAck(AJS.Confluence.getContextPath(),pluginKey,trace);

        stats = common.generateStats(AJS.params,prefix);
        // Check mandatory fields
        if (stats['appSen'] && stats['hostSen'] && stats['comalatechToken']) {
            comalatechToken = stats['comalatechToken'];
            delete stats['comalatechToken'];
            $.ajax({
                type: 'POST',
                url: (devMode ? URL_DEV : URL_PROD) + "?token=" + encodeURIComponent(comalatechToken),
                cache: false,
                contentType: "text/plain; charset=utf-8",
                data: JSON.stringify(stats),
                success: function () {
                    trace && console.log('🔔🔔🔔 Sent stats!!!!', devMode && 'DEV MODE', stats);
                    sessionStorage.removeItem('retries');
                    ack();
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    trace && console.error('🔕🔕🔕 Error sending stats', textStatus, errorThrown);
                    var retries = parseInt(sessionStorage.getItem('retries') || 0);
                    if (retries >= MAX_RETRIES_BEFORE_ACK) {
                        trace && console.error('🔕🔕🔕 Max retries reached... ack-ing anyway');
                        ack();
                    } else {
                        sessionStorage.setItem('retries', retries + 1);
                    }
                }
            });
        }
    });
});
