/*
 * Decompiled with CFR 0.152.
 */
package org.randombits.confluence.supplier;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.randombits.confluence.supplier.SupplierException;
import org.randombits.util.TextBuffer;
import org.randombits.util.TokenIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class KeyChainParser {
    private static final char QUOTE_CHAR = '\"';
    private static final char ESCAPE_CHAR = '\\';
    private static final char GT_CHAR = '>';
    private static BitSet WHITESPACE = new BitSet();
    private static BitSet SEPARATOR = new BitSet();
    private static BitSet RESERVED = new BitSet();
    private static BitSet UNQUOTED = new BitSet();
    private static BitSet QUOTABLE = new BitSet();

    KeyChainParser() {
    }

    public static List<String> parse(String keyChain) throws SupplierException {
        TokenIterator i = new TokenIterator(keyChain.trim());
        List<String> list = KeyChainParser.parseChain(i);
        if (!i.atEnd()) {
            throw new SupplierException("Unexpected values at end: '" + i.getSequence(TokenIterator.ALL_CHARS) + "'");
        }
        return list;
    }

    private static List<String> parseChain(TokenIterator i) throws SupplierException {
        boolean continuing = true;
        ArrayList<String> list = new ArrayList<String>();
        while (continuing && !i.atEnd()) {
            list.add(KeyChainParser.parseListItem(i));
            i.getSequence(WHITESPACE);
            continuing = i.getSequence(SEPARATOR, 1) != null;
        }
        return list;
    }

    private static String parseListItem(TokenIterator i) throws SupplierException {
        TextBuffer buff = new TextBuffer();
        boolean done = false;
        while (!done) {
            if (i.getToken(34) != null) {
                KeyChainParser.readQuotedItem(i, buff);
                continue;
            }
            CharSequence value = i.getSequence(UNQUOTED, 1);
            if (value != null) {
                buff.add(value);
                continue;
            }
            done = true;
        }
        return buff.toString().trim();
    }

    private static void readQuotedItem(TokenIterator i, TextBuffer buff) throws SupplierException {
        while (!i.atEnd() && !i.matchToken(34)) {
            buff.add(i.getSequence(QUOTABLE));
            if (i.getToken(92) == null) continue;
            CharSequence escaped = i.getSequence(TokenIterator.ALL_CHARS, 1, 1);
            if (escaped == null) {
                throw new SupplierException("Expected a character to escape after '\\'");
            }
            buff.add(escaped);
        }
        if (i.getToken(34) == null) {
            throw new SupplierException("Expected '\"'");
        }
    }

    static {
        WHITESPACE.set(32);
        WHITESPACE.set(9);
        WHITESPACE.set(13);
        WHITESPACE.set(10);
        SEPARATOR.set(62);
        RESERVED.set(62);
        RESERVED.set(34);
        UNQUOTED.set(0, 65535, true);
        UNQUOTED.andNot(SEPARATOR);
        UNQUOTED.andNot(RESERVED);
        QUOTABLE.set(0, 65535, true);
        QUOTABLE.clear(34);
        QUOTABLE.clear(92);
    }
}

