/*
 * Decompiled with CFR 0.152.
 */
package net.customware.confluence.reporting;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.macro.Macro;
import java.util.Set;
import net.customware.confluence.reporting.DefaultReportContext;
import net.customware.confluence.reporting.Executor;
import net.customware.confluence.reporting.Filterable;
import net.customware.confluence.reporting.Outputable;
import net.customware.confluence.reporting.Report;
import net.customware.confluence.reporting.ReportContext;
import net.customware.confluence.reporting.ReportContextFinder;
import net.customware.confluence.reporting.ReportException;
import net.customware.confluence.reporting.ReportOutput;
import net.customware.confluence.reporting.ReportSetup;
import net.customware.confluence.reporting.Sortable;
import net.customware.confluence.reporting.query.Mutatable;
import net.customware.confluence.reporting.query.Query;
import net.customware.confluence.reporting.query.Queryable;

public final class ReportBuilder {
    private static final ReportContext DEFAULT = new DefaultReportContext();
    private static ReportContextFinder finder = new ReportContextFinder();

    private ReportBuilder() {
    }

    private static ReportContext getReportContext() throws ReportException {
        Set ctxs = finder.getThings();
        switch (ctxs.size()) {
            case 0: {
                return DEFAULT;
            }
            case 1: {
                return (ReportContext)ctxs.iterator().next();
            }
        }
        throw new ReportException("There must be at most one report context available, but there are " + ctxs.size());
    }

    public static <T> T executeRoot(PageContext pageContext, Executor<? extends T> executor) throws ReportException {
        return ReportBuilder.getReportContext().executeRoot(pageContext, executor);
    }

    public static <T> T executeRoot(PageContext pageContext, final Object context, final Executor<? extends T> executor) throws ReportException {
        return ReportBuilder.executeRoot(pageContext, new Executor<T>(){

            @Override
            public T execute() throws ReportException {
                return ReportBuilder.executeContext(context, executor);
            }
        });
    }

    public static <T> T executeRoot(PageContext pageContext, final Report<?, ?> report, final Executor<? extends T> executor) throws ReportException {
        return ReportBuilder.executeRoot(pageContext, new Executor<T>(){

            @Override
            public T execute() throws ReportException {
                return ReportBuilder.executeReport(report, executor);
            }
        });
    }

    public static boolean isReporting() {
        try {
            return ReportBuilder.getReportContext().isReporting();
        }
        catch (ReportException e) {
            return false;
        }
    }

    public static <T> T executeContext(Object context, Executor<? extends T> executor) throws ReportException {
        return ReportBuilder.getReportContext().executeContext(context, executor);
    }

    public static <T> T executeReport(Report<?, ?> report, Executor<? extends T> executor) throws ReportException {
        return ReportBuilder.getReportContext().executeReport(report, executor);
    }

    public static Report<?, ?> getCurrentReport() throws ReportException {
        return ReportBuilder.getReportContext().getCurrentReport();
    }

    public static Object getCurrentContext() throws ReportException {
        return ReportBuilder.getReportContext().getCurrentContext();
    }

    public static <C> C getCurrentContext(Class<C> targetClass) throws ReportException {
        return ReportBuilder.getReportContext().getCurrentContext(targetClass);
    }

    public static Query<?> getQuery() throws ReportException {
        return ReportBuilder.getCurrentContext(Query.class);
    }

    public static Sortable<?> getSortable() throws ReportException {
        return ReportBuilder.getCurrentContext(Sortable.class);
    }

    public static Filterable getFilterable() throws ReportException {
        return ReportBuilder.getCurrentContext(Filterable.class);
    }

    public static <F, T> Mutatable<F, T> getMutatable(Class<F> fromType, Class<T> toType) throws ReportException {
        Mutatable mutatable = ReportBuilder.getCurrentContext(Mutatable.class);
        if (mutatable != null && fromType.isAssignableFrom(mutatable.getFromType()) && toType.isAssignableFrom(mutatable.getToType())) {
            return mutatable;
        }
        return null;
    }

    public static Object getCurrentReportItem() throws ReportException {
        return ReportBuilder.getReportContext().getCurrentReportItem();
    }

    public static PageContext getRootPageContext() throws ReportException {
        return ReportBuilder.getReportContext().getRootPageContext();
    }

    public static ContentEntityObject getRootContent() throws ReportException {
        PageContext ctx = ReportBuilder.getRootPageContext();
        if (ctx != null) {
            return ctx.getEntity();
        }
        return null;
    }

    public static PageContext getCurrentPageContext() throws ReportException {
        Report<?, ?> report = ReportBuilder.getCurrentReport();
        if (report != null) {
            return report.getPageContext();
        }
        return ReportBuilder.getRootPageContext();
    }

    public static <T> Queryable<T> getQueryable(Class<T> type) throws ReportException {
        Queryable queryable = ReportBuilder.getCurrentContext(Queryable.class);
        if (queryable != null && queryable.getQueryValueType() != null && queryable.getQueryValueType().isAssignableFrom(type)) {
            return queryable;
        }
        return null;
    }

    public static <T extends ReportOutput> Outputable<T> getOutputable(Class<T> outputType) throws ReportException {
        Outputable outputable = ReportBuilder.getCurrentContext(Outputable.class);
        if (outputable != null && outputType.isAssignableFrom(outputable.getOutputType())) {
            return outputable;
        }
        return null;
    }

    public static <O extends ReportOutput> ReportSetup<O> getReportSetup(Class<O> outputType) throws ReportException {
        ReportSetup setup = ReportBuilder.getCurrentContext(ReportSetup.class);
        if (setup != null && outputType.isAssignableFrom(setup.getOutputType())) {
            return setup;
        }
        return null;
    }

    public static String renderWiki(String wiki, RenderMode renderMode, Macro macro) throws ReportException {
        return ReportBuilder.getReportContext().renderWiki(wiki, renderMode, macro);
    }

    public static Object getCurrentSource(Object defaultSource) {
        Object context = null;
        if (ReportBuilder.isReporting()) {
            try {
                Report<?, ?> report = ReportBuilder.getCurrentReport();
                if (report != null) {
                    context = ReportBuilder.getTopReportItem(report);
                }
                if (context == null) {
                    context = ReportBuilder.getRootContent();
                }
            }
            catch (ReportException reportException) {
                // empty catch block
            }
        }
        if (context == null) {
            context = defaultSource;
        }
        return context;
    }

    public static Object getTopReportItem(Report<?, ?> report) {
        Object item = report.getCurrentItem();
        if (item == null && report.getParent() != null) {
            item = ReportBuilder.getTopReportItem(report.getParent());
        }
        return item;
    }
}

