/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowcontainer.action;

import com.atlassian.confluence.compat.api.service.accessmode.ReadOnlyAccessBlocked;
import com.atlassian.confluence.compat.struts2.actioncontext.ActionContextCompatManager;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.actions.AbstractSpaceAction;
import com.atlassian.confluence.spaces.actions.SpaceAware;
import com.atlassian.confluence.velocity.htmlsafe.HtmlSafe;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.WikiStyleRenderer;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.user.User;
import com.comalatech.confluence.license.AdhocWorkflowsLicenseManager;
import com.comalatech.confluence.workflow.Workflow;
import com.comalatech.confluence.workflow.WorkflowConfigurationManager;
import com.comalatech.confluence.workflow.WorkflowException;
import com.comalatech.confluence.workflowcontainer.WorkflowContainerManager;
import com.comalatech.confluence.workflowcontainer.model.WorkflowActionEnum;
import com.comalatech.workflow.template.LinkedTemplateManager;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;

public class SpaceWorkflowsAction
extends AbstractSpaceAction
implements SpaceAware {
    private static final Logger log = LoggerFactory.getLogger(SpaceWorkflowsAction.class);
    private List<Workflow> spaceWorkflows;
    private List<Workflow> globalWorkflows;
    private List<Workflow> productionWorkflows;
    private List<com.comalatech.workflow.model.Workflow> linkedWorkflowTemplates;
    private WorkflowContainerManager workflowContainerManager;
    private WorkflowConfigurationManager workflowConfigurationManager;
    private WikiStyleRenderer wikiStyleRenderer;
    private WebResourceManager webResourceManager;
    private LinkedTemplateManager linkedTemplateManager;
    private AdhocWorkflowsLicenseManager licenseManager;
    private ActionContextCompatManager actionContextCompatManager;
    private String workflowName;
    private boolean hasActiveProductionWorkflows;
    private boolean showWelcome;
    private String welcomeUrl;
    private String licenseStatusMessage;
    private String productiontype;
    private String workflowsVersionNumber;
    private String workflowsVersionName;
    private static final String PRODUCTION_TYPE_COPY_PARAM = "copy";
    private static final String PRODUCTION_TYPE_LINK_PARAM = "link";
    private static ThreadLocal<String> errorMessageThreadLocal = new ThreadLocal();
    private String docoUrl = "https://apps.appf.re/cdmdc/doc/documentmanagementdash/qe9E5b";

    public String execute() throws Exception {
        this.webResourceManager.requireResource("confluence.web.resources:jquery");
        this.webResourceManager.requireResource("confluence.web.resources:ajs");
        this.showWelcome = this.workflowConfigurationManager.getConfiguration().isShowWelcome();
        this.welcomeUrl = this.workflowConfigurationManager.getConfiguration().getWelcomeUrl();
        this.licenseStatusMessage = this.licenseManager.getLicenseStatus().getMessageHtml();
        this.workflowsVersionNumber = this.workflowConfigurationManager.getConfiguration().getWorkflowVersionNumber();
        this.workflowsVersionName = this.workflowConfigurationManager.getConfiguration().getWorkflowVersionName();
        this.loadWorkflows();
        return "success";
    }

    private boolean isConfluenceAdministrator() {
        return this.permissionManager.hasPermission((User)this.getAuthenticatedUser(), Permission.ADMINISTER, PermissionManager.TARGET_APPLICATION);
    }

    public boolean isSpaceWorkflowsEnabled() {
        return this.workflowConfigurationManager.getConfiguration().isSpaceWorkflowsAllowed(this.getSpaceKey());
    }

    public WorkflowActionEnum getCreateProductionWorkflowAction() {
        return WorkflowActionEnum.CREATE_PRODUCTION_WORKFLOW;
    }

    public WorkflowActionEnum getCreateWorkflowTemplate() {
        return WorkflowActionEnum.CREATE_SPACE_WORKFLOW;
    }

    public List<WorkflowActionEnum> getProductionWorkflowsAction(Workflow workflow) {
        ArrayList<WorkflowActionEnum> actions = new ArrayList<WorkflowActionEnum>();
        boolean hasError = TextUtils.stringSet((String)workflow.getErrorMessage());
        if (hasError) {
            actions.add(WorkflowActionEnum.EDIT_PRODUCTION_WORKFLOW_WITH_ERROR);
            if (workflow.isActive()) {
                actions.add(WorkflowActionEnum.DISABLE_PRODUCTION_WORKFLOW);
            }
            actions.add(WorkflowActionEnum.DELETE_PRODUCTION_WORKFLOW);
            return actions;
        }
        actions.add(WorkflowActionEnum.EDIT_PRODUCTION_WORKFLOW);
        if (workflow.isActive()) {
            actions.add(WorkflowActionEnum.DISABLE_PRODUCTION_WORKFLOW);
            actions.add(WorkflowActionEnum.INITIALIZE_PRODUCTION_WORKFLOW);
        } else {
            actions.add(WorkflowActionEnum.ENABLE_PRODUCTION_WORKFLOW);
        }
        actions.add(WorkflowActionEnum.COPY_PRODUCTION_WORKFLOW);
        actions.add(WorkflowActionEnum.DELETE_PRODUCTION_WORKFLOW);
        return actions;
    }

    public List<WorkflowActionEnum> getLinkedTemplateActions(com.comalatech.workflow.model.Workflow workflow) {
        ArrayList<WorkflowActionEnum> actions = new ArrayList<WorkflowActionEnum>();
        actions.add(WorkflowActionEnum.INITIALIZE_PRODUCTION_WORKFLOW);
        actions.add(WorkflowActionEnum.UNLINK_GLOBAL_WORKFLOW);
        return actions;
    }

    public List<WorkflowActionEnum> getWorkflowSpaceActions(Workflow workflow) {
        ArrayList<WorkflowActionEnum> actions = new ArrayList<WorkflowActionEnum>();
        actions.add(WorkflowActionEnum.EDIT_SPACE_WORKFLOW);
        if (workflow.isActive()) {
            actions.add(WorkflowActionEnum.DISABLE_SPACE_WORKFLOW);
        } else {
            actions.add(WorkflowActionEnum.ENABLE_SPACE_WORKFLOW);
        }
        actions.add(WorkflowActionEnum.COPY_SPACE_WORKFLOW);
        actions.add(WorkflowActionEnum.DELETE_SPACE_WORKFLOW);
        if (this.isConfluenceAdministrator()) {
            actions.add(WorkflowActionEnum.PROMOTE_SPACE_WORKFLOW);
        }
        actions.add(WorkflowActionEnum.PROMOTE_PRODUCTION_WORKFLOW);
        return actions;
    }

    public List<WorkflowActionEnum> getWorkflowGlobalActions(Workflow workflow) {
        ArrayList<WorkflowActionEnum> actions = new ArrayList<WorkflowActionEnum>();
        if (this.isConfluenceAdministrator()) {
            actions.add(WorkflowActionEnum.EDIT_GLOBAL_WORKFLOW);
        }
        if (this.workflowContainerManager.isGlobalWorkflowTemplateActive(this.getSpaceKey(), workflow.getName())) {
            actions.add(WorkflowActionEnum.DISABLE_SPACE_GLOBAL_WORKFLOW);
        } else {
            actions.add(WorkflowActionEnum.ENABLE_SPACE_GLOBAL_WORKFLOW);
        }
        actions.add(WorkflowActionEnum.COPY_SPACE_GLOBAL_WORKFLOW);
        if (this.isConfluenceAdministrator()) {
            actions.add(WorkflowActionEnum.DELETE_SPACE_GLOBAL_WORKFLOW);
        }
        actions.add(WorkflowActionEnum.PROMOTE_GLOBALPRODUCTION_WORKFLOW);
        return actions;
    }

    public boolean isGlobalWorkflowActive(Workflow workflow) {
        return this.workflowContainerManager.isGlobalWorkflowTemplateActive(this.getSpaceKey(), workflow.getName());
    }

    @ReadOnlyAccessBlocked
    public String disable() throws Exception {
        return this.toggleWorkflowState(false);
    }

    @ReadOnlyAccessBlocked
    public String enable() throws Exception {
        return this.toggleWorkflowState(true);
    }

    @ReadOnlyAccessBlocked
    public String delete() throws Exception {
        return this.doWithWorkflow(this.getSpaceKey(), new WorkflowCommand(){

            @Override
            public void command(Workflow workflow) throws WorkflowException {
                SpaceWorkflowsAction.this.workflowContainerManager.removeWorkflowTemplate(SpaceWorkflowsAction.this.getSpaceKey(), workflow.getName());
            }
        });
    }

    @ReadOnlyAccessBlocked
    public String promote() throws Exception {
        return this.doWithWorkflow(this.getSpaceKey(), new WorkflowCommand(){

            @Override
            public void command(Workflow workflow) throws WorkflowException {
                SpaceWorkflowsAction.this.workflowContainerManager.promoteWorkflowTemplate(SpaceWorkflowsAction.this.getSpaceKey(), workflow);
            }
        });
    }

    @ReadOnlyAccessBlocked
    public String makeProduction() throws Exception {
        return this.doWithWorkflow(this.getSpaceKey(), new WorkflowCommand(){

            @Override
            public void command(Workflow workflow) throws WorkflowException {
                SpaceWorkflowsAction.this.workflowContainerManager.promoteProductionWorkflow(SpaceWorkflowsAction.this.getSpaceKey(), workflow);
            }
        });
    }

    @ReadOnlyAccessBlocked
    public String makeProductionGlobal() throws Exception {
        return this.doWithWorkflow(null, new WorkflowCommand(){

            @Override
            public void command(Workflow workflow) throws WorkflowException {
                if (SpaceWorkflowsAction.PRODUCTION_TYPE_COPY_PARAM.equals(SpaceWorkflowsAction.this.productiontype)) {
                    SpaceWorkflowsAction.this.workflowContainerManager.promoteProductionWorkflow(SpaceWorkflowsAction.this.getSpaceKey(), workflow);
                } else if (SpaceWorkflowsAction.PRODUCTION_TYPE_LINK_PARAM.equals(SpaceWorkflowsAction.this.productiontype)) {
                    SpaceWorkflowsAction.this.linkedTemplateManager.addTemplateLink(SpaceWorkflowsAction.this.getSpaceKey(), SpaceWorkflowsAction.this.workflowName);
                }
            }
        });
    }

    @ReadOnlyAccessBlocked
    public String copy() throws Exception {
        return this.doWithWorkflow(this.getSpaceKey(), new WorkflowCommand(){

            @Override
            public void command(Workflow workflow) throws WorkflowException {
                SpaceWorkflowsAction.this.workflowContainerManager.copyWorkflowTemplate(SpaceWorkflowsAction.this.getSpaceKey(), workflow);
            }
        });
    }

    @ReadOnlyAccessBlocked
    public String copyProduction() throws Exception {
        return this.doWithProductionWorkflow(this.getSpaceKey(), new WorkflowCommand(){

            @Override
            public void command(Workflow workflow) throws WorkflowException {
                SpaceWorkflowsAction.this.workflowContainerManager.copyProductionWorkflow(SpaceWorkflowsAction.this.getSpaceKey(), workflow);
            }
        });
    }

    @ReadOnlyAccessBlocked
    public String copyGlobal() throws Exception {
        return this.doWithWorkflow(null, new WorkflowCommand(){

            @Override
            public void command(Workflow workflow) throws WorkflowException {
                SpaceWorkflowsAction.this.workflowContainerManager.copyWorkflowTemplate(SpaceWorkflowsAction.this.getSpaceKey(), workflow);
            }
        });
    }

    @ReadOnlyAccessBlocked
    public String deleteGlobal() throws Exception {
        return this.doWithWorkflow(null, new WorkflowCommand(){

            @Override
            public void command(Workflow workflow) throws WorkflowException {
                SpaceWorkflowsAction.this.workflowContainerManager.removeWorkflowTemplate(null, workflow.getName());
            }
        });
    }

    @ReadOnlyAccessBlocked
    public String editGlobal() throws Exception {
        return "success";
    }

    @ReadOnlyAccessBlocked
    public String deleteProduction() throws Exception {
        return this.doWithProductionWorkflow(this.getSpaceKey(), new WorkflowCommand(){

            @Override
            public void command(Workflow workflow) throws WorkflowException {
                SpaceWorkflowsAction.this.workflowContainerManager.removeProductionWorkflow(SpaceWorkflowsAction.this.getSpaceKey(), workflow.getName());
            }
        });
    }

    @ReadOnlyAccessBlocked
    public String enableGlobal() throws Exception {
        return this.toggleGlobalWorkflowState(true);
    }

    @ReadOnlyAccessBlocked
    public String disableGlobal() throws Exception {
        return this.toggleGlobalWorkflowState(false);
    }

    @ReadOnlyAccessBlocked
    public String enableProduction() throws Exception {
        return this.toggleProductionWorkflowState(true);
    }

    @ReadOnlyAccessBlocked
    public String disableProduction() throws Exception {
        return this.toggleProductionWorkflowState(false);
    }

    private String toggleProductionWorkflowState(final boolean enable) throws Exception {
        return this.doWithProductionWorkflow(this.getSpaceKey(), new WorkflowCommand(){

            @Override
            public void command(Workflow workflow) throws WorkflowException {
                SpaceWorkflowsAction.this.workflowContainerManager.setActiveProductionWorkflow(SpaceWorkflowsAction.this.getSpaceKey(), workflow, enable);
            }
        });
    }

    private String toggleGlobalWorkflowState(final boolean enable) throws Exception {
        return this.doWithWorkflow(null, new WorkflowCommand(){

            @Override
            public void command(Workflow workflow) throws WorkflowException {
                SpaceWorkflowsAction.this.workflowContainerManager.setGlobalWorkflowActive(SpaceWorkflowsAction.this.getSpaceKey(), workflow.getName(), enable);
            }
        });
    }

    private String toggleWorkflowState(final boolean enable) throws Exception {
        return this.doWithWorkflow(this.getSpaceKey(), new WorkflowCommand(){

            @Override
            public void command(Workflow workflow) throws WorkflowException {
                workflow.setActive(enable);
                SpaceWorkflowsAction.this.workflowContainerManager.saveWorkflowTemplate(SpaceWorkflowsAction.this.getSpaceKey(), workflow, false, null);
            }
        });
    }

    @ReadOnlyAccessBlocked
    public String unlinkTemplate() {
        return this.doWithWorkflow(null, new WorkflowCommand(){

            @Override
            public void command(Workflow workflow) {
                SpaceWorkflowsAction.this.linkedTemplateManager.removeTemplateLink(SpaceWorkflowsAction.this.getSpaceKey(), SpaceWorkflowsAction.this.workflowName);
            }
        });
    }

    private String doWithWorkflow(String spaceKey, WorkflowCommand command) {
        this.clearErrorMessage();
        try {
            Workflow workflow = this.workflowContainerManager.getWorkflowTemplate(spaceKey, this.workflowName);
            if (workflow == null) {
                throw new WorkflowException("invalid workflow name " + spaceKey + ":" + this.workflowName);
            }
            command.command(workflow);
        }
        catch (WorkflowException e) {
            log.error(e.getMessage());
            this.setErrorMessage(e.getMessage());
        }
        return "success";
    }

    private String doWithProductionWorkflow(String spaceKey, WorkflowCommand command) {
        this.clearErrorMessage();
        try {
            Workflow workflow = this.workflowContainerManager.getProductionWorkflow(spaceKey, this.workflowName);
            if (workflow == null) {
                throw new WorkflowException("invalid workflow name " + spaceKey + ":" + this.workflowName);
            }
            command.command(workflow);
        }
        catch (WorkflowException e) {
            log.error(e.getMessage());
            this.setErrorMessage(e.getMessage());
        }
        return "success";
    }

    private void clearErrorMessage() {
        errorMessageThreadLocal.remove();
    }

    public boolean isHasErrorMessage() {
        return errorMessageThreadLocal.get() != null;
    }

    public String getErrorMessage() {
        String message = errorMessageThreadLocal.get();
        this.clearErrorMessage();
        return message;
    }

    private void setErrorMessage(String message) {
        errorMessageThreadLocal.set(message);
    }

    public void setWorkflowContainerManager(WorkflowContainerManager workflowContainerManager) {
        this.workflowContainerManager = workflowContainerManager;
    }

    public List<Workflow> getProductionWorkflows() {
        return this.productionWorkflows;
    }

    public boolean isHasActiveProductionWorkflows() {
        return this.hasActiveProductionWorkflows;
    }

    public void setWorkflowConfigurationManager(WorkflowConfigurationManager workflowConfigurationManager) {
        this.workflowConfigurationManager = workflowConfigurationManager;
    }

    public void setWebResourceManager(WebResourceManager webResourceManager) {
        this.webResourceManager = webResourceManager;
    }

    private void loadWorkflows() {
        this.globalWorkflows = this.workflowContainerManager.getAvailableWorkflowTemplates(null);
        this.spaceWorkflows = this.workflowContainerManager.getWorkflowTemplates(this.getSpace());
        this.productionWorkflows = this.workflowContainerManager.getAllProductionWorkflows(this.getSpaceKey());
        this.linkedWorkflowTemplates = this.linkedTemplateManager.getLinkedTemplates(this.getSpaceKey());
        for (com.comalatech.workflow.model.Workflow linkedTemplate : this.linkedWorkflowTemplates) {
            if (!linkedTemplate.isActive()) continue;
            this.hasActiveProductionWorkflows = true;
        }
        if (!this.hasActiveProductionWorkflows) {
            for (Workflow productionWorkflow : this.productionWorkflows) {
                if (!productionWorkflow.isActive()) continue;
                this.hasActiveProductionWorkflows = true;
                break;
            }
        }
    }

    public String render(String body) {
        PageContext context = new PageContext(this.getSpaceKey());
        context.pushRenderMode(RenderMode.suppress((long)1L));
        return this.wikiStyleRenderer.convertWikiToXHtml((RenderContext)context, body);
    }

    public boolean isSpaceRequired() {
        return true;
    }

    public boolean isViewPermissionRequired() {
        return true;
    }

    public boolean isShowWelcome() {
        return this.showWelcome;
    }

    public String getWelcomeUrl() {
        return this.welcomeUrl;
    }

    public String getWorkflowsVersionNumber() {
        return this.workflowsVersionNumber;
    }

    public String getWorkflowsVersionName() {
        return this.workflowsVersionName;
    }

    public boolean isPermitted() {
        return super.isPermitted() && this.permissionManager.hasPermission((User)this.getAuthenticatedUser(), Permission.ADMINISTER, (Object)this.getSpace()) && ("promoteSpaceWorkflow".equals(this.actionContextCompatManager.getName()) || this.isConfluenceAdministrator());
    }

    public List<Workflow> getSpaceWorkflows() {
        return this.spaceWorkflows;
    }

    public List<Workflow> getGlobalWorkflows() {
        return this.globalWorkflows;
    }

    public String getWorkflowName() {
        return this.workflowName;
    }

    public void setWorkflowName(String workflowName) {
        this.workflowName = workflowName;
    }

    public void setWikiStyleRenderer(WikiStyleRenderer wikiStyleRenderer) {
        this.wikiStyleRenderer = wikiStyleRenderer;
    }

    public WorkflowConfigurationManager getWorkflowConfigurationManager() {
        return this.workflowConfigurationManager;
    }

    @HtmlSafe
    public String getLicenseStatusMessage() {
        return this.licenseStatusMessage;
    }

    public void setLinkedTemplateManager(LinkedTemplateManager linkedTemplateManager) {
        this.linkedTemplateManager = linkedTemplateManager;
    }

    public List<com.comalatech.workflow.model.Workflow> getLinkedWorkflowTemplates() {
        return this.linkedWorkflowTemplates;
    }

    public String getProductiontype() {
        return this.productiontype;
    }

    public void setProductiontype(String productiontype) {
        this.productiontype = productiontype;
    }

    public void setLicenseManager(@Qualifier(value="adhocWorkflowsLicenseManager") AdhocWorkflowsLicenseManager licenseManager) {
        this.licenseManager = licenseManager;
    }

    public String getDocoUrl() {
        return this.docoUrl;
    }

    public void setActionContextCompatManager(@Qualifier(value="actionContextCompatManager") ActionContextCompatManager actionContextCompatManager) {
        this.actionContextCompatManager = actionContextCompatManager;
    }

    private static interface WorkflowCommand {
        public void command(Workflow var1) throws WorkflowException;
    }
}

