/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.restv2.resources;

import com.atlassian.confluence.compat.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.comalatech.confluence.adhoc.AdhocWorkflowManager;
import com.comalatech.confluence.adhocworkflows.rest.permissions.WorkflowsAppRequired;
import com.comalatech.confluence.ipc.api.DefaultWorkflowTemplateManager;
import com.comalatech.confluence.license.WorkflowsFeatureManager;
import com.comalatech.confluence.states.model.State;
import com.comalatech.confluence.workflow.Workflow;
import com.comalatech.confluence.workflow.WorkflowException;
import com.comalatech.confluence.workflow.WorkflowService;
import com.comalatech.confluence.workflow.model.Approval;
import com.comalatech.confluence.workflow.model.Condition;
import com.comalatech.confluence.workflow.model.Trigger;
import com.comalatech.confluence.workflow.model.WorkflowElement;
import com.comalatech.confluence.workflow.model.WorkflowPageFooter;
import com.comalatech.confluence.workflow.model.WorkflowPageHeader;
import com.comalatech.confluence.workflow.rest.model.PermissionRequired;
import com.comalatech.confluence.workflow.restv2.accessor.MarkupValidationException;
import com.comalatech.confluence.workflow.restv2.accessor.WorkflowMarkupManager;
import com.comalatech.confluence.workflow.restv2.model.RestWorkflow;
import com.comalatech.confluence.workflow.restv2.model.mappers.MapperException;
import com.comalatech.confluence.workflow.restv2.model.mappers.Mappers;
import com.comalatech.confluence.workflow.restv2.resources.AbstractRestResource;
import com.comalatech.workflow.model.WorkflowParameter;
import com.comalatech.workflow.template.WorkflowTemplateManager;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.annotate.JsonSubTypes;
import org.codehaus.jackson.annotate.JsonTypeInfo;
import org.codehaus.jackson.annotate.JsonTypeName;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;

@WorkflowsAppRequired
@Path(value="/markup")
public class WorkflowMarkupResource
extends AbstractRestResource {
    private static final Logger log = LoggerFactory.getLogger(WorkflowMarkupResource.class);
    public static final int CHARS_BEFORE_DIFFERENCE = 3;
    public static final int CHARS_OF_DIFFERENCE = 40;
    private final WorkflowMarkupManager workflowMarkupManager;
    private final WorkflowService workflowService;
    private final WorkflowTemplateManager workflowTemplateManager;
    private final AdhocWorkflowManager adhocWorkflowManager;

    public WorkflowMarkupResource(PermissionManager permissionManager, SpaceManager spaceManager, PageManager pageManager, WorkflowMarkupManager workflowMarkupManager, WorkflowsFeatureManager workflowsFeatureManager, WorkflowMarkupManager workflowMarkupManager1, WorkflowService workflowService, @Qualifier(value="workflowTemplateManager") WorkflowTemplateManager workflowTemplateManager, AdhocWorkflowManager adhocWorkflowManager) {
        super(permissionManager, spaceManager, pageManager, workflowMarkupManager, workflowsFeatureManager);
        this.workflowMarkupManager = workflowMarkupManager1;
        this.workflowService = workflowService;
        this.workflowTemplateManager = workflowTemplateManager;
        this.adhocWorkflowManager = adhocWorkflowManager;
    }

    @ReadOnlyAccessAllowed
    @POST
    @Path(value="/check")
    @Consumes(value={"text/plain"})
    @Produces(value={"application/json"})
    public Response isMarkupRestable(String markup) {
        Workflow workflow = this.workflowMarkupManager.parseFromWikiMarkup(markup);
        return this.isMarkupRestable(workflow);
    }

    @ReadOnlyAccessAllowed
    @POST
    @Path(value="/translate")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getFormatTranslated(final TranslationRequest req) {
        return new AbstractRestResource.RestCommand(){

            @Override
            public Response doExecute() {
                TranslationResponse resp = new TranslationResponse();
                if (req instanceof Json2MarkupRequest) {
                    Json2MarkupRequest j2m = (Json2MarkupRequest)req;
                    try {
                        WorkflowMarkupResource.this.workflowMarkupManager.validateJsonMarkup(j2m.json);
                    }
                    catch (MarkupValidationException e) {
                        resp.status = TranslationResponseStatus.JSON2MARKUP_ERROR.toString();
                        resp.errors = e.getErrors();
                        resp.message = ConfluenceActionSupport.getTextStatic((String)"json.translation.error");
                        resp.workflow = j2m.json;
                        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)resp).type("application/json").build();
                    }
                    Workflow resultWorkflow = Mappers.workflowMapper.fromRest(j2m.json);
                    WorkflowMarkupResource.this.moveReadAckMacroOutsideState(resultWorkflow);
                    resp.status = TranslationResponseStatus.JSON2MARKUP_SUCCESS.toString();
                    resp.workflow = j2m.json;
                    resp.markup = resultWorkflow.getWorkflowMarkup();
                    return Response.ok((Object)resp).type("application/json").build();
                }
                if (req instanceof Markup2JsonRequest) {
                    Markup2JsonRequest m2j = (Markup2JsonRequest)req;
                    Workflow workflow = WorkflowMarkupResource.this.workflowMarkupManager.parseFromWikiMarkup(m2j.markup);
                    WorkflowMarkupResource.this.moveReadAckMacroOutsideState(workflow);
                    if (workflow == null || workflow.getErrorMessage() != null) {
                        resp.status = TranslationResponseStatus.MARKUP2JSON_ERROR.toString();
                        resp.message = ConfluenceActionSupport.getTextStatic((String)"markup.translation.error");
                        if (workflow != null) {
                            resp.errors = Collections.singletonList(workflow.getErrorMessage());
                        }
                        resp.markup = m2j.markup;
                        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)resp).type("application/json").build();
                    }
                    WorkflowMarkupResource.this.reorderWorkflowElements(workflow);
                    RestWorkflow restWorkflow = Mappers.workflowMapper.toRest(workflow);
                    Workflow workflowFromRest = Mappers.workflowMapper.fromRest(restWorkflow);
                    WorkflowMarkupResource.this.reorderWorkflowElements(workflowFromRest);
                    if (workflow.getWorkflowMarkup().equals(workflowFromRest.toMacro().toString())) {
                        resp.status = TranslationResponseStatus.MARKUP2JSON_SUCCESS.toString();
                        resp.workflow = restWorkflow;
                        resp.markup = workflow.getWorkflowMarkup();
                        return Response.ok((Object)resp).type("application/json").build();
                    }
                    int indexOfDifference = StringUtils.indexOfDifference((CharSequence)workflow.getWorkflowMarkup(), (CharSequence)workflowFromRest.toMacro().toString());
                    String initialSubstring = workflow.getWorkflowMarkup().substring(Math.max(0, indexOfDifference - 3), Math.min(workflow.getWorkflowMarkup().length() - 1, indexOfDifference + 40));
                    String resultSubstring = workflowFromRest.toMacro().toString().substring(Math.max(0, indexOfDifference - 3), Math.min(workflowFromRest.toMacro().toString().length() - 1, indexOfDifference + 40));
                    resp.status = TranslationResponseStatus.MARKUP2JSON_NOT_COMPATIBLE.toString();
                    resp.workflow = restWorkflow;
                    resp.markup = workflow.getWorkflowMarkup();
                    resp.builderCompatibleMarkup = workflowFromRest.getWorkflowMarkup();
                    resp.message = ConfluenceActionSupport.getTextStatic((String)"markup.translation.notcompatible");
                    resp.errors = Collections.singletonList("Markups differ at <" + initialSubstring + "> compared to <" + resultSubstring + ">");
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)resp).type("application/json").build();
                }
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Invalid translation request").type("application/json").build();
            }
        }.execute();
    }

    @ReadOnlyAccessAllowed
    @POST
    @Path(value="/check/{spaceKey}/{workflowId}")
    @PermissionRequired(value={"ADMINISTER"})
    @Produces(value={"application/json"})
    public Response checkSpaceWorkflow(final @PathParam(value="spaceKey") String spaceKey, final @PathParam(value="workflowId") String workflowId) {
        return new AbstractRestResource.RestSpaceCommand(spaceKey){

            @Override
            public Response doExecute() {
                List<com.comalatech.workflow.model.Workflow> spaceWorkflows = WorkflowMarkupResource.this.workflowService.getWorkflows(spaceKey);
                if (spaceWorkflows == null) {
                    return Response.noContent().build();
                }
                Optional<com.comalatech.workflow.model.Workflow> workflow = spaceWorkflows.stream().filter(wf -> workflowId.equals(((Workflow)wf).getHandle())).findFirst();
                if (!workflow.isPresent()) {
                    return Response.noContent().build();
                }
                return WorkflowMarkupResource.this.isMarkupRestable((Workflow)workflow.get());
            }
        }.execute();
    }

    @ReadOnlyAccessAllowed
    @POST
    @Path(value="/check/{workflowId}")
    @PermissionRequired(value={"ADMINISTER"})
    @Produces(value={"application/json"})
    public Response checkGlobalWorkflow(final @PathParam(value="workflowId") String workflowId) {
        return new AbstractRestResource.RestCommand(){

            @Override
            public Response doExecute() {
                List<com.comalatech.workflow.model.Workflow> globalWorkflows = ((DefaultWorkflowTemplateManager)WorkflowMarkupResource.this.workflowTemplateManager).getAllWorkflowTemplates();
                if (globalWorkflows == null) {
                    return Response.noContent().build();
                }
                Optional<com.comalatech.workflow.model.Workflow> workflow = globalWorkflows.stream().filter(wf -> workflowId.equals(((Workflow)wf).getHandle())).findFirst();
                if (!workflow.isPresent()) {
                    return Response.noContent().build();
                }
                return WorkflowMarkupResource.this.isMarkupRestable((Workflow)workflow.get());
            }
        }.execute();
    }

    @ReadOnlyAccessAllowed
    @POST
    @Path(value="/check/page/{contentId}")
    @PermissionRequired(value={"EDIT"})
    @Produces(value={"application/json"})
    public Response checkPageWorkflow(final @PathParam(value="contentId") Long contentId) {
        return new AbstractRestResource.RestPageCommand(contentId){

            @Override
            public Response doExecute() {
                AbstractPage page = WorkflowMarkupResource.this.pageManager.getAbstractPage(contentId.longValue());
                if (page == null) {
                    return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
                }
                try {
                    Workflow workflow = WorkflowMarkupResource.this.adhocWorkflowManager.getPageWorkflow(page);
                    return WorkflowMarkupResource.this.isMarkupRestable(workflow);
                }
                catch (WorkflowException ex) {
                    log.error("Error getting page workflow", (Throwable)ex);
                    return Response.serverError().build();
                }
            }
        }.execute();
    }

    @ReadOnlyAccessAllowed
    @POST
    @Path(value="/check/{spaceKey}/pagetemplate/{workflowId}")
    @PermissionRequired(value={"EDIT"})
    @Produces(value={"application/json"})
    public Response checkPageTemplate(final @PathParam(value="spaceKey") String spaceKey, final @PathParam(value="workflowId") String workflowId) {
        return new AbstractRestResource.RestSpaceCommand(spaceKey){

            @Override
            public Response doExecute() {
                try {
                    com.comalatech.workflow.model.Workflow workflow = WorkflowMarkupResource.this.workflowService.getWorkflow(spaceKey, workflowId);
                    if (workflow != null) {
                        return WorkflowMarkupResource.this.isMarkupRestable((Workflow)workflow);
                    }
                    return Response.noContent().build();
                }
                catch (WorkflowException e) {
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
                }
            }
        }.execute();
    }

    private Response isMarkupRestable(Workflow workflow) {
        TranslationResponse resp = new TranslationResponse();
        try {
            this.reorderWorkflowElements(workflow);
            String initialMarkup = workflow.getWorkflowMarkup();
            RestWorkflow restWorkflow = Mappers.workflowMapper.toRest(workflow);
            this.workflowMarkupManager.validateJsonMarkup(restWorkflow);
            Workflow resultWorkflow = Mappers.workflowMapper.fromRest(restWorkflow);
            this.reorderWorkflowElements(resultWorkflow);
            String resultMarkup = resultWorkflow.getWorkflowMarkup();
            if (initialMarkup.equals(resultMarkup)) {
                JSONObject entity = new JSONObject();
                entity.put("status", 200);
                return Response.ok((Object)entity.toString()).type("application/json").build();
            }
            int indexOfDifference = StringUtils.indexOfDifference((CharSequence)initialMarkup, (CharSequence)resultMarkup);
            String initialSubstring = initialMarkup.substring(Math.max(0, indexOfDifference - 3), Math.min(initialMarkup.length() - 1, indexOfDifference + 40));
            String resultSubstring = resultMarkup.substring(Math.max(0, indexOfDifference - 3), Math.min(resultMarkup.length() - 1, indexOfDifference + 40));
            resp.status = TranslationResponseStatus.MARKUP2JSON_NOT_COMPATIBLE.toString();
            resp.errors = Collections.singletonList("Markups differ at <" + initialSubstring + "> compared to <" + resultSubstring + ">");
            resp.markup = initialMarkup;
            resp.builderCompatibleMarkup = resultMarkup;
            resp.message = ConfluenceActionSupport.getTextStatic((String)"markup.translation.notcompatible");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)resp).type("application/json").build();
        }
        catch (MarkupValidationException mvEx) {
            log.error("Validation error in the markup generated", (Throwable)mvEx);
            mvEx.getErrors().forEach(error -> log.error("  - " + error));
            resp.status = TranslationResponseStatus.MARKUP2JSON_ERROR.toString();
            resp.message = ConfluenceActionSupport.getTextStatic((String)"markup.check.error");
            resp.errors = mvEx.getErrors();
            resp.markup = workflow.getWorkflowMarkup();
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)resp).type("application/json").build();
        }
        catch (MapperException mEx) {
            return this.handleException(mEx);
        }
    }

    private void reorderWorkflowElements(Workflow workflow) {
        List<WorkflowElement> workflowElements = workflow.getOrderedElementList();
        workflowElements.sort(new Comparator<WorkflowElement>(){

            @Override
            public int compare(WorkflowElement o1, WorkflowElement o2) {
                return this.getWeight(o1) - this.getWeight(o2);
            }

            private int getWeight(WorkflowElement element) {
                if (element instanceof Trigger) {
                    return 5;
                }
                if (element instanceof Approval) {
                    return 4;
                }
                if (element instanceof com.comalatech.workflow.model.State) {
                    return 3;
                }
                if (element instanceof WorkflowParameter) {
                    return 2;
                }
                if (element instanceof WorkflowPageFooter) {
                    return 1;
                }
                if (element instanceof WorkflowPageHeader) {
                    return 0;
                }
                return 10;
            }
        });
        workflow.getWorkflowStates().stream().forEach(state -> ((State)state).getApprovals().stream().forEach(approval -> approval.getConditions().sort(new Comparator<Condition>(){

            @Override
            public int compare(Condition o1, Condition o2) {
                return o1.getClass().getName().compareTo(o2.getClass().getName());
            }
        })));
        workflow.getExplicitTriggers().stream().forEach(trigger -> trigger.getConditions().sort(new Comparator<Condition>(){

            @Override
            public int compare(Condition o1, Condition o2) {
                return o1.getClass().getName().compareTo(o2.getClass().getName());
            }
        }));
    }

    public static enum TranslationResponseStatus {
        MARKUP2JSON_ERROR("markup2JsonError"),
        MARKUP2JSON_SUCCESS("markup2JsonSuccess"),
        MARKUP2JSON_NOT_COMPATIBLE("markup2JsonNotCompatible"),
        JSON2MARKUP_ERROR("json2MarkupError"),
        JSON2MARKUP_SUCCESS("json2MarkupSuccess");

        private String name;

        private TranslationResponseStatus(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.getName();
        }
    }

    @JsonTypeName(value="markup2Json")
    public static class Markup2JsonRequest
    extends TranslationRequest {
        public String markup;

        public Markup2JsonRequest() {
        }

        public Markup2JsonRequest(String markup) {
            this.markup = markup;
        }
    }

    @JsonTypeName(value="json2Markup")
    public static class Json2MarkupRequest
    extends TranslationRequest {
        public RestWorkflow json;

        public Json2MarkupRequest() {
        }

        public Json2MarkupRequest(RestWorkflow json) {
            this.json = json;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_EMPTY)
    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
    @JsonSubTypes(value={@JsonSubTypes.Type(value=Json2MarkupRequest.class, name="json2Markup"), @JsonSubTypes.Type(value=Markup2JsonRequest.class, name="markup2Json")})
    public static abstract class TranslationRequest {
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_EMPTY)
    public static class TranslationResponse {
        public String status;
        public String markup;
        public RestWorkflow workflow;
        public String message;
        public List<String> errors;
        public String builderCompatibleMarkup;
    }
}

