/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.restv2.accessor;

import com.comalatech.confluence.workflow.Workflow;
import com.comalatech.confluence.workflow.WorkflowException;
import com.comalatech.confluence.workflow.parser.WorkflowParser;
import com.comalatech.confluence.workflow.restv2.accessor.MarkupValidationException;
import com.comalatech.confluence.workflow.restv2.accessor.WorkflowMarkupManager;
import com.comalatech.confluence.workflow.restv2.model.RestWorkflow;
import com.comalatech.confluence.workflow.restv2.model.mappers.Mappers;
import java.io.IOException;
import java.io.InputStream;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.everit.json.schema.Schema;
import org.everit.json.schema.ValidationException;
import org.everit.json.schema.loader.SchemaLoader;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultWorkflowMarkupManager
implements WorkflowMarkupManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultWorkflowMarkupManager.class);
    private final WorkflowParser workflowParser;

    public DefaultWorkflowMarkupManager(WorkflowParser workflowParser) {
        this.workflowParser = workflowParser;
    }

    @Override
    public void validateJsonMarkup(String jsonMarkup) throws MarkupValidationException {
        try {
            InputStream inputStream = this.getClass().getResourceAsStream("/workflows/schema-workflow.json");
            JSONObject rawSchema = new JSONObject(new JSONTokener(inputStream));
            Schema schema = SchemaLoader.load(rawSchema);
            JSONObject markup = new JSONObject(jsonMarkup);
            schema.validate(markup);
        }
        catch (ValidationException vex) {
            throw new MarkupValidationException(vex.getAllMessages());
        }
    }

    @Override
    public void validateJsonMarkup(RestWorkflow workflow) throws MarkupValidationException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonSerialize.Inclusion.NON_EMPTY);
        try {
            String json = mapper.writeValueAsString((Object)workflow);
            if (log.isDebugEnabled()) {
                log.debug("Validating JSON markup against schema\n" + json);
            }
            this.validateJsonMarkup(json);
        }
        catch (IOException ex) {
            log.error("Error parsing the json markup", (Throwable)ex);
        }
    }

    @Override
    public Workflow parseFromWikiMarkup(String wikiMarkup) {
        try {
            return this.workflowParser.parseWorkflow(wikiMarkup);
        }
        catch (WorkflowException ex) {
            return null;
        }
    }

    @Override
    public Workflow parseFromJsonMarkup(String jsonMarkup) throws MarkupValidationException {
        this.validateJsonMarkup(jsonMarkup);
        ObjectMapper mapper = new ObjectMapper();
        try {
            RestWorkflow restWorkflow = (RestWorkflow)mapper.readValue(jsonMarkup, RestWorkflow.class);
            return Mappers.workflowMapper.fromRest(restWorkflow);
        }
        catch (IOException ex) {
            log.error("Error parsing the json markup", (Throwable)ex);
            return null;
        }
    }

    @Override
    public String convertToJson(Workflow workflow) {
        RestWorkflow restWorkflow = Mappers.workflowMapper.toRest(workflow);
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonSerialize.Inclusion.NON_EMPTY);
        try {
            return mapper.writeValueAsString((Object)restWorkflow);
        }
        catch (IOException ex) {
            log.error("Error parsing the json markup", (Throwable)ex);
            return null;
        }
    }
}

