/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.analytics.web;

import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.comalatech.confluence.analytics.AnalyticsManager;
import com.comalatech.confluence.workflow.analytics.web.WebAnalyticsManager;
import java.util.HashMap;
import java.util.Map;

public class MatomoWebAnalyticsManagerImpl
implements WebAnalyticsManager {
    private static final String MATOMO_DOMAIN = "comalatech.matomo.cloud";
    private static final Map<String, String> UA_KEY_MAP = new HashMap<String, String>();
    private AnalyticsManager analyticsManager;
    private PluginLicenseManager licenseManager;

    public MatomoWebAnalyticsManagerImpl(AnalyticsManager analyticsManager, PluginLicenseManager licenseManager) {
        this.analyticsManager = analyticsManager;
        this.licenseManager = licenseManager;
    }

    @Override
    public String getUAKey() {
        if (this.isProdInstance()) {
            return this.getPluginUAKey("PROD");
        }
        return this.getPluginUAKey("DEV");
    }

    @Override
    public String getAnalyticsDomain() {
        return MATOMO_DOMAIN;
    }

    @Override
    public boolean isStatsEnabled() {
        return this.analyticsManager.isEnabled();
    }

    private boolean isProdInstance() {
        return !this.analyticsManager.isDevMode() && this.isValidLicense();
    }

    private boolean isValidLicense() {
        if (this.licenseManager.getLicense().isDefined()) {
            PluginLicense pluginLicense = (PluginLicense)this.licenseManager.getLicense().get();
            return pluginLicense.isValid() || pluginLicense.isEvaluation();
        }
        return false;
    }

    protected String getPluginUAKey(String instanceType) {
        String pluginUAKey;
        switch (this.licenseManager.getPluginKey()) {
            case "com.comalatech.cloud.approvals": {
                pluginUAKey = UA_KEY_MAP.get("CDC_" + instanceType + "_UA");
                break;
            }
            case "com.comalatech.workflow.approvals": {
                pluginUAKey = UA_KEY_MAP.get("CDA_" + instanceType + "_UA");
                break;
            }
            default: {
                pluginUAKey = UA_KEY_MAP.get("CDM_" + instanceType + "_UA");
            }
        }
        return pluginUAKey;
    }

    static {
        UA_KEY_MAP.put("CDM_DEV_UA", "5");
        UA_KEY_MAP.put("CDM_PROD_UA", "6");
        UA_KEY_MAP.put("CDC_DEV_UA", "9");
        UA_KEY_MAP.put("CDC_PROD_UA", "10");
        UA_KEY_MAP.put("CDA_DEV_UA", "11");
        UA_KEY_MAP.put("CDA_PROD_UA", "12");
    }
}

