/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.states.model;

import com.comalatech.confluence.states.model.Activity;
import com.comalatech.confluence.states.model.Assignment;
import com.comalatech.confluence.tasks.model.Assignable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public abstract class AssignableActivity
extends Activity
implements Assignable {
    private List<Assignment> assignments;

    public abstract String getName();

    public AssignableActivity() {
    }

    protected AssignableActivity(String user, Date date) {
        super(user, date);
        this.assignments = new ArrayList<Assignment>();
    }

    @Override
    public void assign(Assignment assignment) {
        assignment.syncDueDateTime();
        this.addAssignment(assignment);
    }

    @Override
    public void addAssignment(Assignment assignment) {
        this.assignments.add(assignment);
    }

    public Assignment getLastAssignment() {
        if (this.assignments.size() == 0) {
            return null;
        }
        return this.assignments.get(this.assignments.size() - 1);
    }

    public void setAssignments(List<Assignment> assignments) {
        this.assignments = assignments;
    }

    public boolean isAssigned() {
        return this.assignments.size() > 0;
    }

    public List<Assignment> getAssignments() {
        return this.assignments;
    }
}

