/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.onboard;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.core.AtlassianCoreException;
import com.atlassian.core.user.preferences.UserPreferences;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.atlassian.user.User;
import com.comalatech.confluence.license.AdhocWorkflowsLicenseManager;
import com.comalatech.confluence.license.WorkflowsFeatureManager;
import com.comalatech.confluence.onboard.OnboardingManager;
import com.comalatech.confluence.util.keys.OnBoardKeys;
import com.comalatech.confluence.workflow.WorkflowConfigurationManager;
import com.comalatech.confluence.workflow.rules.permission.PermissionRule;
import com.comalatech.confluence.workflow.rules.validation.VerificationRule;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;

public class DefaultOnboardingManager
implements OnboardingManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultOnboardingManager.class);
    private final UserAccessor userAccessor;
    private final WorkflowsFeatureManager workflowsFeatureManager;
    private final WorkflowConfigurationManager workflowConfigurationManager;
    private final PermissionRule<AbstractPage> hasPageWorkflow;
    private final PermissionRule<AbstractPage> canHavePageWorkflow;
    private final VerificationRule<String> isInSevenDaysPeriod;
    private final DarkFeatureManager darkFeatureManager;
    private final AdhocWorkflowsLicenseManager workflowsLicenseManager;
    private final String pageHideCheck;
    private final String seenDateKey;

    public DefaultOnboardingManager(UserAccessor userAccessor, WorkflowsFeatureManager workflowsFeatureManager, WorkflowConfigurationManager workflowConfigurationManager, @Qualifier(value="hasPageWorkflow") PermissionRule<AbstractPage> hasPageWorkflow, @Qualifier(value="canHavePageWorkflow") PermissionRule<AbstractPage> canHavePageWorkflow, VerificationRule<String> isInSevenDaysPeriod, DarkFeatureManager darkFeatureManager, @Qualifier(value="adhocWorkflowsLicenseManager") AdhocWorkflowsLicenseManager workflowsLicenseManager) {
        this.userAccessor = userAccessor;
        this.workflowsFeatureManager = workflowsFeatureManager;
        this.workflowConfigurationManager = workflowConfigurationManager;
        this.hasPageWorkflow = hasPageWorkflow;
        this.canHavePageWorkflow = canHavePageWorkflow;
        this.isInSevenDaysPeriod = isInSevenDaysPeriod;
        this.darkFeatureManager = darkFeatureManager;
        this.workflowsLicenseManager = workflowsLicenseManager;
        this.pageHideCheck = (Object)((Object)OnBoardKeys.PAGE_HIDE_CHECK) + "-" + workflowsFeatureManager.getPluginKey();
        this.seenDateKey = (Object)((Object)OnBoardKeys.DATE_SEEN_KEY) + "-" + workflowsFeatureManager.getPluginKey();
    }

    @Override
    public boolean showDashboard(ConfluenceUser user) {
        boolean onBoardEnable;
        boolean bl = onBoardEnable = this.workflowConfigurationManager.isOnboardEnabled() && this.workflowsLicenseManager.isLicensed();
        if (this.darkFeatureManager.isFeatureEnabledForAllUsers("comalatech.workflows.onboarding.force.show.items")) {
            return onBoardEnable;
        }
        if (!onBoardEnable) {
            return false;
        }
        if (!this.workflowsFeatureManager.isNewInstallation()) {
            return false;
        }
        if (Objects.isNull(user)) {
            return false;
        }
        boolean dateIsEmpty = true;
        UserPreferences userPreferences = this.userAccessor.getUserPreferences((User)user);
        if (userPreferences != null) {
            try {
                String dateSeenString = userPreferences.getString(this.seenDateKey);
                LocalDateTime savedTime = LocalDateTime.parse(dateSeenString);
                dateIsEmpty = false;
                log.debug("Dashboard has been shown for user {}, in {}", (Object)user, (Object)savedTime);
            }
            catch (Exception e) {
                log.debug("Cannot parse date from user preferences {} {}", (Object)user, (Object)e);
            }
        }
        return dateIsEmpty;
    }

    @Override
    public boolean showPage(ConfluenceUser user, AbstractPage page) {
        boolean onBoardEnable;
        if (page == null) {
            return false;
        }
        boolean bl = onBoardEnable = this.workflowConfigurationManager.isOnboardEnabled() && this.workflowsLicenseManager.isLicensed();
        if (this.darkFeatureManager.isFeatureEnabledForAllUsers("comalatech.workflows.onboarding.force.show.items")) {
            return onBoardEnable;
        }
        if (Duration.between(page.getLastModificationDate().toInstant(), Instant.now()).toMillis() > Duration.ofDays(1L).toMillis()) {
            return false;
        }
        if (!onBoardEnable) {
            return false;
        }
        if (user != null && page.getCreator() != null && !page.getCreator().equals(user)) {
            return false;
        }
        if (!this.hasPermission(page)) {
            return false;
        }
        if (!this.workflowsFeatureManager.isNewInstallation()) {
            return false;
        }
        UserPreferences userPreferences = this.userAccessor.getUserPreferences((User)user);
        if (userPreferences == null) {
            return false;
        }
        boolean panelShouldBeHidden = userPreferences.getBoolean(this.pageHideCheck);
        if (panelShouldBeHidden) {
            return false;
        }
        String dateSeenString = this.getDateFromUserPreferences(userPreferences);
        return this.isInSevenDaysPeriod.validate(dateSeenString);
    }

    @Override
    public void saveSeenDate(ConfluenceUser user, LocalDateTime time) throws AtlassianCoreException {
        String pluginKey = this.workflowsFeatureManager.getPluginKey();
        String key = (Object)((Object)OnBoardKeys.DATE_SEEN_KEY) + "-" + pluginKey;
        this.userAccessor.getUserPreferences((User)user).setString(key, time.toString());
    }

    @Override
    public void savePageHideCheck(ConfluenceUser user) throws AtlassianCoreException {
        String pluginKey = this.workflowsFeatureManager.getPluginKey();
        String key = (Object)((Object)OnBoardKeys.PAGE_HIDE_CHECK) + "-" + pluginKey;
        this.userAccessor.getUserPreferences((User)user).setBoolean(key, true);
    }

    @Override
    public String getSeenDate(ConfluenceUser user) {
        UserPreferences userPreferences = this.userAccessor.getUserPreferences((User)user);
        return this.getDateFromUserPreferences(userPreferences);
    }

    private String getDateFromUserPreferences(UserPreferences userPreferences) {
        if (userPreferences != null) {
            return userPreferences.getString(this.seenDateKey);
        }
        return "";
    }

    private boolean hasPermission(AbstractPage page) {
        return !this.hasPageWorkflow.validate(page) && this.canHavePageWorkflow.validate(page);
    }
}

