/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.documentActivity.upgrade.service;

import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.util.longrunning.LongRunningTaskManager;
import com.comalatech.confluence.documentActivity.upgrade.accessor.SpacePreCheckAccessor;
import com.comalatech.confluence.documentActivity.upgrade.accessor.entity.PreCheckRecord;
import com.comalatech.confluence.documentActivity.upgrade.entity.domain.PreCheck;
import com.comalatech.confluence.documentActivity.upgrade.entity.domain.PreCheckStatus;
import com.comalatech.confluence.documentActivity.upgrade.entity.domain.SpaceUpgrade;
import com.comalatech.confluence.documentActivity.upgrade.entity.domain.Upgrade;
import com.comalatech.confluence.documentActivity.upgrade.entity.domain.UpgradeMetadata;
import com.comalatech.confluence.documentActivity.upgrade.service.DocumentActivityUpgradeService;
import com.comalatech.confluence.documentActivity.upgrade.service.mapper.PreCheckMapper;
import com.comalatech.confluence.documentActivity.upgrade.service.mapper.SpaceUpgradeMapper;
import com.comalatech.confluence.documentActivity.upgrade.utils.SupportPackageFile;
import com.comalatech.confluence.workflow.accesor.WorkflowsActivityRecordAccessor;
import com.comalatech.confluence.workflow.accesor.entity.WorkflowActivityRecord;
import com.comalatech.confluence.workflow.analytics.UpgradeStatsGatherer;
import com.comalatech.confluence.workflow.supportconsole.infrastructure.CompressionUtils;
import java.io.IOException;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.stream.Collectors;

public class DocumentActivityUpgradeServiceImpl
implements DocumentActivityUpgradeService {
    private final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd-HH-mm-ss");
    private final WorkflowsActivityRecordAccessor workflowsActivityAccessor;
    private final SpacePreCheckAccessor spacePreCheckAccessor;
    private final SpaceUpgradeMapper spaceUpgradeMapper;
    private final PreCheckMapper preCheckMapper;
    private final SpaceManager spaceManager;
    private final UpgradeStatsGatherer upgradeStatsGatherer;

    public DocumentActivityUpgradeServiceImpl(WorkflowsActivityRecordAccessor workflowsActivityAccessor, SpacePreCheckAccessor spacePreCheckAccessor, SpaceManager spaceManager, PageManager pageManager, LongRunningTaskManager longRunningTaskManager, UpgradeStatsGatherer upgradeStatsGatherer) {
        this.workflowsActivityAccessor = workflowsActivityAccessor;
        this.spacePreCheckAccessor = spacePreCheckAccessor;
        this.spaceManager = spaceManager;
        this.upgradeStatsGatherer = upgradeStatsGatherer;
        this.spaceUpgradeMapper = new SpaceUpgradeMapper(spaceManager, pageManager);
        this.preCheckMapper = new PreCheckMapper(longRunningTaskManager);
    }

    @Override
    public Upgrade getUpgradeData() {
        List<SpaceUpgrade> spaceUpgrades = null;
        UpgradeMetadata upgradeMetadata = new UpgradeMetadata();
        List<WorkflowActivityRecord> spaceWorkflowActivities = this.workflowsActivityAccessor.findAllWorkflowActivity();
        if (spaceWorkflowActivities != null) {
            spaceUpgrades = spaceWorkflowActivities.stream().map(this.spaceUpgradeMapper::fromRecordToModel).collect(Collectors.toList());
            spaceUpgrades.forEach(elem -> elem.setPreCheck(this.getSpacePreCheck(elem.getSpace())));
            upgradeMetadata.setTotalPagesWithHistory(spaceWorkflowActivities.stream().mapToLong(WorkflowActivityRecord::getNumPages).sum());
            upgradeMetadata.setTotalSpacesWithHistory(spaceWorkflowActivities.stream().mapToLong(WorkflowActivityRecord::getSpaceId).count());
            List pagesWithWorkflowPerSpace = spaceWorkflowActivities.stream().map(WorkflowActivityRecord::getNumPages).collect(Collectors.toList());
            double medianPagesWithWorkflowPerSpace = pagesWithWorkflowPerSpace.stream().sorted().skip(Math.max(0, (pagesWithWorkflowPerSpace.size() + 1) / 2 - 1)).limit(1 + (1 + pagesWithWorkflowPerSpace.size()) % 2).mapToLong(Long::intValue).average().orElse(0.0);
            upgradeMetadata.setMedianPagesWithWorkflowPerSpace(medianPagesWithWorkflowPerSpace);
            upgradeMetadata.setHighestNumPagesWithWorkflowPerSpace(spaceWorkflowActivities.stream().mapToLong(WorkflowActivityRecord::getNumPages).max().orElse(0L));
            upgradeMetadata.setTotalUpgradeSpacesChecked(spaceUpgrades.stream().map(SpaceUpgrade::getPreCheck).filter(elem -> !PreCheckStatus.NOT_RUN.equals((Object)elem.getStatus())).count());
            upgradeMetadata.setTotalDocActivityEntries((Long)this.upgradeStatsGatherer.getTotalDocActivityEntriesAsStatField(spaceWorkflowActivities).getProcessor().execute());
        }
        upgradeMetadata.setTotalSpaces(Long.valueOf(this.spaceManager.getAllSpaces().size()));
        return new Upgrade(spaceUpgrades, upgradeMetadata);
    }

    @Override
    public PreCheck getSpacePreCheck(Space space) {
        PreCheckRecord preCheckRecord = this.spacePreCheckAccessor.getSpacePreCheck(space);
        return this.preCheckMapper.fromRecordToModel(preCheckRecord, space);
    }

    @Override
    public void saveSpacePreCheck(Space space, PreCheck preCheck) {
        PreCheckRecord preCheckRecord = this.preCheckMapper.fromModelToRecord(preCheck);
        this.spacePreCheckAccessor.saveSpacePreCheck(space, preCheckRecord);
    }

    @Override
    public Path getSupportFile(Space space) throws IOException {
        Path zipPath = SupportPackageFile.generateFile(SupportPackageFile.getSpaceUpgradeBasePath(space.getKey()), "COMALA_UPGRADE_" + space.getKey() + "_" + this.FORMATTER.format(LocalDateTime.now()) + ".zip");
        CompressionUtils.compressToZip(SupportPackageFile.getDataBasePath(space.getKey(), null), zipPath);
        return zipPath;
    }
}

