/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.documentActivity.reports;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.comalatech.confluence.documentActivity.domain.entities.Activity;
import com.comalatech.confluence.workflowreports.ReportDateFormatter;
import com.comalatech.confluence.workflowreports.pageactivity.PageActivityCsvEntryProcessorAO;
import com.comalatech.confluence.workflowreports.pageactivity.PageActivityCsvService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocActivityCsvServiceImpl
implements PageActivityCsvService<Activity> {
    private static final Logger log = LoggerFactory.getLogger(DocActivityCsvServiceImpl.class);
    protected static final String LINE_SEPARATOR = System.getProperty("line.separator");
    protected static final String COMMA = ",";
    private final PageActivityCsvEntryProcessorAO aoProcessor;

    public DocActivityCsvServiceImpl(LocaleManager localeManager, PageManager pageManager) {
        ReportDateFormatter dateFormatter = new ReportDateFormatter(localeManager);
        this.aoProcessor = new PageActivityCsvEntryProcessorAO(pageManager, dateFormatter);
    }

    @Override
    public String getPageActivityFileContent(List<Activity> entries, AbstractPage page) {
        if (entries.size() == 0) {
            return "";
        }
        return this.generateCsvFileContent(entries, page);
    }

    public String generateCsvFileContent(List<Activity> entries, AbstractPage page) {
        if (entries.size() == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        this.generateHeaders(builder);
        this.processEntries(entries, builder, page);
        return builder.toString();
    }

    private void processEntries(List<Activity> entries, StringBuilder builder, AbstractPage page) {
        for (Activity entry : entries) {
            this.aoProcessor.processEntry(builder, page, entry);
        }
    }

    private void generateHeaders(StringBuilder builder) {
        builder.append(ConfluenceActionSupport.getTextStatic((String)"com.comalatech.activity.report.csvexport.date.header")).append(COMMA).append(ConfluenceActionSupport.getTextStatic((String)"com.comalatech.activity.report.csvexport.username.header")).append(COMMA);
        builder.append(ConfluenceActionSupport.getTextStatic((String)"com.comalatech.activity.report.csvexport.contributors.header")).append(COMMA);
        builder.append(ConfluenceActionSupport.getTextStatic((String)"com.comalatech.activity.report.csvexport.activity.header")).append(COMMA).append(ConfluenceActionSupport.getTextStatic((String)"com.comalatech.activity.report.csvexport.description.header")).append(COMMA).append(ConfluenceActionSupport.getTextStatic((String)"com.comalatech.activity.report.csvexport.pageversion.header")).append(COMMA).append(ConfluenceActionSupport.getTextStatic((String)"com.comalatech.activity.report.csvexport.pageId.header")).append(COMMA).append(ConfluenceActionSupport.getTextStatic((String)"com.comalatech.activity.report.csvexport.usercomment.header")).append(LINE_SEPARATOR);
    }
}

