/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.documentActivity.mapper.state;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.comalatech.confluence.documentActivity.domain.entities.Activity;
import com.comalatech.confluence.documentActivity.mapper.state.StateDueDateMapper;
import com.comalatech.confluence.documentActivity.mapper.state.StateInitMapper;
import com.comalatech.confluence.documentActivity.mapper.state.StateOverrideMapper;
import com.comalatech.confluence.documentActivity.mapper.state.StateTransitionMapper;
import com.comalatech.confluence.documentActivity.util.ActorUtils;
import com.comalatech.confluence.states.model.DueDateRecord;
import com.comalatech.confluence.states.model.PageState;
import com.comalatech.confluence.states.model.StateChangeReason;
import java.util.ArrayList;
import java.util.List;

public class StatesMapper {
    private final PageManager pageManager;
    private final StateTransitionMapper stateTransitionMapper;
    private final StateOverrideMapper stateOverrideMapper;
    private final StateInitMapper stateInitMapper;
    private final StateDueDateMapper stateDueDateMapper;

    public StatesMapper(PageManager pageManager, ActorUtils actorUtils) {
        this.pageManager = pageManager;
        this.stateTransitionMapper = new StateTransitionMapper(actorUtils);
        this.stateOverrideMapper = new StateOverrideMapper(actorUtils);
        this.stateInitMapper = new StateInitMapper(actorUtils);
        this.stateDueDateMapper = new StateDueDateMapper(actorUtils);
    }

    public List<Activity> buildStateTransitionActivities(PageState state, PageState previousState) throws Exception {
        List<DueDateRecord> dueDateHistory;
        ArrayList<Activity> activities = new ArrayList<Activity>();
        AbstractPage page = state.getPage();
        ContentEntityObject content = this.pageManager.getOtherVersion((ContentEntityObject)page, state.getVersion());
        if (state.getStateChangeReason() != null) {
            if (state.getStateChangeReason().equals((Object)StateChangeReason.ADMIN_OVERRIDE)) {
                activities.add(this.stateOverrideMapper.buildActivity((AbstractPage)content, state, previousState));
            }
            if (state.getStateChangeReason().equals((Object)StateChangeReason.SPACE_INITIALISE)) {
                activities.add(this.stateInitMapper.buildActivity((AbstractPage)content, state, previousState));
            }
        } else if (previousState != null) {
            activities.add(this.stateTransitionMapper.buildStateTransitionActivity((AbstractPage)content, state, previousState));
        } else {
            activities.add(this.stateTransitionMapper.buildInitialStateSetActivity((AbstractPage)content, state));
        }
        if ((dueDateHistory = state.getDueDateHistory()) != null && !dueDateHistory.isEmpty()) {
            for (DueDateRecord dueDateRecord : dueDateHistory) {
                activities.add(this.stateDueDateMapper.buildActivity((AbstractPage)content, state, dueDateRecord));
            }
        }
        return activities;
    }
}

