/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoc.command;

import com.atlassian.confluence.compat.api.service.accessmode.ReadOnlyAccessBlocked;
import com.atlassian.confluence.core.service.ServiceCommandValidator;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.comalatech.confluence.adhoc.command.AbstractAdhocWorkflowCommand;
import com.comalatech.confluence.workflow.Workflow;
import com.comalatech.confluence.workflow.WorkflowException;
import com.comalatech.confluence.workflow.WorkflowUserException;
import com.opensymphony.util.TextUtils;

@ReadOnlyAccessBlocked
public class SaveWorkflowMarkupCommand
extends AbstractAdhocWorkflowCommand {
    private String workflowMarkup;
    private Response response;

    @Override
    public void doWithWorkflow(Workflow currentWorkflow) throws WorkflowException {
        try {
            Workflow newWorkflow = this.parseWorkflowMacro();
            newWorkflow.validateWorkflow();
            if (!TextUtils.stringSet((String)newWorkflow.getName())) {
                newWorkflow.setName(currentWorkflow.getName());
            }
            if (this.getPage() != null) {
                newWorkflow.setName(this.workflowName);
                this.saveAsPageWorkflow(newWorkflow);
            } else if (this.isProduction()) {
                this.saveAsProductionWorkflow(newWorkflow, this.workflowName);
            } else {
                this.saveAsWorkflowTemplate(newWorkflow, this.workflowName);
            }
            this.response = new Response(true, this.getText("comalatech.awp.designer.sucess.markup"), newWorkflow.toMacro().toString());
        }
        catch (WorkflowException e) {
            this.response = new Response(false, e.getMessage());
        }
    }

    private void saveAsProductionWorkflow(Workflow workflow, String oldWorkflowName) {
        this.workflowContainerManager.saveProductionWorkflow(this.getSpaceKey(), workflow, oldWorkflowName);
    }

    private void saveAsWorkflowTemplate(Workflow workflow, String oldWorkflowName) {
        this.workflowContainerManager.saveWorkflowTemplate(this.getSpaceKey(), workflow, false, oldWorkflowName);
    }

    private void saveAsPageWorkflow(Workflow workflow) throws WorkflowException {
        this.adhocWorkflowManager.savePageWorkflow(this.getPage(), workflow, false);
    }

    private Workflow parseWorkflowMacro() throws WorkflowException {
        if (this.getPage() != null) {
            AbstractPage page = this.getPage();
        } else {
            Page page = new Page();
        }
        Workflow workflow = this.adhocWorkflowManager.parseWorkflowMarkup(this.workflowMarkup);
        if (TextUtils.stringSet((String)workflow.getErrorMessage())) {
            throw new WorkflowUserException("comalatech.awp.designer.error.markup", workflow.getErrorMessage());
        }
        return workflow;
    }

    @Override
    public void validateWorkflow(ServiceCommandValidator validator, Workflow workflow) {
    }

    @Override
    public Object getBean() {
        return this.response;
    }

    public void setWorkflowMarkup(String workflowMarkup) {
        this.workflowMarkup = workflowMarkup;
    }

    @Override
    public boolean requiresExistingTask() {
        return false;
    }

    @Override
    public boolean requiresExistingState() {
        return false;
    }

    public class Response {
        boolean ok;
        String message;
        String markup;

        public Response(boolean ok, String message) {
            this.ok = ok;
            this.message = message;
        }

        public Response(boolean ok, String message, String markup) {
            this.ok = ok;
            this.message = message;
            this.markup = markup;
        }

        public boolean isOk() {
            return this.ok;
        }

        public String getMarkup() {
            return this.markup;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

