/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.adhoc.action;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.util.HtmlUtil;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.WikiStyleRenderer;
import com.atlassian.renderer.v2.RenderMode;
import com.comalatech.confluence.adhoc.action.DesignerTab;
import com.comalatech.confluence.states.model.State;
import com.comalatech.confluence.tasks.model.Task;
import com.comalatech.confluence.tasks.model.TaskType;
import com.comalatech.confluence.util.PluginContainerManager;
import com.comalatech.confluence.workflow.ValueStore;
import com.comalatech.confluence.workflow.ValueStoreManager;
import com.comalatech.confluence.workflow.Workflow;
import com.comalatech.confluence.workflow.model.Trigger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class EditWorkflowHelper {
    private Workflow workflow;
    private String workflowMarkupBody;
    private State emptyState;
    private Task emptyTask;
    private Boolean adhoc;
    private Boolean canSaveTemplate;
    private Space space;
    private AbstractPage page;
    private DesignerTab currentTab;
    private WikiStyleRenderer wikiStyleRenderer;
    private ValueStoreManager valueStoreManager;
    private ValueStore valueStore;
    private boolean production;
    private boolean newWorkflow;

    public EditWorkflowHelper(Workflow workflow, DesignerTab tab, AbstractPage page, boolean canSaveTemplate) {
        this(workflow, tab);
        this.adhoc = true;
        this.page = page;
        this.canSaveTemplate = canSaveTemplate;
    }

    public EditWorkflowHelper(Workflow workflow, DesignerTab tab, AbstractPage page) {
        this(workflow, tab);
        this.adhoc = false;
        this.page = page;
        this.canSaveTemplate = false;
    }

    public EditWorkflowHelper(Workflow workflow, DesignerTab tab, Space space, boolean production, boolean newWorkflow) {
        this(workflow, tab);
        this.adhoc = false;
        this.canSaveTemplate = false;
        this.space = space;
        this.production = production;
        this.newWorkflow = newWorkflow;
    }

    private EditWorkflowHelper(Workflow workflow, DesignerTab tab) {
        this.workflow = workflow;
        this.currentTab = tab;
        PluginContainerManager.autowireComponent(this);
    }

    public String getEditAction(DesignerTab tab) {
        StringBuffer url = new StringBuffer();
        if (this.adhoc.booleanValue()) {
            url.append("/pages/pageworkflowbuilder.action?pageId=").append(this.page.getIdAsString()).append("&mode=builder");
        } else if (this.page != null) {
            url.append(this.page.getUrlPath());
        } else if (this.production) {
            String actionName = this.newWorkflow ? "createProductionWorkflow" : "editProductionWorkflow";
            url.append("/spaces/").append(actionName).append(".action?key=").append(this.getSpaceKey()).append("&workflowName=").append(HtmlUtil.urlEncode((String)this.workflow.getName()));
        } else if (this.space != null) {
            String actionName = this.newWorkflow ? "createSpaceWorkflow" : "editSpaceWorkflow";
            url.append("/spaces/").append(actionName).append(".action?key=").append(this.getSpaceKey()).append("&workflowName=").append(HtmlUtil.urlEncode((String)this.workflow.getName()));
        } else {
            url.append("/admin/editGlobalWorkflow.action?workflowName=").append(HtmlUtil.urlEncode((String)this.workflow.getName()));
        }
        if (url.indexOf("?") >= 0) {
            url.append("&");
        } else {
            url.append("?");
        }
        url.append("tab=").append(tab.getName());
        return url.toString();
    }

    public String getBuilderAction() {
        StringBuffer url = new StringBuffer();
        if (this.adhoc.booleanValue()) {
            url.append("/pages/pageworkflowbuilder.action?pageId=").append(this.page.getIdAsString());
        } else if (this.page != null) {
            url.append(this.page.getUrlPath());
        } else if (this.space != null) {
            url.append("/spaces/workflowBuilder.action?key=").append(this.getSpaceKey()).append("&workflowName=").append(HtmlUtil.urlEncode((String)this.workflow.getName()));
        } else {
            url.append("/admin/globalWorkflowBuilder.action?workflowName=").append(HtmlUtil.urlEncode((String)this.workflow.getName()));
        }
        return url.toString();
    }

    public String getMarkupEditAction() {
        return this.getEditAction(DesignerTab.MARKUP);
    }

    public String getSaveAction() {
        if (this.adhoc.booleanValue()) {
            return "savepageworkflow";
        }
        if (this.production) {
            return "saveproductionworkflow";
        }
        if (this.space != null) {
            return "savespaceworkflow";
        }
        return "saveglobalworkflow";
    }

    public String getCancelAction() {
        if (this.adhoc.booleanValue()) {
            return "/pages/viewpage.action?pageId=" + this.page.getId();
        }
        if (this.page != null) {
            return this.page.getUrlPath();
        }
        if (this.space != null) {
            return "/spaces/viewspaceworkflows.action?key=" + this.getSpaceKey();
        }
        return "/admin/viewglobalworkflows.action";
    }

    public String getSpaceKey() {
        if (this.space != null) {
            return this.space.getKey();
        }
        if (this.page != null) {
            return this.page.getSpaceKey();
        }
        return null;
    }

    public Workflow getWorkflow() {
        return this.workflow;
    }

    public String getWorkflowMarkupBody() {
        return this.workflowMarkupBody;
    }

    public void setWorkflowMarkupBody(String workflowMarkupBody) {
        this.workflowMarkupBody = workflowMarkupBody;
    }

    public List<TaskType> getTaskTypes() {
        return Arrays.asList(TaskType.values());
    }

    public State getEmptyState() {
        if (this.emptyState == null) {
            this.emptyState = new State(ConfluenceActionSupport.getTextStatic((String)"comalatech.awp.designer.newstate"), false);
        }
        return this.emptyState;
    }

    public Task getEmptyTask() {
        if (this.emptyTask == null) {
            this.emptyTask = new Task(ConfluenceActionSupport.getTextStatic((String)"comalatech.awp.designer.newtask"), TaskType.DEFAULT, null);
        }
        return this.emptyTask;
    }

    public String getWorkflowClass() {
        if (this.adhoc.booleanValue()) {
            return "adhoc";
        }
        if (this.page != null) {
            return "production";
        }
        return "template";
    }

    public boolean isEditable() {
        return this.adhoc != false || this.page == null;
    }

    public boolean isCurrentTab(DesignerTab tab) {
        return tab == this.currentTab;
    }

    public boolean isPageWorkflow() {
        return this.page != null;
    }

    public List<DesignerTab> getTabs() {
        ArrayList<DesignerTab> tabs = new ArrayList<DesignerTab>();
        tabs.add(DesignerTab.STATES);
        if (this.workflow.getExplicitTriggers().size() > 0) {
            tabs.add(DesignerTab.TRIGGERS);
        }
        if (this.isEditable()) {
            tabs.add(DesignerTab.MARKUP);
        }
        return tabs;
    }

    private ValueStore getValueStore() {
        if (this.valueStore == null) {
            Object valueStorePage = this.page == null ? new Page() : this.page;
            this.valueStore = this.valueStoreManager.createValueStore((AbstractPage)valueStorePage);
        }
        return this.valueStore;
    }

    public String renderCondition(Trigger trigger) {
        return this.render(trigger.conditionsToWiki(this.valueStore));
    }

    public String render(String body) {
        RenderContext context = this.getRendercontext();
        context.pushRenderMode(RenderMode.suppress((long)1L));
        return this.wikiStyleRenderer.convertWikiToXHtml(context, body);
    }

    private RenderContext getRendercontext() {
        PageContext context = this.page != null ? this.page.toPageContext() : (this.space != null ? new PageContext(this.space.getKey()) : new PageContext());
        return context;
    }

    public boolean isCanSaveAsWorkflowTemplate() {
        return this.canSaveTemplate;
    }

    public DesignerTab getCurrentTab() {
        return this.currentTab;
    }

    public void setWikiStyleRenderer(WikiStyleRenderer wikiStyleRenderer) {
        this.wikiStyleRenderer = wikiStyleRenderer;
    }

    public void setValueStoreManager(ValueStoreManager valueStoreManager) {
        this.valueStoreManager = valueStoreManager;
    }

    public boolean isProduction() {
        return this.production;
    }

    public void setProduction(boolean production) {
        this.production = production;
    }

    public boolean isNewWorkflow() {
        return this.newWorkflow;
    }

    public void setNewWorkflow(boolean newWorkflow) {
        this.newWorkflow = newWorkflow;
    }
}

