/*
 * Decompiled with CFR 0.152.
 */
package org.randombits.storage;

import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.randombits.storage.BasedStorage;
import org.randombits.storage.StringBasedStorage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesStorage
extends StringBasedStorage {
    private Properties properties;

    public PropertiesStorage(Properties props) {
        super(BasedStorage.BoxType.Virtual);
        this.properties = props;
    }

    @Override
    protected Set<String> baseNameSet() {
        if (this.properties != null) {
            HashSet<String> cProperties = new HashSet<String>();
            for (Object key : this.properties.keySet()) {
                cProperties.add((String)key);
            }
            return cProperties;
        }
        return null;
    }

    @Override
    protected String getBaseString(String name) {
        if (this.properties != null) {
            return this.properties.getProperty(name);
        }
        return null;
    }

    @Override
    protected void setBaseString(String name, String value) {
        this.checkReadOnly();
        if (this.properties != null) {
            this.properties.setProperty(name, value);
        }
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }
}

