/*
 * Decompiled with CFR 0.152.
 */
package org.randombits.facade;

import java.lang.reflect.Method;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MethodSignature {
    private String name;
    private Class<?>[] parameterTypes;

    public MethodSignature(Method method) {
        this.name = method.getName();
        this.parameterTypes = method.getParameterTypes();
    }

    public MethodSignature(String name, Class<?> ... parameterTypes) {
        this.name = name;
        this.parameterTypes = parameterTypes;
    }

    public String getName() {
        return this.name;
    }

    public Class<?> getParameterType(int i) {
        if (this.parameterTypes == null) {
            throw new ArrayIndexOutOfBoundsException(i);
        }
        return this.parameterTypes[i];
    }

    public Class<?>[] getParameterTypes() {
        Class[] copy = new Class[this.parameterTypes.length];
        System.arraycopy(this.parameterTypes, 0, copy, 0, this.parameterTypes.length);
        return copy;
    }

    public int getParameterCount() {
        return this.parameterTypes == null ? 0 : this.parameterTypes.length;
    }

    public Method findDeclaredMethod(Class<?> type) {
        try {
            return type.getDeclaredMethod(this.name, this.parameterTypes);
        }
        catch (SecurityException e) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return null;
    }

    public Method findMethod(Class<?> type) {
        try {
            return type.getMethod(this.name, this.parameterTypes);
        }
        catch (SecurityException e) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof MethodSignature) {
            MethodSignature ms = (MethodSignature)obj;
            return this.name.equals(ms.name) && Arrays.equals(this.parameterTypes, ms.parameterTypes);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode() + Arrays.hashCode(this.parameterTypes);
    }

    public String toString() {
        return "[name: " + this.name + "; parameterTypes: " + Arrays.toString(this.parameterTypes) + "]";
    }
}

