/*
 * Decompiled with CFR 0.152.
 */
package org.randombits.confluence.support;

import com.atlassian.confluence.core.ConfluenceEntityObject;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.SpaceContentEntityObject;
import com.atlassian.confluence.links.LinkManager;
import com.atlassian.confluence.links.OutgoingLink;
import com.atlassian.confluence.links.linktypes.AbstractContentEntityLink;
import com.atlassian.confluence.links.linktypes.AbstractPageLink;
import com.atlassian.confluence.links.linktypes.AttachmentLink;
import com.atlassian.confluence.links.linktypes.IncludePageMacroLink;
import com.atlassian.confluence.mail.Mail;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.PersonalInformation;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.links.Link;
import com.atlassian.renderer.links.LinkResolver;
import com.atlassian.renderer.links.UnpermittedLink;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.user.User;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class LinkAssistant {
    private LinkResolver linkResolver;
    private LinkManager linkManager;
    private PermissionManager permissionManager;
    private static LinkAssistant INSTANCE = new LinkAssistant();

    private LinkAssistant() {
        ContainerManager.autowireComponent((Object)this);
    }

    public static LinkAssistant getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new LinkAssistant();
        }
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLinksFromWiki(ContentEntityObject content, String wikiText) {
        if (content == null || content instanceof Mail) {
            return;
        }
        String originalContent = content.getContent();
        try {
            content.setContent(wikiText);
            List links = this.linkManager.extractLinksFromContent(content);
            for (Link link : links) {
                OutgoingLink outgoingLink = null;
                if (link instanceof UnpermittedLink) {
                    link = ((UnpermittedLink)link).getWrappedLink();
                }
                if (link instanceof AbstractPageLink) {
                    outgoingLink = ((AbstractPageLink)link).toOutgoingLink(content);
                }
                if (link instanceof IncludePageMacroLink) {
                    outgoingLink = ((IncludePageMacroLink)link).toOutgoingLink(content);
                }
                if (outgoingLink == null || outgoingLink.getUrlLink() == null || outgoingLink.getUrlLink().length() > 255) continue;
                this.linkManager.saveLink(outgoingLink);
            }
        }
        finally {
            content.setContent(originalContent);
        }
    }

    public ConfluenceEntityObject getLinkedEntity(PageContext context, String linkText) {
        Attachment content = null;
        Link link = this.linkResolver.createLink((RenderContext)context, linkText);
        if (link instanceof AttachmentLink) {
            content = ((AttachmentLink)link).getAttachment();
        } else if (link instanceof AbstractContentEntityLink) {
            content = ((AbstractContentEntityLink)link).getDestinationContent();
        }
        User user = AuthenticatedUserThreadLocal.getUser();
        if (!this.permissionManager.hasPermission(user, Permission.VIEW, (Object)content)) {
            return null;
        }
        return content;
    }

    public String getWikiLink(ConfluenceEntityObject entity, PageContext ctx) {
        StringBuffer buff = entity instanceof Attachment ? this.getAttachmentWikiLink((Attachment)entity, ctx) : (entity instanceof ContentEntityObject ? this.getContentEntityWikiLink((ContentEntityObject)entity, ctx) : new StringBuffer("$").append(entity.getId()));
        return buff.toString();
    }

    private StringBuffer getAttachmentWikiLink(Attachment attachment, PageContext ctx) {
        StringBuffer buff;
        if (!(attachment.getContent() instanceof AbstractPage)) {
            buff = new StringBuffer().append(ctx.getSiteRoot()).append(attachment.getUrlPath());
        } else {
            buff = ctx == null || !ctx.getEntity().equals((Object)attachment.getContent()) ? this.getContentEntityWikiLink(attachment.getContent(), ctx) : new StringBuffer();
            buff.append("^").append(attachment.getFileName());
        }
        return buff;
    }

    private StringBuffer getContentEntityWikiLink(ContentEntityObject content, PageContext ctx) {
        StringBuffer buff = new StringBuffer();
        if (content instanceof SpaceContentEntityObject) {
            SpaceContentEntityObject spaceContent = (SpaceContentEntityObject)content;
            if (!StringUtils.equals((String)spaceContent.getSpaceKey(), (String)ctx.getSpaceKey())) {
                buff.append(spaceContent.getSpaceKey()).append(":");
            }
            if (content instanceof Page) {
                Page page = (Page)content;
                buff.append(page.getTitle());
            } else if (content instanceof BlogPost) {
                BlogPost blogPost = (BlogPost)content;
                buff.append(blogPost.getDatePath()).append("/").append(blogPost.getTitle());
            } else {
                buff.append("$").append(content.getIdAsString());
            }
        } else if (content instanceof PersonalInformation) {
            buff.append("~").append(((PersonalInformation)content).getUsername());
        } else {
            buff.append("$").append(content.getIdAsString());
        }
        return buff;
    }

    public void setLinkManager(LinkManager linkManager) {
        this.linkManager = linkManager;
    }

    public void setLinkResolver(LinkResolver linkResolver) {
        this.linkResolver = linkResolver;
    }

    public void setPermissionManager(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }
}

