/*
 * Decompiled with CFR 0.152.
 */
package org.randombits.confluence.filtering.criteria.content;

import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.user.User;
import java.util.List;
import org.randombits.confluence.filtering.criteria.CriteriaException;
import org.randombits.confluence.filtering.criteria.Criterion;
import org.randombits.confluence.filtering.criteria.CriterionInterpreter;
import org.randombits.confluence.filtering.criteria.content.AbstractSpaceCriterion;

public class SpaceKeyCriterion
extends AbstractSpaceCriterion {
    public static final String ALL_SPACES = "@all";
    public static final String GLOBAL_SPACES = "@global";
    public static final String PERSONAL_SPACES = "@personal";
    public static final String FAVOURITE_SPACES = "@favourite";
    public static final String FAVORITE_SPACES = "@favorite";
    private String spaceKey;
    protected LabelManager labelManager;

    public SpaceKeyCriterion(String spaceKey) {
        this.spaceKey = spaceKey;
    }

    protected boolean matchesSpace(Space space) {
        if (ALL_SPACES.equals(this.spaceKey)) {
            return true;
        }
        if (GLOBAL_SPACES.equals(this.spaceKey)) {
            return space.isGlobal();
        }
        if (PERSONAL_SPACES.equals(this.spaceKey)) {
            return space.isPersonal();
        }
        if (FAVOURITE_SPACES.equals(this.spaceKey) || FAVORITE_SPACES.equals(this.spaceKey)) {
            User user = AuthenticatedUserThreadLocal.getUser();
            if (user != null) {
                List favouriteSpaces = this.labelManager.getFavouriteSpaces(user.getName());
                return favouriteSpaces.contains(space);
            }
            return false;
        }
        return this.spaceKey.equalsIgnoreCase(space.getKey());
    }

    public String getSpaceKey() {
        return this.spaceKey;
    }

    public void setLabelManager(LabelManager labelManager) {
        this.labelManager = labelManager;
    }

    public String toString() {
        return "{space key: " + this.spaceKey + "}";
    }

    public static class Interpreter
    implements CriterionInterpreter {
        public static final String SELF_SPACE = "@self";
        private Space self;

        public Interpreter() {
            this(null);
        }

        public Interpreter(Space self) {
            this.self = self;
        }

        public Space getSelf() {
            return this.self;
        }

        public Criterion createCriterion(String value) throws CriteriaException {
            if (SELF_SPACE.equals(value)) {
                if (this.self != null) {
                    value = this.self.getKey();
                } else {
                    throw new CriteriaException("@self cannot be used in the current context.");
                }
            }
            return new SpaceKeyCriterion(value);
        }
    }
}

