/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.workflow.model.document.activity;

import com.comalatech.workflow.model.document.activity.DocumentActivityQueryFilter;
import com.comalatech.workflow.model.document.activity.SortingOrder;
import io.swagger.annotations.ApiModel;

@ApiModel(description="Query object to search for document activities")
public class DocumentActivityQuery {
    public static final int DEFAULT_RESULTS_LIMIT = 100;
    private DocumentActivityQueryFilter filters;
    private SortingOrder order = SortingOrder.desc;
    private int offset = 0;
    private int limit = 100;

    public DocumentActivityQuery() {
    }

    public SortingOrder getOrder() {
        return this.order;
    }

    public void setOrder(SortingOrder order) {
        this.order = order;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public DocumentActivityQueryFilter getFilters() {
        return this.filters;
    }

    public void setFilters(DocumentActivityQueryFilter filters) {
        this.filters = filters;
    }

    protected DocumentActivityQuery(DocumentActivityQueryBuilder<?, ?> b) {
        this.filters = b.filters;
        this.order = b.order;
        this.offset = b.offset;
        this.limit = b.limit;
    }

    public static DocumentActivityQueryBuilder<?, ?> builder() {
        return new DocumentActivityQueryBuilderImpl();
    }

    public DocumentActivityQueryBuilder<?, ?> toBuilder() {
        return new DocumentActivityQueryBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DocumentActivityQuery)) {
            return false;
        }
        DocumentActivityQuery other = (DocumentActivityQuery)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getOffset() != other.getOffset()) {
            return false;
        }
        if (this.getLimit() != other.getLimit()) {
            return false;
        }
        DocumentActivityQueryFilter this$filters = this.getFilters();
        DocumentActivityQueryFilter other$filters = other.getFilters();
        if (this$filters == null ? other$filters != null : !((Object)this$filters).equals(other$filters)) {
            return false;
        }
        SortingOrder this$order = this.getOrder();
        SortingOrder other$order = other.getOrder();
        return !(this$order == null ? other$order != null : !((Object)((Object)this$order)).equals((Object)other$order));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DocumentActivityQuery;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getOffset();
        result = result * 59 + this.getLimit();
        DocumentActivityQueryFilter $filters = this.getFilters();
        result = result * 59 + ($filters == null ? 43 : ((Object)$filters).hashCode());
        SortingOrder $order = this.getOrder();
        result = result * 59 + ($order == null ? 43 : ((Object)((Object)$order)).hashCode());
        return result;
    }

    public String toString() {
        return "DocumentActivityQuery(filters=" + this.getFilters() + ", order=" + this.getOrder() + ", offset=" + this.getOffset() + ", limit=" + this.getLimit() + ")";
    }

    private static final class DocumentActivityQueryBuilderImpl
    extends DocumentActivityQueryBuilder<DocumentActivityQuery, DocumentActivityQueryBuilderImpl> {
        private DocumentActivityQueryBuilderImpl() {
        }

        @Override
        protected DocumentActivityQueryBuilderImpl self() {
            return this;
        }

        @Override
        public DocumentActivityQuery build() {
            return new DocumentActivityQuery(this);
        }
    }

    public static abstract class DocumentActivityQueryBuilder<C extends DocumentActivityQuery, B extends DocumentActivityQueryBuilder<C, B>> {
        private DocumentActivityQueryFilter filters;
        private SortingOrder order;
        private int offset;
        private int limit;

        protected B $fillValuesFrom(C instance) {
            DocumentActivityQueryBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(DocumentActivityQuery instance, DocumentActivityQueryBuilder<?, ?> b) {
            b.filters(instance.filters);
            b.order(instance.order);
            b.offset(instance.offset);
            b.limit(instance.limit);
        }

        public B filters(DocumentActivityQueryFilter filters) {
            this.filters = filters;
            return this.self();
        }

        public B order(SortingOrder order) {
            this.order = order;
            return this.self();
        }

        public B offset(int offset) {
            this.offset = offset;
            return this.self();
        }

        public B limit(int limit) {
            this.limit = limit;
            return this.self();
        }

        protected abstract B self();

        public abstract C build();

        public String toString() {
            return "DocumentActivityQuery.DocumentActivityQueryBuilder(filters=" + this.filters + ", order=" + this.order + ", offset=" + this.offset + ", limit=" + this.limit + ")";
        }
    }
}

