/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowreports.service;

import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.SimplePageRequest;
import com.atlassian.confluence.api.model.search.SearchOptions;
import com.atlassian.confluence.api.model.search.SearchPageResponse;
import com.atlassian.confluence.api.model.search.SearchResult;
import com.atlassian.confluence.api.service.search.CQLSearchService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.comalatech.confluence.util.cql.CQLExpansionParser;
import com.comalatech.confluence.workflow.documentReport.DocumentReportBuilder;
import com.comalatech.confluence.workflow.restv2.model.documentreport.DocumentReport;
import com.comalatech.confluence.workflowreports.model.presenter.cql.CqlFilterParameter;
import com.comalatech.confluence.workflowreports.service.DocumentReportService;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="approvalsReportService")
public class ApprovalsReportService
implements DocumentReportService {
    public static final String BASIC_CQL_PARAMETER = CqlFilterParameter.HAS_WORKFLOW.getCqlField() + " = true AND " + CqlFilterParameter.HAS_APPROVAL.getCqlField() + " = true ";
    private static final List<String> EXPAND = Arrays.asList("content.metadata.properties.comalaworkflows", "content.history.lastUpdated", "content.metadata.properties.comalaworkflowspendingapprovers", "content.metadata.properties.comalaworkflowsfinishedapprovers", "content.metadata.properties.comalaworkflowslastfinalversionapprovers", "content.metadata.properties.comalaworflowscurrentmodelversion", "content.metadata.properties.comalaworkflowsapprovals", "content.space");
    private final CQLSearchService cqlSearchService;
    private final DocumentReportBuilder documentReportBuilder;

    public ApprovalsReportService(@ComponentImport CQLSearchService cqlSearchService, @Qualifier(value="documentReportBuilder") DocumentReportBuilder documentReportBuilder) {
        this.cqlSearchService = cqlSearchService;
        this.documentReportBuilder = documentReportBuilder;
    }

    @Override
    public DocumentReport generateDocumentReport(String cql, int start, int limit) {
        Object cqlSearch = BASIC_CQL_PARAMETER;
        if (StringUtils.isNotBlank((CharSequence)cql)) {
            cqlSearch = (String)cqlSearch + "AND " + cql;
        }
        SearchPageResponse search = this.cqlSearchService.search((String)cqlSearch, SearchOptions.buildDefault(), (PageRequest)new SimplePageRequest(start, limit), CQLExpansionParser.parse(StringUtils.join(EXPAND, (String)",")));
        DocumentReport documentReport = this.documentReportBuilder.build((SearchPageResponse<SearchResult>)search);
        this.filterCQLReportData(documentReport, (String)cqlSearch);
        return documentReport;
    }

    private void filterCQLReportData(DocumentReport documentReport, String cqlSearch) {
        if (documentReport.getWorkflowsReportList().isEmpty()) {
            return;
        }
        boolean hasReviewFilter = cqlSearch.contains(CqlFilterParameter.PENDING_APPROVAL_NAME.getCqlField()) || cqlSearch.contains(CqlFilterParameter.APPROVED_APPROVAL_NAME.getCqlField()) || cqlSearch.contains(CqlFilterParameter.REJECTED_APPROVAL_NAME.getCqlField());
        boolean hasAssigneeFilter = cqlSearch.contains(CqlFilterParameter.PENDING_APPROVAL_USER.getCqlField());
        if (!hasReviewFilter && !hasAssigneeFilter) {
            return;
        }
        documentReport.getWorkflowsReportList().forEach(workflowsReportData -> workflowsReportData.getApprovals().removeIf(userApprovalContent -> hasReviewFilter && !cqlSearch.contains(userApprovalContent.name) && !cqlSearch.contains(userApprovalContent.status) || hasAssigneeFilter && userApprovalContent.pendingApprovers.stream().noneMatch(pendingApprover -> cqlSearch.contains(pendingApprover.userKeyProperty)) && userApprovalContent.completed.stream().noneMatch(completedApprover -> cqlSearch.contains(completedApprover.user.userKeyProperty))));
    }
}

