/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowreports.service;

import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.SimplePageRequest;
import com.atlassian.confluence.api.model.search.SearchOptions;
import com.atlassian.confluence.api.model.search.SearchPageResponse;
import com.atlassian.confluence.api.model.search.SearchResult;
import com.atlassian.confluence.api.service.search.CQLSearchService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.comalatech.confluence.util.cql.CQLExpansionParser;
import com.comalatech.confluence.workflow.documentReport.DocumentReportBuilder;
import com.comalatech.confluence.workflow.restv2.model.documentreport.DocumentReport;
import com.comalatech.confluence.workflowreports.model.presenter.cql.CqlFilterParameter;
import com.comalatech.confluence.workflowreports.service.DocumentReportService;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="actionsReportService")
public class ActionsReportService
implements DocumentReportService {
    public static final String BASIC_CQL_PARAMETER = CqlFilterParameter.HAS_WORKFLOW.getCqlField() + " = true ";
    private static final List<String> EXPAND = Arrays.asList("content.metadata.properties.comalaworkflows", "content.metadata.properties.comalaworkflowstasks", "content.metadata.properties.comalaworkflowsapprovals", "content.metadata.properties.comalaworkflowspendingapprovers");
    private final CQLSearchService cqlSearchService;
    private final DocumentReportBuilder actionsReportBuilder;

    public ActionsReportService(@ComponentImport CQLSearchService cqlSearchService, @Qualifier(value="actionsReportBuilder") DocumentReportBuilder actionsReportBuilder) {
        this.cqlSearchService = cqlSearchService;
        this.actionsReportBuilder = actionsReportBuilder;
    }

    @Override
    public DocumentReport generateDocumentReport(String cql, int start, int limit) {
        Object cqlSearch = BASIC_CQL_PARAMETER;
        if (StringUtils.isNotBlank((CharSequence)cql)) {
            cqlSearch = (String)cqlSearch + "AND " + cql;
        }
        SearchPageResponse search = this.cqlSearchService.search((String)cqlSearch, SearchOptions.buildDefault(), (PageRequest)new SimplePageRequest(start, limit), CQLExpansionParser.parse(StringUtils.join(EXPAND, (String)",")));
        return this.actionsReportBuilder.build((SearchPageResponse<SearchResult>)search);
    }
}

