/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowreports.model;

import com.atlassian.confluence.pages.AbstractPage;
import com.comalatech.confluence.states.model.PageState;
import com.comalatech.confluence.states.model.State;
import com.comalatech.confluence.states.model.StatesContainer;
import com.comalatech.confluence.tasks.model.PageTask;
import com.comalatech.confluence.util.FancyDateFormatter;
import com.comalatech.confluence.workflow.model.DecoratedApprovalCheck;
import com.comalatech.confluence.workflowreports.model.WorkflorReportEntryDashboardComparator;
import com.comalatech.workflow.model.Assignment;
import java.util.Comparator;
import java.util.Date;

public class WorkflowReportEntry {
    private AbstractPage page;
    private PageState state;
    private PageTask task;
    private DecoratedApprovalCheck approval;
    private boolean isFinalState;
    private boolean hasFinalState;
    public static final Comparator<WorkflowReportEntry> DASHBOARD_COMPARATOR = new WorkflorReportEntryDashboardComparator();

    public WorkflowReportEntry(AbstractPage page, PageState state, StatesContainer statesContainer) {
        this.page = page;
        this.state = state;
        if (statesContainer != null) {
            State workflowState = statesContainer.getState(state);
            this.isFinalState = workflowState != null && workflowState.isFinalState();
            this.hasFinalState = statesContainer.getFinalState() != null;
        }
    }

    public WorkflowReportEntry(AbstractPage page, DecoratedApprovalCheck approval, PageState pageState) {
        this.page = page;
        this.approval = approval;
        this.state = pageState;
    }

    public WorkflowReportEntry(AbstractPage page, PageState state, PageTask task, DecoratedApprovalCheck approval, StatesContainer statesContainer) {
        this(page, state, statesContainer);
        this.task = task;
        this.approval = approval;
    }

    public AbstractPage getPage() {
        return this.page;
    }

    public PageState getState() {
        return this.state;
    }

    public DecoratedApprovalCheck getApproval() {
        return this.approval;
    }

    public Date getDate() {
        Assignment assignment = this.getAssignment();
        if (assignment != null) {
            return assignment.getDate();
        }
        return null;
    }

    public Assignment getAssignment() {
        if (this.task != null) {
            return this.task.getLastAssignment();
        }
        if (this.approval != null) {
            return this.approval.getApprovalCheck().getLastAssignment();
        }
        if (this.state != null) {
            return this.getState().getLastAssignment();
        }
        return null;
    }

    public PageTask getTask() {
        return this.task;
    }

    public String getFriendlyDueDate() {
        if (this.task != null && this.task.getDueDate() != null) {
            return FancyDateFormatter.decorateDateTimePretty(this.task.getDueDate(), false);
        }
        return null;
    }

    public String getFriendlyModifiedDate() {
        return FancyDateFormatter.decorateDateTimePretty(this.page.getLastModificationDate(), false);
    }

    public String getFriendlyStateChangedDate() {
        return FancyDateFormatter.decorateDateTimePretty(this.state.getDate(), false);
    }

    public boolean isFinalState() {
        return this.isFinalState;
    }

    public boolean isHasFinalState() {
        return this.hasFinalState;
    }

    public String toString() {
        return "WorkflowReportEntry{page=" + this.page + ", state=" + this.state + ", approval=" + this.approval + ", task=" + this.task + "}";
    }
}

