/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowreports.manager.actions;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.util.GeneralUtil;
import com.comalatech.confluence.documentActions.services.model.search.ActionTypes;
import com.comalatech.confluence.timers.TimerUtils;
import com.comalatech.confluence.workflow.WorkflowException;
import com.comalatech.confluence.workflow.restv2.model.documentreport.DocumentReport;
import com.comalatech.confluence.workflow.restv2.model.documentreport.WorkflowsReportData;
import com.comalatech.confluence.workflowreports.manager.actions.WorkflowActionsReportManager;
import com.comalatech.confluence.workflowreports.model.ExportWorkflowActionsReportEntry;
import com.comalatech.confluence.workflowreports.model.WorkflowActionsReportOptions;
import com.comalatech.confluence.workflowreports.service.ActionsReportService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ExportActionsReport
implements WorkflowActionsReportManager {
    private static final Logger log = LoggerFactory.getLogger(ExportActionsReport.class);
    private static final int LIMIT = 20;
    private static final String REPORT_CQL_FILTER = "awphasworkflow=true";
    private static final String CQL_QUERY_PARAM = "cqlQuery";
    private final PageManager pageManager;
    private final ActionsReportService actionsReportService;

    public ExportActionsReport(PageManager pageManager, ActionsReportService actionsReportService) {
        this.pageManager = pageManager;
        this.actionsReportService = actionsReportService;
    }

    @Override
    public List<ExportWorkflowActionsReportEntry> createReport(WorkflowActionsReportOptions options, Map<String, Object> parameters) {
        int start = 0;
        int limit = StringUtils.isNotBlank((CharSequence)options.getNumberOfItemsPerPage()) ? Integer.parseInt(options.getNumberOfItemsPerPage()) : 20;
        try {
            DocumentReport report = this.actionsReportService.generateDocumentReport(this.buildCqlQuery(options, parameters), start, limit);
            return this.buildReport(report);
        }
        catch (WorkflowException e) {
            log.error(e.getMessage());
            return new ArrayList<ExportWorkflowActionsReportEntry>();
        }
    }

    private String buildCqlQuery(WorkflowActionsReportOptions options, Map<String, Object> parameters) throws WorkflowException {
        if (StringUtils.isBlank((CharSequence)options.getAssignee())) {
            throw new WorkflowException("parameter assignee is required");
        }
        StringJoiner stateJoiner = new StringJoiner("\",\"", "state IN (\"", "\")");
        options.getStates().forEach(stateJoiner::add);
        StringJoiner workflowJoiner = new StringJoiner("\",\"", "workflowname IN (\"", "\")");
        options.getWorkflows().forEach(workflowJoiner::add);
        Object cqlQuery = REPORT_CQL_FILTER;
        cqlQuery = StringUtils.isNotBlank((CharSequence)((String)parameters.get(CQL_QUERY_PARAM))) ? (String)cqlQuery + " AND " + parameters.get(CQL_QUERY_PARAM) : cqlQuery;
        cqlQuery = !options.getStates().isEmpty() ? (String)cqlQuery + " AND " + stateJoiner : cqlQuery;
        cqlQuery = !options.getWorkflows().isEmpty() ? (String)cqlQuery + " AND " + workflowJoiner : cqlQuery;
        cqlQuery = (String)cqlQuery + " AND (" + ActionTypes.APPROVAL.getCqlField() + " IN (\"" + options.getAssignee() + "\") OR " + ActionTypes.TASK.getCqlField() + " IN (\"" + options.getAssignee() + "\"))";
        return cqlQuery;
    }

    private List<ExportWorkflowActionsReportEntry> buildReport(DocumentReport results) throws WorkflowException {
        ArrayList<ExportWorkflowActionsReportEntry> report = new ArrayList<ExportWorkflowActionsReportEntry>();
        for (WorkflowsReportData result : results.getWorkflowsReportList()) {
            report.addAll(this.buildEntry(result));
        }
        return report;
    }

    private List<ExportWorkflowActionsReportEntry> buildEntry(WorkflowsReportData result) throws WorkflowException {
        AbstractPage page = this.pageManager.getAbstractPage(result.getContentData().getId());
        if (page == null) {
            throw new WorkflowException("There was an error while creating the report.");
        }
        if (result.getActions() != null && !result.getActions().isEmpty()) {
            return result.getActions().stream().map(action -> {
                Object description = "";
                String duedate = "";
                if (action.getType().equals((Object)ActionTypes.APPROVAL)) {
                    if (action.getHasCondition().booleanValue()) {
                        description = "(conditional)";
                    }
                } else {
                    if (StringUtils.isNotBlank((CharSequence)action.getDetails())) {
                        description = "(" + action.getDetails() + ")";
                    }
                    if (action.getDueDate() != null) {
                        duedate = TimerUtils.parseDateWithConfluenceDateFormat(new Date(action.getDueDate()));
                    }
                }
                return ExportWorkflowActionsReportEntry.builder().action(action.getType().name()).name(action.getName()).description((String)description).assignedBy(action.getAssignerDetails().getUsername()).assignmentDate(action.getAssignmentDate() != 0L ? TimerUtils.parseDateWithConfluenceDateFormat(new Date(action.getAssignmentDate())) : "").dueDate(duedate).pageTitle(page.getTitle()).pageLink(this.getBaseUrl() + page.getUrlPath()).spaceName(page.getSpace().getName()).build();
            }).collect(Collectors.toList());
        }
        return Collections.EMPTY_LIST;
    }

    private String getBaseUrl() {
        String domainName = GeneralUtil.getGlobalSettings().getBaseUrl();
        if (StringUtils.isNotBlank((CharSequence)domainName) && domainName.endsWith("/")) {
            domainName = domainName.substring(0, domainName.length() - 1);
        }
        return domainName;
    }
}

