/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowreports.macro.parameter.model;

import com.comalatech.confluence.workflowreports.macro.parameter.StringReportParameterValue;
import com.comalatech.confluence.workflowreports.macro.parameter.model.ReportParameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public enum StateReportParameters {
    SPACE("space", "@self"),
    MAX_ITEMS_PER_PAGE("maxItems", "20"),
    COLUMNS_TO_SHOW("columns", "title,state,changed,updated by,updated"),
    SORT("sort", "title"),
    SORT_ORDER("sortOrder", "descending"),
    PARENT_PAGE("parent"),
    ANCESTOR_PAGE("ancestor"),
    LABEL("label"),
    STATE("state"),
    WORKFLOW("workflow"),
    CQL_FILTER("cqlFilter");

    private final String key;
    private String defaultValue;

    private StateReportParameters(String key) {
        this.key = key;
    }

    private StateReportParameters(String key, String defaultValue) {
        this.key = key;
        this.defaultValue = defaultValue;
    }

    public static Optional<StateReportParameters> fromString(String text) {
        return Arrays.stream(StateReportParameters.values()).filter(reportFilter -> reportFilter.key.equalsIgnoreCase(text)).findFirst();
    }

    public static List<ReportParameter> getFiltersFrom(Set<Map.Entry<?, ?>> macroParameterSet) {
        ArrayList<ReportParameter> stateReportFilters = new ArrayList<ReportParameter>();
        for (Map.Entry<?, ?> macroParam : macroParameterSet) {
            StateReportParameters filter = StateReportParameters.fromString(macroParam.getKey().toString()).orElse(null);
            if (Objects.isNull((Object)filter)) continue;
            String value = macroParam.getValue() == null ? null : macroParam.getValue().toString().trim();
            stateReportFilters.add(new ReportParameter(filter.key, new StringReportParameterValue(value, filter.defaultValue)));
        }
        StateReportParameters.addMandatoryParameters(stateReportFilters);
        return stateReportFilters;
    }

    private static void addMandatoryParameters(List<ReportParameter> stateReportFilters) {
        StateReportParameters.fillReportFilter(stateReportFilters, SPACE.getKey(), SPACE.getDefaultValue());
        StateReportParameters.fillReportFilter(stateReportFilters, MAX_ITEMS_PER_PAGE.getKey(), MAX_ITEMS_PER_PAGE.getDefaultValue());
        StateReportParameters.fillReportFilter(stateReportFilters, COLUMNS_TO_SHOW.getKey(), COLUMNS_TO_SHOW.getDefaultValue());
        StateReportParameters.fillReportFilter(stateReportFilters, SORT.getKey(), SORT.getDefaultValue());
        StateReportParameters.fillReportFilter(stateReportFilters, SORT_ORDER.getKey(), SORT_ORDER.getDefaultValue());
    }

    private static void fillReportFilter(List<ReportParameter> stateReportFilters, String key, String defaultValue) {
        boolean existParameter = stateReportFilters.stream().anyMatch(param -> param.getKey().equals(key));
        if (!existParameter) {
            stateReportFilters.add(new ReportParameter(key, new StringReportParameterValue(null, defaultValue)));
        }
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getKey() {
        return this.key;
    }
}

