/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowreports.macro.parameter;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.macro.MacroException;
import com.comalatech.confluence.license.WorkflowsFeatureManager;
import com.comalatech.confluence.workflow.macros.templates.MacroParameters;
import com.comalatech.confluence.workflowreports.macro.parameter.mappers.ColumnsParameterMapper;
import com.comalatech.confluence.workflowreports.macro.parameter.mappers.DefaultValuesParameterMapper;
import com.comalatech.confluence.workflowreports.macro.parameter.mappers.FieldListParameterMapper;
import com.comalatech.confluence.workflowreports.macro.parameter.mappers.PageParameterMapper;
import com.comalatech.confluence.workflowreports.macro.parameter.mappers.ParameterMapper;
import com.comalatech.confluence.workflowreports.macro.parameter.mappers.SpaceParameterMapper;
import com.comalatech.confluence.workflowreports.macro.parameter.mappers.StringListParameterMapper;
import com.comalatech.confluence.workflowreports.macro.parameter.mappers.UsernameParameterMapper;
import com.comalatech.confluence.workflowreports.macro.parameter.model.ReportParameter;
import com.comalatech.confluence.workflowreports.macro.parameter.model.TasksReportParameters;
import com.comalatech.confluence.workflowreports.macro.parameter.validators.ItemsPerPageParameterValidator;
import com.comalatech.confluence.workflowreports.macro.parameter.validators.PageParameterValidator;
import com.comalatech.confluence.workflowreports.macro.parameter.validators.ParameterValidator;
import com.comalatech.confluence.workflowreports.model.WorkflowTasksReportOptions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class TasksMacroParameters
extends MacroParameters {
    private final WorkflowTasksReportOptions options;
    private final WorkflowsFeatureManager workflowsFeatureManager;
    private final UserAccessor userAccessor;
    private final PageManager pageManager;

    public TasksMacroParameters(Map parameters, RenderContext renderContext, WorkflowsFeatureManager workflowsFeatureManager, UserAccessor userAccessor, PageManager pageManager) throws MacroException {
        super(parameters, renderContext);
        this.workflowsFeatureManager = workflowsFeatureManager;
        this.userAccessor = userAccessor;
        this.pageManager = pageManager;
        AbstractPage page = null;
        if (renderContext instanceof PageContext && this.getAbstractPage() != null) {
            page = this.getAbstractPage().getLatestVersion();
        }
        List<ReportParameter> reportParameters = TasksReportParameters.getFiltersFrom(parameters.entrySet());
        this.applyParameterMappers(reportParameters, page);
        this.applyParametersValidators(reportParameters);
        this.options = new WorkflowTasksReportOptions(reportParameters);
    }

    private void applyParametersValidators(List<ReportParameter> reportParameters) throws MacroException {
        ArrayList<ParameterValidator> validators = new ArrayList<ParameterValidator>(Arrays.asList(new ItemsPerPageParameterValidator(1, 500, this.workflowsFeatureManager.getPluginKey()), new PageParameterValidator(this.workflowsFeatureManager.getPluginKey())));
        for (ReportParameter parameter : reportParameters) {
            for (ParameterValidator validator : validators) {
                validator.validate(parameter);
            }
        }
    }

    private void applyParameterMappers(List<ReportParameter> reportParameters, AbstractPage page) {
        ArrayList<ParameterMapper> mappers = new ArrayList<ParameterMapper>(Arrays.asList(new DefaultValuesParameterMapper(), new SpaceParameterMapper(page), new ColumnsParameterMapper(), new PageParameterMapper(this.pageManager, page), new FieldListParameterMapper(), new StringListParameterMapper(), new UsernameParameterMapper(this.userAccessor)));
        for (ReportParameter param : reportParameters) {
            mappers.forEach(mapper -> mapper.map(param));
        }
    }

    public WorkflowTasksReportOptions getWorkflowReportOptions() {
        return this.options;
    }
}

