/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowreports.macro;

import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.macro.MacroException;
import com.comalatech.confluence.workflowreports.macro.BaseWorkflowReportMacro;
import com.comalatech.confluence.workflowreports.macro.parameter.ApprovalsMacroParameters;
import com.comalatech.confluence.workflowreports.manager.approvals.WorkflowApprovalsReportManager;
import com.comalatech.confluence.workflowreports.model.ExportWorkflowApprovalReportEntry;
import com.comalatech.confluence.workflowreports.model.WorkflowApprovalsReportOptions;
import com.comalatech.confluence.workflowreports.model.WorkflowReportFilters;
import com.comalatech.confluence.workflowreports.model.presenter.WorkflowApprovalsReportFiltersJsonPresenter;
import com.comalatech.confluence.workflowreports.model.presenter.WorkflowApprovalsReportOptionsCqlPresenter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class WorkflowApprovalsReportMacro
extends BaseWorkflowReportMacro {
    private static final String APPROVALS_TEMPLATE = "/templates/reports/macros/approvals-report-macro.vm";
    private static final String EXPORT_APPROVALS_TEMPLATE = "/templates/reports/macros/export-approvals-report-macro.vm";
    protected ApprovalsMacroParameters options;
    private WorkflowApprovalsReportManager workflowApprovalsReportManager;

    @Override
    public String execute(Map parameters, RenderContext renderContext) throws MacroException {
        this.options = new ApprovalsMacroParameters(parameters, renderContext, this.workflowsFeatureManager, this.userAccessor, this.pageManager);
        WorkflowApprovalsReportOptions approvalsReportOptions = this.options.getWorkflowApprovalsReportOptions();
        WorkflowReportFilters approvalsReportFilters = this.buildReportFilters(this.options.getWorkflowApprovalsReportOptions());
        Map contextMap = MacroUtils.defaultVelocityContext();
        contextMap.putAll(new WorkflowApprovalsReportOptionsCqlPresenter(approvalsReportOptions, this.objectMapper).present());
        contextMap.putAll(new WorkflowApprovalsReportFiltersJsonPresenter(approvalsReportFilters, this.objectMapper).present());
        contextMap.put("currentSpaceKey", this.getCurrentSpaceKey(renderContext));
        contextMap.put("workflowLicenseMessageHtml", this.getWorkflowLicenseMessageHtml());
        contextMap.put("isPreview", "preview".equals(renderContext.getOutputType()));
        if (Boolean.parseBoolean((String)renderContext.getParam((Object)"send-email"))) {
            renderContext.setOutputType("email");
        }
        switch (renderContext.getOutputType()) {
            case "preview": 
            case "display": {
                return this.renderTemplate(contextMap, APPROVALS_TEMPLATE);
            }
            case "word": 
            case "pdf": 
            case "html_export": 
            case "email": {
                return this.renderExportApprovalsReportTemplate(approvalsReportOptions, contextMap);
            }
        }
        return null;
    }

    private String renderExportApprovalsReportTemplate(WorkflowApprovalsReportOptions options, Map<String, Object> contextMap) throws MacroException {
        HashMap<String, Object> renderMap = new HashMap<String, Object>();
        List columnsToShow = Stream.of(options.getColumnsToShow().split(",", -1)).map(column -> column.replace(" ", "")).collect(Collectors.toList());
        List<ExportWorkflowApprovalReportEntry> reportEntries = this.workflowApprovalsReportManager.createReport(options, contextMap);
        renderMap.put("exportReport", reportEntries);
        renderMap.put("columnsToShow", columnsToShow);
        return this.renderTemplate(renderMap, EXPORT_APPROVALS_TEMPLATE);
    }

    public void setWorkflowApprovalsReportManager(WorkflowApprovalsReportManager workflowApprovalsReportManager) {
        this.workflowApprovalsReportManager = workflowApprovalsReportManager;
    }
}

