/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowreports;

import com.atlassian.confluence.core.TimeZone;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUserPreferences;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.user.User;
import com.comalatech.confluence.timers.TimerUtils;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ReportDateFormatter {
    public static final String PRECISE_DATE_TIME_PATTERN = "yyyy-MM-dd HH:mm:ss XXX";
    public static final String EXPIRY_DATE_TIME_PATTERN = "dd MMM, yyyy hh:mm aa";
    private final LocaleManager localeManager;
    private final UserAccessor userAccessor;

    public ReportDateFormatter(LocaleManager localeManager, UserAccessor userAccessor) {
        this.localeManager = localeManager;
        this.userAccessor = userAccessor;
    }

    public ReportDateFormatter(LocaleManager localeManager) {
        this.localeManager = localeManager;
        this.userAccessor = null;
    }

    public String formatServerTime(Date date) {
        DateFormat format = this.createServerFormat("h:mm a");
        return this.formatWith(format, date);
    }

    public String formatServerDateTimePrecise(Date date) {
        DateFormat format = this.createServerFormat(PRECISE_DATE_TIME_PATTERN);
        return this.formatWith(format, date);
    }

    public String formatExpiryDateTime(Date date) {
        DateFormat format = this.createServerFormat(EXPIRY_DATE_TIME_PATTERN);
        return this.formatWith(format, date);
    }

    public String formatLocalizedDateTime(Date date) {
        DateFormat format = this.createServerUserFormatWithTimeZone(EXPIRY_DATE_TIME_PATTERN);
        return this.formatWith(format, date);
    }

    private DateFormat createServerFormat(String pattern) {
        SimpleDateFormat format = new SimpleDateFormat(pattern, TimerUtils.getLocale(this.localeManager));
        format.setLenient(false);
        format.setTimeZone(TimeZone.getDefault().getWrappedTimeZone());
        return format;
    }

    private DateFormat createServerUserFormatWithTimeZone(String pattern) {
        SimpleDateFormat format = new SimpleDateFormat(pattern, TimerUtils.getLocale(this.localeManager));
        format.setLenient(false);
        format.setTimeZone(this.getUserTimeZone().getWrappedTimeZone());
        return format;
    }

    private String formatWith(DateFormat format, Date date) {
        try {
            return format.format(date);
        }
        catch (Exception e) {
            return "";
        }
    }

    private TimeZone getUserTimeZone() {
        ConfluenceUserPreferences preferences = this.userAccessor.getConfluenceUserPreferences((User)AuthenticatedUserThreadLocal.get());
        return preferences.getTimeZone();
    }
}

