/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflowcontainer.action;

import com.atlassian.confluence.api.service.accessmode.ReadOnlyAccessBlocked;
import com.atlassian.core.util.PairType;
import com.atlassian.xwork.ParameterSafe;
import com.comalatech.confluence.adhoc.notification.SlackNotificationConfigManager;
import com.comalatech.confluence.adhoc.notification.WorkflowNotificationConfigManager;
import com.comalatech.confluence.adhoc.notification.model.NotificationType;
import com.comalatech.confluence.adhoc.notification.model.SpaceNotifications;
import com.comalatech.confluence.workflowcontainer.action.SpaceConfigurationAction;
import java.io.Serializable;
import java.util.List;
import javax.servlet.http.HttpSession;

public class SpaceNotificationsConfigAction
extends SpaceConfigurationAction {
    private static final String CONFIG_SUCCESS_KEY = "comalatech.awp.space.workflows.notification.config.success";
    private WorkflowNotificationConfigManager workflowNotificationConfigManager;
    private SlackNotificationConfigManager slackNotificationConfigManager;
    private String spaceNotificationsModetaskAssigned;
    private String spaceNotificationsModetaskPageWatcher;
    private String spaceNotificationsModeapprovalAssigned;
    private String spaceNotificationsModestateExpired;
    private String spaceNotificationsModereadConfirmation;
    private String spaceNotificationsModeslackNotification;

    @Override
    public String execute() throws Exception {
        super.execute();
        HttpSession session = this.getCurrentRequest().getSession();
        if (session.getAttribute(CONFIG_SUCCESS_KEY) != null && session.getAttribute(CONFIG_SUCCESS_KEY).equals("success")) {
            this.addActionMessage(this.getText(CONFIG_SUCCESS_KEY));
            session.removeAttribute(CONFIG_SUCCESS_KEY);
        }
        return "success";
    }

    @ReadOnlyAccessBlocked
    public String saveSpaceNotificationsMode() {
        this.workflowNotificationConfigManager.setSpaceNotificationsMode(new SpaceNotifications(NotificationType.TASK_ASSIGNMENT, SpaceNotifications.Mode.valueOf(this.spaceNotificationsModetaskAssigned)), this.getSpaceKey());
        this.workflowNotificationConfigManager.setSpaceNotificationsMode(new SpaceNotifications(NotificationType.TASK_PAGEWATCHER, SpaceNotifications.Mode.valueOf(this.spaceNotificationsModetaskPageWatcher)), this.getSpaceKey());
        this.workflowNotificationConfigManager.setSpaceNotificationsMode(new SpaceNotifications(NotificationType.APPROVAL_ASSIGNMENT, SpaceNotifications.Mode.valueOf(this.spaceNotificationsModeapprovalAssigned)), this.getSpaceKey());
        this.workflowNotificationConfigManager.setSpaceNotificationsMode(new SpaceNotifications(NotificationType.STATE_EXPIRED, SpaceNotifications.Mode.valueOf(this.spaceNotificationsModestateExpired)), this.getSpaceKey());
        this.workflowNotificationConfigManager.setSpaceNotificationsMode(new SpaceNotifications(NotificationType.READ_CONFIRMATION, SpaceNotifications.Mode.valueOf(this.spaceNotificationsModereadConfirmation)), this.getSpaceKey());
        if (this.isSlackAppEnabled()) {
            this.workflowNotificationConfigManager.setSpaceNotificationsMode(new SpaceNotifications(NotificationType.SLACK_NOTIFICATION, SpaceNotifications.Mode.valueOf(this.spaceNotificationsModeslackNotification)), this.getSpaceKey());
        }
        this.getCurrentRequest().getSession().setAttribute(CONFIG_SUCCESS_KEY, (Object)"success");
        return "success";
    }

    public List<String> getNotificationTypeList() {
        return List.of(NotificationType.TASK_ASSIGNMENT.getName(), NotificationType.TASK_PAGEWATCHER.getName(), NotificationType.APPROVAL_ASSIGNMENT.getName(), NotificationType.STATE_EXPIRED.getName(), NotificationType.READ_CONFIRMATION.getName(), NotificationType.SLACK_NOTIFICATION.getName());
    }

    public List<PairType> getSpaceNotificationsModeList(String type) {
        String notificationConfig = this.workflowNotificationConfigManager.isNotificationEnabled(NotificationType.getByName(type)) ? this.getText("com.comalatech.notification.config.enabled") : this.getText("com.comalatech.notification.config.disabled");
        return List.of(new PairType((Serializable)((Object)SpaceNotifications.Mode.DEFAULT), (Serializable)((Object)this.getText(SpaceNotifications.Mode.DEFAULT.getKey(), new String[]{notificationConfig}))), new PairType((Serializable)((Object)SpaceNotifications.Mode.ENABLED), (Serializable)((Object)this.getText(SpaceNotifications.Mode.ENABLED.getKey()))), new PairType((Serializable)((Object)SpaceNotifications.Mode.DISABLED), (Serializable)((Object)this.getText(SpaceNotifications.Mode.DISABLED.getKey()))));
    }

    public String getSpaceNotificationsMode(String type) {
        SpaceNotifications.Mode mode = this.workflowNotificationConfigManager.getSpaceNotificationsMode(this.getSpaceKey(), NotificationType.getByName(type));
        return mode.name();
    }

    public boolean isSlackAppEnabled() {
        return this.slackNotificationConfigManager.isNextupPluginEnabled();
    }

    public boolean isSlackAppDisabled() {
        return !this.isSlackAppEnabled();
    }

    public String getDocoUrl() {
        return "https://apps.appf.re/cdmdc/doc/spacenotifications/CH5uq5";
    }

    @ParameterSafe
    public void setSpaceNotificationsModetaskAssigned(String spaceNotificationsModetaskAssigned) {
        this.spaceNotificationsModetaskAssigned = spaceNotificationsModetaskAssigned;
    }

    @ParameterSafe
    public void setSpaceNotificationsModetaskPageWatcher(String spaceNotificationsModetaskPageWatcher) {
        this.spaceNotificationsModetaskPageWatcher = spaceNotificationsModetaskPageWatcher;
    }

    @ParameterSafe
    public void setSpaceNotificationsModeapprovalAssigned(String spaceNotificationsModeapprovalAssigned) {
        this.spaceNotificationsModeapprovalAssigned = spaceNotificationsModeapprovalAssigned;
    }

    @ParameterSafe
    public void setSpaceNotificationsModestateExpired(String spaceNotificationsModestateExpired) {
        this.spaceNotificationsModestateExpired = spaceNotificationsModestateExpired;
    }

    @ParameterSafe
    public void setSpaceNotificationsModereadConfirmation(String spaceNotificationsModereadConfirmation) {
        this.spaceNotificationsModereadConfirmation = spaceNotificationsModereadConfirmation;
    }

    @ParameterSafe
    public void setSpaceNotificationsModeslackNotification(String spaceNotificationsModeslackNotification) {
        this.spaceNotificationsModeslackNotification = spaceNotificationsModeslackNotification;
    }

    public void setWorkflowNotificationConfigManager(WorkflowNotificationConfigManager workflowNotificationConfigManager) {
        this.workflowNotificationConfigManager = workflowNotificationConfigManager;
    }

    public void setSlackNotificationConfigManager(SlackNotificationConfigManager slackNotificationConfigManager) {
        this.slackNotificationConfigManager = slackNotificationConfigManager;
    }
}

