/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.tasks.handler;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.comalatech.confluence.workflow.tasks.handler.QueuedJobHandler;
import com.comalatech.confluence.workflow.tasks.model.QueuedJobModel;
import com.comalatech.confluence.workflow.user.WorkflowAuthenticatedUserThreadLocal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractQueuedJobHandler<T extends QueuedJobModel>
implements QueuedJobHandler<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractQueuedJobHandler.class);
    protected UserAccessor userAccessor;

    protected ConfluenceUser getUser(String userName) {
        return this.userAccessor.getUserByName(userName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(T model) {
        ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
        try {
            if (model.isInExpiryJob().booleanValue()) {
                WorkflowAuthenticatedUserThreadLocal.setInExpiryJob(true);
            }
            AuthenticatedUserThreadLocal.set((ConfluenceUser)this.getUser(model.getUserName()));
            this.handle(model);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            AuthenticatedUserThreadLocal.set((ConfluenceUser)currentUser);
        }
    }

    protected abstract void handle(T var1);
}

