/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.supportconsole.mappers;

import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.comalatech.confluence.adhoc.notification.WorkflowNotificationConfigManager;
import com.comalatech.confluence.adhoc.notification.model.NotificationType;
import com.comalatech.confluence.workflow.WorkflowAdvancedConfigurationManager;
import com.comalatech.confluence.workflow.WorkflowConfigurationManager;
import com.comalatech.confluence.workflow.esignatures.configuration.ESignaturesConfigurationManager;
import com.comalatech.confluence.workflow.model.WorkflowConfiguration;
import com.comalatech.confluence.workflow.stats.WorkflowStatisticsManager;
import com.comalatech.confluence.workflow.supportconsole.mappers.contract.SupportConsoleReportDataPopulator;
import com.comalatech.confluence.workflow.supportconsole.model.GlobalConfigurationData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component(value="globalConfigDataMapper")
public class GlobalConfigDataPopulator
implements SupportConsoleReportDataPopulator<GlobalConfigurationData, Space> {
    private final List<String> comalaApps;
    private final PluginAccessor pluginAccessor;
    private final ESignaturesConfigurationManager eSignaturesConfigurationManager;
    private final DarkFeatureManager darkFeatureManager;
    private final WorkflowNotificationConfigManager notificationConfigManager;
    private final WorkflowAdvancedConfigurationManager advancedConfigurationManager;
    private final WorkflowConfigurationManager configurationManager;
    private final WorkflowStatisticsManager statisticsManager;

    public GlobalConfigDataPopulator(@ComponentImport PluginAccessor pluginAccessor, ESignaturesConfigurationManager eSignaturesConfigurationManager, @ComponentImport DarkFeatureManager darkFeatureManager, WorkflowNotificationConfigManager workflowNotificationConfigManager, WorkflowAdvancedConfigurationManager workflowAdvancedConfigurationManager, WorkflowConfigurationManager configurationManager, WorkflowStatisticsManager statisticsManager) {
        this.pluginAccessor = pluginAccessor;
        this.eSignaturesConfigurationManager = eSignaturesConfigurationManager;
        this.darkFeatureManager = darkFeatureManager;
        this.notificationConfigManager = workflowNotificationConfigManager;
        this.advancedConfigurationManager = workflowAdvancedConfigurationManager;
        this.configurationManager = configurationManager;
        this.statisticsManager = statisticsManager;
        this.comalaApps = new ArrayList<String>();
        this.comalaApps.add("com.comalatech.workflow");
        this.comalaApps.add("com.comalatech.cloud.approvals");
        this.comalaApps.add("com.comalatech.workflow.approvals");
        this.comalaApps.add("com.comalatech.publishing");
        this.comalaApps.add("com.comalatech.remotepublishing");
        this.comalaApps.add("com.comalatech.adhoccanvas");
        this.comalaApps.add("com.keinoby.confluence.plugins.share-attachments");
        this.comalaApps.add("com.comalatech.checklists");
        this.comalaApps.add("org.andya.confluence.plugins.metadata");
        this.comalaApps.add("com.keinoby.confluence.plugins.leaflet");
        this.comalaApps.add("com.keinoby.confluence.plugins.yoikee-creator");
    }

    @Override
    public GlobalConfigurationData populateForTarget(Space space) {
        List<Plugin> availableComalaPlugins = this.getAvailableComalaPlugins();
        WorkflowConfiguration configuration = this.configurationManager.getConfiguration();
        String spaceKey = space == null ? null : space.getKey();
        return GlobalConfigurationData.builder().confluenceVersion(GeneralUtil.getVersionNumber()).disabledModules(this.getComalatechDisabledModules(availableComalaPlugins)).comalatechAppsVersions(this.getAppsVersion(availableComalaPlugins)).emailAnyAddress(String.valueOf(this.configurationManager.isEmailAnyone())).pageApprovalRestricted(String.valueOf(configuration.getPageApprovalsRestricted())).pageApprovalRestrictedList(Arrays.asList(configuration.getPageApprovalsSpaceKeys())).spaceWorkflowRestricted(String.valueOf(configuration.getSpaceWorkflowRestricted())).spaceWorkflowRestrictedList(Arrays.asList(configuration.getSpaceWorkflowSpaceKeys())).workflowImporterGroup(this.configurationManager.getImportersGroup()).onBoarding(String.valueOf(this.configurationManager.isOnboardEnabled())).onBoardingTopBar(String.valueOf(this.configurationManager.isOnboardTopBarEnabled())).workflowTranslator(String.valueOf(this.configurationManager.isWorkflowTranslatorEnabled())).enabledDarkFeatures(this.getEnabledComalaDarkFeatures()).maxEvents(String.valueOf(Math.max(configuration.getMaxEvents(), 20))).timeThreshold(String.valueOf(Math.max(configuration.getThresholdInSeconds(), 20))).eSignature(this.eSignaturesConfigurationManager.getESignaturesCredentials()).slackNotifications(String.valueOf(this.notificationConfigManager.isNotificationEnabled(NotificationType.SLACK_NOTIFICATION))).taskAssigneeNotifications(String.valueOf(this.notificationConfigManager.isNotificationEnabled(NotificationType.TASK_ASSIGNMENT))).taskPageWatchersNotifications(String.valueOf(this.notificationConfigManager.isNotificationEnabled(NotificationType.TASK_PAGEWATCHER))).approvalAssigneeNotifications(String.valueOf(this.notificationConfigManager.isNotificationEnabled(NotificationType.APPROVAL_ASSIGNMENT))).stateExpiredNotification(String.valueOf(this.notificationConfigManager.isNotificationEnabled(NotificationType.STATE_EXPIRED))).readConfirmationNotification(String.valueOf(this.notificationConfigManager.isNotificationEnabled(NotificationType.READ_CONFIRMATION))).maxHandledUsers(String.valueOf(this.advancedConfigurationManager.getMaxHandledUsers())).maxAllowedApproversToShow(String.valueOf(this.advancedConfigurationManager.getMaxAllowedApproversToShow())).expirationJobBatchSize(String.valueOf(this.advancedConfigurationManager.getExpirationJobBatchSize())).populateProperties(String.valueOf(this.advancedConfigurationManager.getDataExtractorBatchSize())).userSearch(String.valueOf(this.advancedConfigurationManager.getUserSearchMinCharacters())).spaceWorkflowsCacheSize(String.valueOf(this.advancedConfigurationManager.getCacheProductionWorkflows())).globalWorkflowsCacheSize(String.valueOf(this.advancedConfigurationManager.getCacheGlobalWorkflows())).globalWorkflowsNamesCacheSize(String.valueOf(this.advancedConfigurationManager.getCacheGlobalWorkflowNames())).activityDraftVisibility(String.valueOf((Object)this.configurationManager.getHistoryVisibility())).defaultTaskMode(String.valueOf((Object)this.configurationManager.getTasksMode(spaceKey, false))).stateTasksBehaviour(String.valueOf((Object)this.configurationManager.getStateTasksMode(spaceKey, false))).approvalComment(String.valueOf((Object)this.configurationManager.getRequireApprovalComment(false))).pageUpdateResetApproval(String.valueOf((Object)this.configurationManager.getResetApprovalStatus(spaceKey, false))).publishedViewMacroTransform(String.valueOf((Object)this.configurationManager.getMacroTransformEnable())).documentActionsDashboard(String.valueOf(this.configurationManager.isDocumentActionsDashboardEnabled())).impersonatorsUserGroup(String.valueOf(this.configurationManager.getAdminImpersonatorsGroup())).actionsMenu(String.valueOf(this.configurationManager.getActionMenuEnabled())).build();
    }

    private List<Plugin> getAvailableComalaPlugins() {
        return this.comalaApps.stream().map(arg_0 -> ((PluginAccessor)this.pluginAccessor).getPlugin(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private Properties getAppsVersion(List<Plugin> availablePlugins) {
        return availablePlugins.stream().map(plugin -> {
            Properties properties = new Properties();
            properties.setProperty(plugin.getName(), plugin.getPluginInformation().getVersion());
            return properties;
        }).reduce(new Properties(), (properties, properties2) -> {
            properties.putAll((Map<?, ?>)properties2);
            return properties;
        });
    }

    private Properties getComalatechDisabledModules(List<Plugin> availablePlugins) {
        return availablePlugins.stream().map(plugin -> {
            Properties properties = new Properties();
            String disabledModules = plugin.getModuleDescriptors().stream().filter(moduleDescriptor -> !moduleDescriptor.isEnabled()).map(ModuleDescriptor::getCompleteKey).filter(disabledModule -> disabledModule.contains("comalatech")).collect(Collectors.joining(","));
            properties.setProperty(plugin.getName(), disabledModules);
            return properties;
        }).reduce(new Properties(), (properties, properties2) -> {
            properties.putAll((Map<?, ?>)properties2);
            return properties;
        });
    }

    private List<String> getEnabledComalaDarkFeatures() {
        return this.darkFeatureManager.getFeaturesEnabledForAllUsers().getFeatureKeySet().stream().filter(key -> key.contains("comalatech")).collect(Collectors.toList());
    }
}

