/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.spaceworkflows;

import com.atlassian.confluence.api.model.content.Space;
import com.comalatech.confluence.workflow.Workflow;
import com.comalatech.confluence.workflow.WorkflowService;
import com.comalatech.confluence.workflow.model.SpaceWorkflowInstance;
import com.comalatech.confluence.workflow.spaceworkflows.SpaceWorkflowsService;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DefaultSpaceWorkflowsService
implements SpaceWorkflowsService {
    private static final Logger log = LoggerFactory.getLogger(DefaultSpaceWorkflowsService.class);
    private final WorkflowService workflowService;

    public DefaultSpaceWorkflowsService(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }

    @Override
    public List<SpaceWorkflowInstance> getSpaceWorkflowsBySpace(Space space) {
        ArrayList<SpaceWorkflowInstance> result = new ArrayList<SpaceWorkflowInstance>();
        List<com.comalatech.workflow.model.Workflow> spaceWorkflows = this.workflowService.getWorkflows(space.getKey());
        if (spaceWorkflows.isEmpty()) {
            log.debug("No space workflows found for space {}", (Object)space.getKey());
            return result;
        }
        for (com.comalatech.workflow.model.Workflow workflow : spaceWorkflows) {
            Workflow spaceWorkflow = (Workflow)workflow;
            SpaceWorkflowInstance spaceWorkflowInstance = SpaceWorkflowInstance.builder().spaceName(space.getName()).spaceKey(space.getKey()).workflowName(spaceWorkflow.getName()).markup(spaceWorkflow.getWorkflowMarkup()).isActive(spaceWorkflow.isActive()).workflowType(spaceWorkflow.getType()).labels(spaceWorkflow.getLabels()).isInvertLabels(spaceWorkflow.isInvertLabels()).build();
            result.add(spaceWorkflowInstance);
        }
        return result;
    }
}

