/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.restv2.resources;

import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.SimplePageRequest;
import com.atlassian.confluence.api.model.search.SearchOptions;
import com.atlassian.confluence.api.model.search.SearchPageResponse;
import com.atlassian.confluence.api.model.search.SearchResult;
import com.atlassian.confluence.api.service.search.CQLSearchService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.comalatech.confluence.util.PluginContainerManager;
import com.comalatech.confluence.util.cql.CQLExpansionParser;
import com.comalatech.confluence.workflow.documentReport.DocumentReportBuilder;
import com.comalatech.confluence.workflow.restv2.model.documentreport.DocumentReport;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@Path(value="/report")
public class WorkflowsReportResource {
    private static final Logger log = LoggerFactory.getLogger(WorkflowsReportResource.class);
    private final CQLSearchService cqlSearchService;
    private final DocumentReportBuilder documentReportBuilder;

    @Inject
    public WorkflowsReportResource() {
        this.cqlSearchService = PluginContainerManager.getComponent(CQLSearchService.class);
        this.documentReportBuilder = PluginContainerManager.getComponent("documentReportBuilder", DocumentReportBuilder.class);
    }

    @Autowired
    public WorkflowsReportResource(@ComponentImport CQLSearchService cqlSearchService, @Qualifier(value="documentReportBuilder") DocumentReportBuilder documentReportBuilder) {
        this.cqlSearchService = cqlSearchService;
        this.documentReportBuilder = documentReportBuilder;
    }

    @Path(value="/search")
    @Produces(value={"application/json"})
    @GET
    @ApiResponses(value={@ApiResponse(code=500, message="Exception when trying to retrieve data for DocumentReport")})
    public Response search(@QueryParam(value="cql") String cql, @QueryParam(value="expand") String expand, @QueryParam(value="start") int start, @QueryParam(value="limit") int limit) {
        try {
            SearchPageResponse search = this.cqlSearchService.search(cql, SearchOptions.buildDefault(), (PageRequest)new SimplePageRequest(start, limit), CQLExpansionParser.parse(expand));
            DocumentReport documentReport = this.documentReportBuilder.build((SearchPageResponse<SearchResult>)search);
            return Response.ok((Object)documentReport).build();
        }
        catch (Exception e) {
            log.error("Unable to retrieve data for DocumentReport CQL: {} , expand: {} , start: {} ,limit: {} ", new Object[]{cql, expand, start, limit, e});
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)StringEscapeUtils.escapeHtml4((String)e.getMessage())).build();
        }
    }
}

