/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.restv2.model;

import com.atlassian.confluence.user.ConfluenceUser;
import com.comalatech.confluence.workflow.restv2.model.RestEvent;
import java.util.Set;
import javax.xml.bind.annotation.adapters.XmlAdapter;

public class RestEventAdapter
extends XmlAdapter<AdaptedRestEvent, RestEvent> {
    public RestEvent unmarshal(AdaptedRestEvent adaptedRestEvent) throws Exception {
        RestEvent event = this.createEventInstance(adaptedRestEvent.type);
        if (event == null) {
            throw new IllegalArgumentException("Unknown event type: " + adaptedRestEvent.type);
        }
        event.name = adaptedRestEvent.name;
        if (event instanceof RestEvent.RestStateEvent) {
            RestEvent.RestStateEvent stateEvent = (RestEvent.RestStateEvent)event;
            stateEvent.state = adaptedRestEvent.state;
            stateEvent.initial = adaptedRestEvent.initial;
            stateEvent.sourceEvent = adaptedRestEvent.sourceEvent;
        } else if (event instanceof RestEvent.RestApprovalEvent) {
            RestEvent.RestApprovalEvent approvalEvent = (RestEvent.RestApprovalEvent)event;
            approvalEvent.content = adaptedRestEvent.content;
            approvalEvent.approval = adaptedRestEvent.approval;
            approvalEvent.partial = adaptedRestEvent.partial;
        } else if (event instanceof RestEvent.RestLabelEvent) {
            RestEvent.RestLabelEvent labelEvent = (RestEvent.RestLabelEvent)event;
            labelEvent.label = adaptedRestEvent.label;
        } else if (event instanceof RestEvent.RestWorkflowPageParameterEvent) {
            RestEvent.RestWorkflowPageParameterEvent parameterEvent = (RestEvent.RestWorkflowPageParameterEvent)event;
            parameterEvent.parameter = adaptedRestEvent.parameter;
        } else if (event instanceof RestEvent.RestCustomEvent) {
            RestEvent.RestCustomEvent customEvent = (RestEvent.RestCustomEvent)event;
            customEvent.success = adaptedRestEvent.success;
        } else if (event instanceof RestEvent.RestReadAckEvent) {
            RestEvent.RestReadAckEvent readAckEvent = (RestEvent.RestReadAckEvent)event;
            readAckEvent.content = adaptedRestEvent.content;
            readAckEvent.ackTimestamp = adaptedRestEvent.ackTimestamp;
            readAckEvent.users = adaptedRestEvent.users;
        } else if (event instanceof RestEvent.RestTaskEvent) {
            RestEvent.RestTaskEvent taskEvent = (RestEvent.RestTaskEvent)event;
            taskEvent.task = adaptedRestEvent.task;
            taskEvent.state = adaptedRestEvent.state;
        }
        return event;
    }

    public AdaptedRestEvent marshal(RestEvent event) {
        AdaptedRestEvent adaptedRestEvent = new AdaptedRestEvent();
        adaptedRestEvent.type = this.getTypeName(event);
        adaptedRestEvent.name = event.name;
        if (event instanceof RestEvent.RestStateEvent) {
            RestEvent.RestStateEvent stateEvent = (RestEvent.RestStateEvent)event;
            adaptedRestEvent.state = stateEvent.state;
            adaptedRestEvent.initial = stateEvent.initial;
            adaptedRestEvent.sourceEvent = stateEvent.sourceEvent;
        } else if (event instanceof RestEvent.RestApprovalEvent) {
            RestEvent.RestApprovalEvent approvalEvent = (RestEvent.RestApprovalEvent)event;
            adaptedRestEvent.content = approvalEvent.content;
            adaptedRestEvent.approval = approvalEvent.approval;
            adaptedRestEvent.partial = approvalEvent.partial;
        } else if (event instanceof RestEvent.RestLabelEvent) {
            RestEvent.RestLabelEvent labelEvent = (RestEvent.RestLabelEvent)event;
            adaptedRestEvent.label = labelEvent.label;
        } else if (event instanceof RestEvent.RestWorkflowPageParameterEvent) {
            RestEvent.RestWorkflowPageParameterEvent parameterEvent = (RestEvent.RestWorkflowPageParameterEvent)event;
            adaptedRestEvent.parameter = parameterEvent.parameter;
        } else if (event instanceof RestEvent.RestCustomEvent) {
            RestEvent.RestCustomEvent customEvent = (RestEvent.RestCustomEvent)event;
            adaptedRestEvent.success = customEvent.success;
        } else if (event instanceof RestEvent.RestReadAckEvent) {
            RestEvent.RestReadAckEvent readAckEvent = (RestEvent.RestReadAckEvent)event;
            adaptedRestEvent.content = readAckEvent.content;
            adaptedRestEvent.ackTimestamp = readAckEvent.ackTimestamp;
            adaptedRestEvent.users = readAckEvent.users;
        } else if (event instanceof RestEvent.RestTaskEvent) {
            RestEvent.RestTaskEvent taskEvent = (RestEvent.RestTaskEvent)event;
            adaptedRestEvent.task = taskEvent.task;
            adaptedRestEvent.state = taskEvent.state;
        }
        return adaptedRestEvent;
    }

    private RestEvent createEventInstance(String type) throws Exception {
        switch (type) {
            case "state": {
                return new RestEvent.RestStateEvent();
            }
            case "content": {
                return new RestEvent.RestContentEvent();
            }
            case "task": {
                return new RestEvent.RestTaskEvent();
            }
            case "approval": {
                return new RestEvent.RestApprovalEvent();
            }
            case "label": {
                return new RestEvent.RestLabelEvent();
            }
            case "parameter": {
                return new RestEvent.RestWorkflowPageParameterEvent();
            }
            case "custom": {
                return new RestEvent.RestCustomEvent();
            }
            case "readack": {
                return new RestEvent.RestReadAckEvent();
            }
            case "attachment": {
                return new RestEvent.RestAttachmentEvent();
            }
        }
        return null;
    }

    private String getTypeName(RestEvent event) {
        if (event instanceof RestEvent.RestStateEvent) {
            return "state";
        }
        if (event instanceof RestEvent.RestContentEvent) {
            return "content";
        }
        if (event instanceof RestEvent.RestTaskEvent) {
            return "task";
        }
        if (event instanceof RestEvent.RestApprovalEvent) {
            return "approval";
        }
        if (event instanceof RestEvent.RestLabelEvent) {
            return "label";
        }
        if (event instanceof RestEvent.RestWorkflowPageParameterEvent) {
            return "parameter";
        }
        if (event instanceof RestEvent.RestCustomEvent) {
            return "custom";
        }
        if (event instanceof RestEvent.RestReadAckEvent) {
            return "readack";
        }
        if (event instanceof RestEvent.RestAttachmentEvent) {
            return "attachment";
        }
        return null;
    }

    public static class AdaptedRestEvent {
        public String type;
        public String name;
        public Boolean initial;
        public Boolean partial;
        public String state;
        public String sourceEvent;
        public String content;
        public String approval;
        public String label;
        public String parameter;
        public Boolean success;
        public String task;
        public Long ackTimestamp;
        public Set<ConfluenceUser> users;
    }
}

