/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.model;

import com.atlassian.confluence.search.v2.ContentSearch;
import com.atlassian.confluence.search.v2.ISearch;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.confluence.search.v2.SearchSort;
import com.atlassian.confluence.search.v2.query.FieldExistsQuery;
import com.atlassian.confluence.util.GeneralUtil;
import com.comalatech.confluence.workflow.model.WorkflowsSearch;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowsSearchConfluence9CompatibilityBuilder {
    private static final Logger log = LoggerFactory.getLogger(WorkflowsSearchConfluence9CompatibilityBuilder.class);

    public static ISearch getContentSearch(SearchQuery query, SearchSort sort, int startOffset, int limit) {
        if (GeneralUtil.getVersionNumber().startsWith(String.valueOf(9))) {
            return WorkflowsSearchConfluence9CompatibilityBuilder._getContentSearch(query, sort, startOffset, limit);
        }
        return new WorkflowsSearch(query, sort, startOffset, limit);
    }

    private static ContentSearch _getContentSearch(SearchQuery query, SearchSort sort, int startOffset, int limit) {
        try {
            Class<?> contentSearchClass = Class.forName("com.atlassian.confluence.search.v2.ContentSearch");
            Method builderMethod = contentSearchClass.getMethod("builder", new Class[0]);
            Object builderInstance = builderMethod.invoke(null, new Object[0]);
            Class<?> builderClass = builderInstance.getClass();
            Class<?> indexClass = Class.forName("com.atlassian.confluence.search.v2.Index");
            Field contentIndexField = indexClass.getField("CONTENT");
            Object contentIndex = contentIndexField.get(null);
            Method indicesMethod = builderClass.getMethod("indices", List.class);
            builderInstance = indicesMethod.invoke(builderInstance, Collections.singletonList(contentIndex));
            Method queryMethod = builderClass.getMethod("query", SearchQuery.class);
            builderInstance = queryMethod.invoke(builderInstance, query);
            Method limitMethod = builderClass.getMethod("limit", Integer.TYPE);
            builderInstance = limitMethod.invoke(builderInstance, limit);
            Method sortMethod = builderClass.getMethod("sort", SearchSort.class);
            builderInstance = sortMethod.invoke(builderInstance, sort);
            Method startOffsetMethod = builderClass.getMethod("startOffset", Integer.TYPE);
            builderInstance = startOffsetMethod.invoke(builderInstance, startOffset);
            Method buildMethod = builderClass.getMethod("build", new Class[0]);
            Object contentSearchInstance = buildMethod.invoke(builderInstance, new Object[0]);
            return (ContentSearch)contentSearchInstance;
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchFieldException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            log.error("Error detected while building ContentSearch object through compatibility layer", (Throwable)e);
            return null;
        }
    }

    public static SearchQuery getFieldExistsQuery(String fieldName) {
        if (GeneralUtil.getVersionNumber().startsWith(String.valueOf(9))) {
            return WorkflowsSearchConfluence9CompatibilityBuilder._getFieldExistsQuery(fieldName);
        }
        return new FieldExistsQuery(fieldName);
    }

    private static SearchQuery _getFieldExistsQuery(String fieldName) {
        try {
            Class<?> searchQueryClass = Class.forName("com.atlassian.confluence.search.v2.query.FieldExistsQuery");
            Class[] constructorTypes = new Class[]{String.class};
            Constructor<?> searchQueryClassConstructor = searchQueryClass.getConstructor(constructorTypes);
            Object[] constructorArgs = new Object[]{fieldName};
            Object newSearchQueryClassInstance = searchQueryClassConstructor.newInstance(constructorArgs);
            return (SearchQuery)newSearchQueryClassInstance;
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            log.error("Error detected while building SearchQuery object through compatibility layer", (Throwable)e);
            return null;
        }
    }
}

