/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow.model;

import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.user.Entity;
import com.atlassian.user.Group;
import com.comalatech.confluence.workflow.ValueStore;
import com.comalatech.confluence.workflow.WorkflowException;
import com.comalatech.confluence.workflow.model.AbstractUserGroupApproverCondition;
import com.comalatech.confluence.workflow.model.AllowedAssignerGroupCondition;
import com.comalatech.confluence.workflow.model.AllowedAssignerUserCondition;
import com.comalatech.confluence.workflow.model.ApprovalCheck;
import com.comalatech.confluence.workflow.model.ApprovalStatus;
import com.comalatech.confluence.workflow.model.ApproverCondition;
import com.comalatech.confluence.workflow.model.Condition;
import com.comalatech.confluence.workflow.model.ExcludeCondition;
import com.comalatech.confluence.workflow.model.GroupCondition;
import com.comalatech.confluence.workflow.model.Selector;
import com.comalatech.confluence.workflow.model.UserCondition;
import com.comalatech.confluence.workflow.model.WorkflowElement;
import com.comalatech.confluence.workflowcontainer.model.Macroable;
import com.comalatech.confluence.workflowcontainer.model.SerializableMacro;
import com.comalatech.workflow.model.SignatureType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Approval
extends WorkflowElement
implements Serializable,
Comparable,
Macroable {
    public static final int DEFAULT_WEIGHT = 40;
    public static final char[] INVALID_CHARACTERS = new char[]{':', ';', '?', '&', '[', ']', '(', ')', '#', '^', '*', '@', '!', '<', '>'};
    public static final List<Approval> EMPTY_LIST = new ArrayList<Approval>();
    private String name;
    private int weight;
    private boolean finalApproval;
    private boolean showInPages;
    private boolean showInBlogs;
    private Condition adminCondition;
    private String body;
    private Selector selector;
    private List<Approval> preceedingApprovals = new ArrayList<Approval>();
    private List<Approval> dependingApprovals = new ArrayList<Approval>();
    private Label label;
    private SignatureType credentials;
    private boolean assignable;
    private String minRequiredApprovers = "0";
    private boolean rememberAssignees;
    private String approveLabel;
    private String rejectLabel;
    private String description;
    private boolean roles;

    public Approval(String name, int weight, List conditions, boolean finalApproval, boolean showInPages, boolean showInBlogs, int credentials) {
        super(conditions);
        this.name = name;
        this.weight = weight;
        this.finalApproval = finalApproval;
        this.showInPages = showInPages;
        this.showInBlogs = showInBlogs;
        this.credentials = SignatureType.lookupById(credentials);
    }

    public Approval(String name) {
        this(name, 10, null, false, true, true, SignatureType.NONE.getId());
    }

    public Approval(String name, boolean finalApproval, List conditions) {
        this(name, 10, conditions, finalApproval, true, true, SignatureType.NONE.getId());
    }

    public void addDependingApproval(Approval approval) {
        this.dependingApprovals.add(approval);
    }

    public void addPreceedingApproval(Approval approval) {
        this.preceedingApprovals.add(approval);
    }

    public List<Approval> getDependingApprovals() {
        return this.dependingApprovals;
    }

    public List<Approval> getPrecedingApprovals() {
        return this.preceedingApprovals;
    }

    public String getPreceedingApprovalNames() {
        StringBuffer sb = new StringBuffer();
        String separator = "";
        for (Approval approval : this.preceedingApprovals) {
            sb.append(separator).append(approval.getName());
            separator = ", ";
        }
        return sb.toString();
    }

    public SignatureType getCredentials() {
        return this.credentials;
    }

    public void setCredentials(SignatureType credentials) {
        this.credentials = credentials;
    }

    public Selector getSelector() {
        return this.selector;
    }

    public void setSelector(Selector selector) {
        this.selector = selector;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public String getBody() {
        return this.body;
    }

    public Label getLabel() {
        return this.label;
    }

    public void setLabel(Label label) {
        this.label = label;
    }

    public void validate() throws WorkflowException {
        int napproverconditions = 0;
        for (Condition condition : this.conditions) {
            if (!(condition instanceof ApproverCondition)) continue;
            if (napproverconditions > 0) {
                throw new WorkflowException("There can be only one Approver condition in the approval " + this.getName());
            }
            ++napproverconditions;
        }
    }

    public static boolean isValidName(String name) {
        for (char invalidCharacter : INVALID_CHARACTERS) {
            if (name.indexOf(invalidCharacter) < 0) continue;
            return false;
        }
        return true;
    }

    public static String getInvalidCharactersAsString() {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < INVALID_CHARACTERS.length; ++i) {
            char invalidCharacter = INVALID_CHARACTERS[i];
            result.append(invalidCharacter).append(i != INVALID_CHARACTERS.length - 1 ? ", " : "");
        }
        return result.toString();
    }

    public void setAdminUserNames(String adminUserNames) {
        if (adminUserNames != null) {
            this.adminCondition = new UserCondition(false, adminUserNames);
        }
    }

    public boolean isFinalApproval() {
        return this.finalApproval;
    }

    public boolean isVisible(AbstractPage page) {
        if (page instanceof Page) {
            return this.showInPages;
        }
        return page instanceof BlogPost && this.showInBlogs;
    }

    public boolean isShowInPages() {
        return this.showInPages;
    }

    public void setShowInPages(boolean showInPages) {
        this.showInPages = showInPages;
    }

    public boolean isShowInBlogs() {
        return this.showInBlogs;
    }

    public void setShowInBlogs(boolean showInBlogs) {
        this.showInBlogs = showInBlogs;
    }

    private Collection<ConfluenceUser> getUsersFromEntityCollection(Collection<Entity> entityCollection) {
        ArrayList<ConfluenceUser> users = new ArrayList<ConfluenceUser>();
        for (Entity entity : entityCollection) {
            if (!(entity instanceof ConfluenceUser)) continue;
            users.add((ConfluenceUser)entity);
        }
        return users;
    }

    private Collection<Group> getGroupsFromEntityCollection(Collection<Entity> entityCollection) {
        ArrayList<Group> groups = new ArrayList<Group>();
        for (Entity entity : entityCollection) {
            if (!(entity instanceof Group)) continue;
            groups.add((Group)entity);
        }
        return groups;
    }

    public ApprovalStatus getStatus(ValueStore valueStore, ApprovalCheck approvalCheck) throws WorkflowException {
        ApprovalStatus status = new ApprovalStatus(true, AuthenticatedUserThreadLocal.getUsername() != null && valueStore.getPage().isLatestVersion());
        boolean hasInclusiveConditionBeenMetYet = false;
        boolean hasBeenAlreadyExcluded = false;
        boolean hasAlreadyBeenAllowed = false;
        if (this.selector != null || this.isAssignable()) {
            status.setAllowedToAssign(true);
        }
        for (Condition condition : this.conditions) {
            if (!condition.isApplicableToProduct()) continue;
            if (condition instanceof AbstractUserGroupApproverCondition) {
                Collection<Entity> possibleApprovers = ((AbstractUserGroupApproverCondition)condition).getSelectableUsersOrGroups(valueStore, this.selector);
                if (condition instanceof AllowedAssignerUserCondition || condition instanceof AllowedAssignerGroupCondition) {
                    if (hasAlreadyBeenAllowed) continue;
                    hasAlreadyBeenAllowed = condition.evaluate(valueStore);
                    status.setAllowedToAssign(hasAlreadyBeenAllowed);
                    continue;
                }
                if (condition instanceof UserCondition || condition instanceof GroupCondition || condition instanceof ApproverCondition) {
                    if (!hasInclusiveConditionBeenMetYet && !hasBeenAlreadyExcluded) {
                        hasInclusiveConditionBeenMetYet = condition.evaluate(valueStore);
                        status.setCanApprove(hasInclusiveConditionBeenMetYet);
                    }
                    status.addPossibleUserApprovers(this.getUsersFromEntityCollection(possibleApprovers));
                    status.addPossibleGroupApprovers(this.getGroupsFromEntityCollection(possibleApprovers));
                    continue;
                }
                if (!(condition instanceof ExcludeCondition)) continue;
                status.addExcludedUserApprovers(this.getUsersFromEntityCollection(possibleApprovers));
                hasBeenAlreadyExcluded = !condition.evaluate(valueStore);
                status.setCanApprove(status.isCanApprove() && !hasBeenAlreadyExcluded);
                continue;
            }
            status.setReady(status.isReady() && condition.evaluate(valueStore));
        }
        status.setPrecedingApprovalsNames(this.getPreceedingApprovalNames());
        if (approvalCheck != null) {
            status.setRequiredApprovers(approvalCheck.getRequiredApprovers());
        }
        String[] requiredApprovers = status.getRequiredApprovers();
        if (status.isCanApprove() && requiredApprovers.length > 0) {
            boolean found = false;
            String userName = AuthenticatedUserThreadLocal.getUsername();
            for (String requiredApprover : requiredApprovers) {
                if (!requiredApprover.equalsIgnoreCase(userName)) continue;
                found = true;
                break;
            }
            status.setCanApprove(found);
        }
        if (this.adminCondition != null) {
            boolean conditionResult = this.adminCondition.evaluate(valueStore);
            status.setCanApprove(status.isCanApprove() || conditionResult);
            status.setAllowedToAssign(status.isAllowedToAssign() || conditionResult);
        }
        return status;
    }

    public AllowedAssignerUserCondition getAllowedAssignerUserCondition() {
        for (Condition condition : this.conditions) {
            if (!(condition instanceof AllowedAssignerUserCondition)) continue;
            return (AllowedAssignerUserCondition)condition;
        }
        return null;
    }

    public AllowedAssignerGroupCondition getAllowedAssignerGroupCondition() {
        for (Condition condition : this.conditions) {
            if (!(condition instanceof AllowedAssignerGroupCondition)) continue;
            return (AllowedAssignerGroupCondition)condition;
        }
        return null;
    }

    public ApproverCondition getApproverCondition() {
        for (Condition condition : this.conditions) {
            if (!(condition instanceof ApproverCondition)) continue;
            return (ApproverCondition)condition;
        }
        return null;
    }

    public void setFinalApproval(boolean finalApproval) {
        this.finalApproval = finalApproval;
    }

    public int getWeight() {
        return this.weight;
    }

    public int compareTo(Object o) {
        if (o instanceof Approval) {
            Approval a = (Approval)o;
            if (this.weight < a.weight) {
                return -1;
            }
            if (this.weight == a.weight) {
                return this.getName().compareTo(a.getName());
            }
            return 1;
        }
        return this.getName().compareTo(o.toString());
    }

    @Override
    public SerializableMacro toMacro() {
        SerializableMacro macro = new SerializableMacro("approval");
        macro.addParameter(this.getName());
        if (this.credentials != SignatureType.NONE) {
            macro.addParameter("credentials", (Object)this.credentials.getId());
        }
        if (!this.showInBlogs || !this.showInPages) {
            macro.addParameter("showinpages", (Object)this.showInPages);
            macro.addParameter("showinnews", (Object)this.showInBlogs);
        }
        if (this.finalApproval) {
            macro.addParameter("final", (Object)this.finalApproval);
        }
        if (this.weight != 40) {
            macro.addParameter("weight", (Object)this.weight);
        }
        if (this.label != null) {
            macro.addParameter("label", (Object)this.label.toString());
        }
        if (this.assignable) {
            macro.addParameter("assignable", (Object)this.assignable);
        }
        if (this.rememberAssignees) {
            macro.addParameter("rememberassignees", (Object)this.rememberAssignees);
        }
        for (Condition condition : this.conditions) {
            if (!condition.isApplicableToProduct()) continue;
            condition.addMacroParameters(macro);
        }
        if (macro.getParameterValue("minimum") == null && !this.minRequiredApprovers.equals("1") && !this.minRequiredApprovers.equals("0")) {
            macro.addParameter("minimum", (Object)this.minRequiredApprovers);
        }
        if (this.approveLabel != null) {
            macro.addParameter("approvelabel", (Object)this.approveLabel);
        }
        if (this.rejectLabel != null) {
            macro.addParameter("rejectlabel", (Object)this.rejectLabel);
        }
        if (this.description != null) {
            macro.addParameter("description", (Object)this.description);
        }
        if (this.roles) {
            macro.addParameter("roles", (Object)this.roles);
        }
        return macro;
    }

    public String toString() {
        return "Approval{name='" + this.getName() + "', finalApproval=" + this.finalApproval + ", selector=" + this.selector + ", conditions=" + this.conditions + (String)(this.dependingApprovals != null && this.dependingApprovals.size() > 0 ? ", depending approvals=" + this.getApprovalNames(this.dependingApprovals) : "") + (String)(this.preceedingApprovals != null && this.preceedingApprovals.size() > 0 ? ", depending approvals=" + this.getApprovalNames(this.preceedingApprovals) : "") + "}";
    }

    private String getApprovalNames(List<Approval> list) {
        StringBuffer sb = new StringBuffer("{");
        for (Approval approval : list) {
            sb.append(approval.getName()).append(" ");
        }
        sb.append("}");
        return sb.toString();
    }

    public String getName() {
        return this.name;
    }

    public boolean isAssignable() {
        return this.assignable;
    }

    public void setAssignable(boolean assignable) {
        this.assignable = assignable;
    }

    public String getMinRequiredApprovers() {
        return this.minRequiredApprovers;
    }

    public void setMinRequiredApprovers(String minRequiredApprovers) {
        this.minRequiredApprovers = minRequiredApprovers;
    }

    public boolean isRememberAssignees() {
        return this.rememberAssignees;
    }

    public void setRememberAssignees(boolean rememberAssignees) {
        this.rememberAssignees = rememberAssignees;
    }

    public String getApproveLabel() {
        return this.approveLabel;
    }

    public void setApproveLabel(String approveLabel) {
        this.approveLabel = approveLabel;
    }

    public String getRejectLabel() {
        return this.rejectLabel;
    }

    public void setRejectLabel(String rejectLabel) {
        this.rejectLabel = rejectLabel;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isRoles() {
        return this.roles;
    }

    public void setRoles(boolean roles) {
        this.roles = roles;
    }
}

