/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.workflow;

import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.templates.PageTemplate;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.WikiStyleRenderer;
import com.atlassian.upm.api.license.entity.LicenseType;
import com.atlassian.user.User;
import com.comalatech.confluence.license.AdhocWorkflowsLicenseManager;
import com.comalatech.confluence.util.PageReference;
import com.comalatech.confluence.workflow.PageSectionsManager;
import com.comalatech.confluence.workflow.PageWorkflows;
import com.comalatech.confluence.workflow.helpers.TemplateRenderer;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DefaultPageSectionsManager
implements PageSectionsManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultPageSectionsManager.class);
    private final WikiStyleRenderer wikiStyleRenderer;
    private final TemplateRenderer templateRenderer;
    private final PermissionManager permissionManager;
    private final AdhocWorkflowsLicenseManager adhocWorkflowsLicenseManager;
    private final AccessModeService accessModeService;

    public DefaultPageSectionsManager(@ComponentImport WikiStyleRenderer wikiStyleRenderer, TemplateRenderer templateRenderer, @ComponentImport PermissionManager permissionManager, AdhocWorkflowsLicenseManager adhocWorkflowsLicenseManager, @ComponentImport AccessModeService accessModeService) {
        this.wikiStyleRenderer = wikiStyleRenderer;
        this.templateRenderer = templateRenderer;
        this.permissionManager = permissionManager;
        this.adhocWorkflowsLicenseManager = adhocWorkflowsLicenseManager;
        this.accessModeService = accessModeService;
    }

    @Override
    public PageSectionsManager.PageSections renderPageSections(PageWorkflows pageWorkflows, ConversionContext conversionContext, boolean publishedView) {
        PageContext pageContext;
        AbstractPage page = pageWorkflows.getPage();
        boolean readOnly = !this.canEdit(page);
        PageContext pageContext2 = pageContext = conversionContext != null ? conversionContext.getPageContext() : page.toPageContext();
        if (publishedView) {
            pageContext.addParam((Object)"releaseview", (Object)true);
        }
        String header = this.getHeader(pageWorkflows, pageContext, readOnly);
        String footer = this.getFooter(pageWorkflows, pageContext, readOnly);
        String trialMessage = this.getTrialMessage();
        return new PageSectionsManager.PageSections((String)(StringUtils.isNotBlank((CharSequence)header) ? "<div id='workflow-page-header'>" + header + "</div>\n" : ""), (String)(StringUtils.isNotBlank((CharSequence)footer) ? "<div id='workflow-page-footer'>" + footer + "</div>\n" : ""), (String)(StringUtils.isNotBlank((CharSequence)trialMessage) ? "<div id='workflow-license-message'>" + trialMessage + "</div>\n" : ""));
    }

    private String removeNamespacedElements(String xml) {
        return xml.replaceAll("<at:declarations />", "");
    }

    private boolean canEdit(AbstractPage page) {
        return (Boolean)this.accessModeService.withReadOnlyAccessExemption(() -> this.permissionManager.hasPermission((User)AuthenticatedUserThreadLocal.get(), Permission.EDIT, (Object)page));
    }

    private String getHeader(PageWorkflows pageWorkflows, PageContext pageContext, boolean readOnly) {
        AbstractPage page = pageWorkflows.getPage();
        String header = null;
        try {
            PageTemplate headerTemplate;
            if (pageWorkflows.getPageHeaderTemplate() != null && (headerTemplate = this.templateRenderer.getTemplate(PageReference.parse(pageWorkflows.getPageHeaderTemplate()), page.getSpaceKey())) != null) {
                header = this.templateRenderer.renderTemplate(headerTemplate, (RenderContext)pageContext);
            }
            if (header == null && (header = pageWorkflows.getPageHeaderBody(readOnly)) != null) {
                header = pageWorkflows.getValueStore().replaceReferences(header);
                header = this.wikiStyleRenderer.convertWikiToXHtml((RenderContext)pageContext, header);
            }
            if (header != null) {
                header = this.removeNamespacedElements(header);
            }
        }
        catch (Exception e) {
            log.error("Error rendering page header", (Throwable)e);
            header = null;
        }
        return header;
    }

    private String getFooter(PageWorkflows pageWorkflows, PageContext pageContext, boolean readOnly) {
        AbstractPage page = pageWorkflows.getPage();
        String footer = null;
        try {
            PageTemplate footerTemplate;
            if (pageWorkflows.getPageFooterTemplate() != null && (footerTemplate = this.templateRenderer.getTemplate(PageReference.parse(pageWorkflows.getPageFooterTemplate()), page.getSpaceKey())) != null) {
                footer = this.templateRenderer.renderTemplate(footerTemplate, (RenderContext)pageContext);
            }
            if (footer == null && (footer = pageWorkflows.getPageFooterBody(readOnly)) != null) {
                footer = pageWorkflows.getValueStore().replaceReferences(footer);
                footer = this.wikiStyleRenderer.convertWikiToXHtml((RenderContext)pageContext, footer);
            }
            if (footer != null) {
                footer = this.removeNamespacedElements(footer);
            }
        }
        catch (Exception e) {
            log.error("Error rendering page footer", (Throwable)e);
            footer = null;
        }
        return footer;
    }

    private String getTrialMessage() {
        try {
            LicenseType type = this.adhocWorkflowsLicenseManager.getLicenseType();
            if (type == LicenseType.ACADEMIC || type == LicenseType.COMMERCIAL) {
                return "";
            }
            Object trialMessage = this.adhocWorkflowsLicenseManager.getLicenseStatus().getMessageHtml();
            if (StringUtils.isNotBlank((CharSequence)trialMessage)) {
                trialMessage = "<div style=\"background-color:#fefed6;font-size:0.9em;display: inline-block; padding: 2px 5px 2px 5px; color: black;\">" + (String)trialMessage + "</div>";
            }
            return trialMessage;
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return "";
        }
    }
}

