/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.util;

import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.atlassian.user.User;
import com.comalatech.confluence.adhocworkflows.rest.permissions.WorkflowsAppRequired;
import com.comalatech.confluence.adhocworkflows.rest.permissions.WorkflowsLiteAppRequired;
import com.comalatech.confluence.i18n.ComalaI18nBean;
import com.comalatech.confluence.license.WorkflowsFeatureManager;
import com.comalatech.confluence.workflow.rest.model.PermissionRequired;
import com.comalatech.confluence.workflow.restv2.accessor.MarkupValidationException;
import com.comalatech.workflow.WorkflowException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RestCommand {
    private static final Logger log = LoggerFactory.getLogger(RestCommand.class);
    private static final List<String> VALID_ANNOTATIONS_RESTCOMMAND = Arrays.asList("@com.comalatech.confluence.adhocworkflows.rest.permissions.WorkflowVisibilityPermissionsRequired()", "@com.atlassian.confluence.api.service.accessmode.ReadOnlyAccessAllowed()");
    private static final List<String> IGNORE_ANNOTATIONS_RESTCOMMAND = Arrays.asList("@javax", "@io.swagger");
    protected static final String APPLICATION_PERMISSION_ERROR = "The application has no permission over ";
    private final List<String> validAnnotations;
    private final List<String> ignoreAnnotations;
    protected final WorkflowsFeatureManager workflowsFeatureManager;
    protected final PermissionManager permissionManager;

    protected RestCommand(WorkflowsFeatureManager workflowsFeatureManager, PermissionManager permissionManager) {
        this.workflowsFeatureManager = workflowsFeatureManager;
        this.permissionManager = permissionManager;
        this.validAnnotations = VALID_ANNOTATIONS_RESTCOMMAND;
        this.ignoreAnnotations = IGNORE_ANNOTATIONS_RESTCOMMAND;
    }

    protected boolean hasAnnotation(Class clazz) {
        return null != this.getClass().getEnclosingClass().getAnnotation(clazz) || null != this.getClass().getEnclosingMethod().getAnnotation(clazz);
    }

    protected PermissionRequired getAnnotationIfExists(Method method) {
        PermissionRequired annotation = method.getAnnotation(PermissionRequired.class);
        if (annotation != null) {
            return annotation;
        }
        return method.getDeclaringClass().getDeclaredAnnotation(PermissionRequired.class);
    }

    protected void validateApplication() throws ApplicationPermissionException {
        boolean allowed = true;
        boolean skip = false;
        if (this.hasAnnotation(WorkflowsAppRequired.class)) {
            skip = allowed = this.workflowsFeatureManager.isWorkflowsApp();
        }
        if (!skip && this.hasAnnotation(WorkflowsLiteAppRequired.class)) {
            allowed = this.workflowsFeatureManager.isWorkflowsLiteApp();
        }
        if (!allowed) {
            throw new ApplicationPermissionException(APPLICATION_PERMISSION_ERROR + this.getClass().getEnclosingClass().getName() + ":" + this.getClass().getEnclosingMethod().getName());
        }
    }

    protected void validatePermissions() throws ApplicationPermissionException {
        PermissionRequired annotation = this.getAnnotationIfExists(this.getClass().getEnclosingMethod());
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (annotation != null) {
            for (String permission : annotation.value()) {
                if (this.permissionManager.hasPermission((User)user, Permission.forName((String)permission), this.getValidationTarget())) continue;
                if (log.isDebugEnabled()) {
                    log.debug(user.getName() + " has no " + permission + " permission over " + this.getValidationTarget());
                }
                throw new ApplicationPermissionException(user.getName() + " has no " + permission + " permission over " + this.getValidationTarget());
            }
        }
    }

    protected RestCommand validate() throws ApplicationPermissionException {
        this.validateAllowedAnnotations();
        this.validateApplication();
        this.validatePermissions();
        return this;
    }

    public Object getValidationTarget() {
        return PermissionManager.TARGET_APPLICATION;
    }

    public Response execute() {
        try {
            return this.validate().doExecute();
        }
        catch (ApplicationPermissionException e) {
            this.logException((Exception)((Object)e));
            if (e.getMessage().contains(APPLICATION_PERMISSION_ERROR)) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)StringEscapeUtils.escapeHtml4((String)e.getMessage())).type("application/json").build();
            }
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)StringEscapeUtils.escapeHtml4((String)e.getMessage())).type("application/json").build();
        }
        catch (MarkupValidationException e) {
            this.logException(e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)StringEscapeUtils.escapeHtml4((String)e.getMessage())).type("application/json").build();
        }
        catch (WorkflowException e) {
            this.logException(e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ComalaI18nBean.getComalaI18nBean().getText("approvalsworkflow.workflow.error", new String[]{StringEscapeUtils.escapeHtml4((String)e.getMessage())})).type("application/json").build();
        }
        catch (Exception e) {
            log.warn("Cannot execute action", (Throwable)e);
            this.logException(e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)(e.getMessage() != null ? StringEscapeUtils.escapeHtml4((String)e.getMessage()) : "Internal server error")).type("application/json").build();
        }
    }

    private void logException(Exception e) {
        if (log.isDebugEnabled()) {
            log.debug("{} generated from class: {} method: {}: {}", new Object[]{e.getClass().getName(), this.getClass().getName(), this.getClass().getEnclosingMethod().getName(), e.getMessage()});
        }
    }

    public abstract Response doExecute() throws Exception;

    protected void validateAllowedAnnotations() {
        HashSet<Annotation> annotations = new HashSet<Annotation>();
        annotations.addAll(Arrays.asList(this.getClass().getEnclosingMethod().getAnnotations()));
        annotations.addAll(Arrays.asList(this.getClass().getAnnotations()));
        List invalid = annotations.stream().map(Annotation::toString).filter(a -> this.ignoreAnnotations.stream().noneMatch(a::contains)).filter(a -> !this.validAnnotations.contains(a)).collect(Collectors.toList());
        if (!invalid.isEmpty()) {
            throw new RuntimeException("Unsupported annotation " + (String)invalid.get(0) + " in RestComamnd at " + this.getClass().getName() + " " + this.getClass().getEnclosingMethod().getName());
        }
    }
}

