/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.readack.service;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.user.actions.ProfilePictureInfo;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.user.User;
import com.comalatech.confluence.readack.ReadAckException;
import com.comalatech.confluence.readack.activeObjects.accessor.ReadAckRecordAccessor;
import com.comalatech.confluence.readack.activeObjects.entity.BaseReadAckRecord;
import com.comalatech.confluence.readack.events.ReadAckCreatedEventImpl;
import com.comalatech.confluence.readack.events.ReadAckDueDateChangeEventImpl;
import com.comalatech.confluence.readack.events.ReadAcknowledgedEventImpl;
import com.comalatech.confluence.readack.events.stats.ReadAckNewRequest;
import com.comalatech.confluence.readack.model.ReadAckConfig;
import com.comalatech.confluence.readack.model.ReadAckPageStatus;
import com.comalatech.confluence.readack.model.ReadAckRecordImpl;
import com.comalatech.confluence.readack.model.ReadAckSearchCriteria;
import com.comalatech.confluence.readack.model.ReadAckSearchFilter;
import com.comalatech.confluence.readack.model.ReadAckStatusType;
import com.comalatech.confluence.readack.resources.ReadAckResource;
import com.comalatech.confluence.readack.service.ReadAckConfigManager;
import com.comalatech.confluence.readack.service.ReadAckManager;
import com.comalatech.confluence.timers.TimerUtils;
import com.comalatech.confluence.workflow.DefaultWorkflowAccessor;
import com.comalatech.confluence.workflow.PageWorkflows;
import com.comalatech.workflow.WorkflowException;
import java.time.LocalDateTime;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class DefaultReadAckManager
implements ReadAckManager,
InitializingBean,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(DefaultReadAckManager.class);
    private ReadAckConfigManager readAckConfigManager;
    private final ReadAckRecordAccessor readAckRecordAccessor;
    private final EventPublisher eventPublisher;
    private final UserAccessor userAccessor;
    private final DefaultWorkflowAccessor defaultWorkflowAccessor;
    private ApplicationContext applicationContext;

    public DefaultReadAckManager(ReadAckRecordAccessor readAckRecordAccessor, @ComponentImport EventPublisher eventPublisher, @ComponentImport UserAccessor userAccessor, DefaultWorkflowAccessor defaultWorkflowAccessor) {
        this.readAckRecordAccessor = readAckRecordAccessor;
        this.eventPublisher = eventPublisher;
        this.userAccessor = userAccessor;
        this.defaultWorkflowAccessor = defaultWorkflowAccessor;
    }

    public void afterPropertiesSet() throws Exception {
        this.readAckConfigManager = (ReadAckConfigManager)this.applicationContext.getBean(ReadAckConfigManager.class);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Override
    public ReadAckPageStatus getPageStatus(AbstractPage page, boolean canViewWorkflows, boolean expand) throws ReadAckException {
        ReadAckConfig readAckConfig = this.readAckConfigManager.loadReadAckConfig(page, true);
        return this.getPageStatus(readAckConfig, canViewWorkflows, expand);
    }

    private ReadAckPageStatus getPageStatus(ReadAckConfig readAckConfig, boolean canViewWorkflows, boolean expand) {
        ReadAckPageStatus readAckStatus = null;
        if (readAckConfig != null) {
            ConfluenceUser user = AuthenticatedUserThreadLocal.get();
            ConfluenceUser recordUser = null;
            readAckStatus = new ReadAckPageStatus(readAckConfig.pageId, readAckConfig.pageStateId, canViewWorkflows, readAckConfig.dueDate);
            int pendingUsers = 0;
            int ackedUsers = 0;
            ArrayList<UserKey> userKeys = new ArrayList<UserKey>();
            ReadAckSearchCriteria criteria = new ReadAckSearchCriteria();
            criteria.setPageId(readAckConfig.pageId);
            criteria.setPageStateId(readAckConfig.pageStateId);
            criteria.setStatusTypes(Arrays.asList(ReadAckStatusType.UserStatusType.PENDING, ReadAckStatusType.UserStatusType.ACKNOWLEDGED));
            LinkedHashMap<String, String> orderBy = new LinkedHashMap<String, String>();
            orderBy.put("CREATION_TIMESTAMP", "DESC");
            List<BaseReadAckRecord> records = this.readAckRecordAccessor.search(criteria, new ReadAckSearchFilter(-1, 0, orderBy));
            for (BaseReadAckRecord record : records) {
                UserKey userKey = new UserKey(record.getUserKey());
                if (userKeys.contains(userKey)) continue;
                userKeys.add(userKey);
                if (record.getStatus().equals(ReadAckStatusType.UserStatusType.PENDING)) {
                    ++pendingUsers;
                } else if (record.getStatus().equals(ReadAckStatusType.UserStatusType.ACKNOWLEDGED)) {
                    ++ackedUsers;
                }
                readAckStatus.setDueDate(readAckConfig.dueDate);
                if (user != null && user.getKey().equals((Object)userKey)) {
                    recordUser = user;
                    readAckStatus.setUserStatus(record.getStatus());
                } else if (canViewWorkflows && expand) {
                    recordUser = this.userAccessor.getUserByKey(userKey);
                }
                if (!canViewWorkflows || !expand) continue;
                ProfilePictureInfo picture = this.userAccessor.getUserProfilePicture((User)recordUser);
                String picUrl = null;
                if (picture != null) {
                    picUrl = picture.getUriReference();
                }
                readAckStatus.getUsers().add(new ReadAckPageStatus.ReadAckUser(recordUser.getName(), recordUser.getFullName(), picUrl, record.getStatus(), record.getAcknowledgedTimestamp(), record.getPageVersion()));
            }
            readAckStatus.setAckUsers(ackedUsers);
            readAckStatus.setPendingUsers(pendingUsers);
            readAckStatus.setChangeDueDate(readAckConfig.changeDueDate);
            if (canViewWorkflows) {
                readAckStatus.setPageStatus(readAckConfig.status);
            }
        }
        return readAckStatus;
    }

    @Override
    public ReadAckPageStatus acknowledge(AbstractPage page, boolean canViewWorkflows) throws ReadAckException {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        ReadAckConfig readAckConfig = this.readAckConfigManager.loadReadAckConfig(page);
        if (readAckConfig != null && !readAckConfig.status.equals((Object)ReadAckStatusType.PageStatusType.ACKNOWLEDGED)) {
            ReadAckSearchCriteria criteria = new ReadAckSearchCriteria();
            criteria.setUserKey(user.getKey().getStringValue());
            criteria.setPageId(page.getId());
            criteria.setPageStateId(readAckConfig.pageStateId);
            criteria.setStatus(ReadAckStatusType.UserStatusType.PENDING);
            LinkedHashMap<String, String> orderBy = new LinkedHashMap<String, String>();
            orderBy.put("CREATION_TIMESTAMP", "DESC");
            List<BaseReadAckRecord> readAckRecords = this.readAckRecordAccessor.search(criteria, new ReadAckSearchFilter(-1, 0, orderBy));
            if (!readAckRecords.isEmpty()) {
                BaseReadAckRecord record = readAckRecords.get(readAckRecords.size() - 1);
                record.setStatus(ReadAckStatusType.UserStatusType.ACKNOWLEDGED);
                record.setAcknowledgedTimestamp(TimerUtils.toEpochMilli(LocalDateTime.now()));
                if (readAckRecords.size() > 1) {
                    this.closeExtraRecords(readAckRecords);
                    log.warn("closing extra records found for pageId " + readAckConfig.pageId);
                }
                try {
                    PageWorkflows pageWorkflows = this.defaultWorkflowAccessor.getWorkflows(page);
                    if (pageWorkflows.isStandAloneReadAck()) {
                        record.setPageVersion(page.getVersion());
                    } else {
                        record.setPageVersion(this.getReadAckVersionWithStates(pageWorkflows, page, readAckConfig));
                    }
                }
                catch (WorkflowException e) {
                    throw new ReadAckException("There was an error while trying to acknowledge the read of page: \"" + page.getId() + "\" by user \"" + user.getName() + "\"");
                }
                this.readAckRecordAccessor.save(record);
                this.eventPublisher.publish((Object)new ReadAcknowledgedEventImpl(this, page));
                if (!this.hasPendingRecords(readAckConfig)) {
                    this.readAckConfigManager.setReadAckAsCompleted(page, readAckConfig, record.getAcknowledgedTimestamp());
                }
            } else {
                throw new ReadAckException("There was an error while trying to acknowledge the read of page: \"" + page.getId() + "\" by user \"" + user.getName() + "\"");
            }
        }
        return this.getPageStatus(readAckConfig, canViewWorkflows, false);
    }

    @Override
    public void setupUsersReadAck(List<Map.Entry<ConfluenceUser, BaseReadAckRecord.ReadAckAssignmentType>> usersSet, ReadAckConfig readAckConfig) {
        List<BaseReadAckRecord> records = usersSet.stream().map(user -> this.createRecord(readAckConfig, ((ConfluenceUser)user.getKey()).getKey().getStringValue(), (BaseReadAckRecord.ReadAckAssignmentType)((Object)((Object)user.getValue())))).collect(Collectors.toList());
        this.readAckRecordAccessor.save(records);
    }

    private BaseReadAckRecord createRecord(ReadAckConfig readAckConfig, String userKey, BaseReadAckRecord.ReadAckAssignmentType assignmentType) {
        return new ReadAckRecordImpl(userKey, readAckConfig.pageId, null, readAckConfig.pageStateId, ReadAckStatusType.UserStatusType.PENDING, readAckConfig.dueDate, readAckConfig.creationDate, assignmentType);
    }

    @Override
    public void closePendingReadAcks(ReadAckConfig readAckConfig) {
        this.readAckRecordAccessor.close(readAckConfig.pageStateId, Collections.singletonList(readAckConfig.pageId));
    }

    @Override
    public void removeReadAckUserRecords(AbstractPage page) {
        ReadAckSearchCriteria criteria = new ReadAckSearchCriteria();
        criteria.setPageId(page.getId());
        this.readAckRecordAccessor.delete(criteria);
    }

    @Override
    public ReadAckPageStatus updateReadAckReaders(AbstractPage page, Map<ReadAckResource.UserUpdateCommand, List<String>> users, boolean canViewWorkflows) throws ReadAckException {
        ReadAckConfig readAckConfig = this.readAckConfigManager.loadReadAckConfig(page);
        if (readAckConfig != null) {
            boolean isAcknowledged = readAckConfig.status.equals((Object)ReadAckStatusType.PageStatusType.ACKNOWLEDGED);
            List<BaseReadAckRecord> usersToAdd = this.createUserRecordsToAdd(readAckConfig, users);
            List<BaseReadAckRecord> usersToDelete = this.createUserRecordsToBeDeleted(readAckConfig, users);
            if (!usersToDelete.isEmpty() && isAcknowledged) {
                throw new ReadAckException("The Read Confirmation in page " + page.getId() + " can't be updated since in the Acknowledged state users can't be manually removed");
            }
            this.readAckRecordAccessor.updateReadAckUsers(usersToDelete, usersToAdd);
            if (!usersToAdd.isEmpty()) {
                Set<ConfluenceUser> confluenceUsers = usersToAdd.stream().map(p -> this.userAccessor.getUserByKey(new UserKey(p.getUserKey()))).collect(Collectors.toSet());
                this.eventPublisher.publish((Object)new ReadAckCreatedEventImpl(this, page, confluenceUsers));
            }
            boolean hasPendingRecords = this.hasPendingRecords(readAckConfig);
            if (!isAcknowledged && !hasPendingRecords && this.hasAcknowledgedRecords(readAckConfig)) {
                this.readAckConfigManager.setReadAckAsCompleted(page, readAckConfig, TimerUtils.toEpochMilli(LocalDateTime.now()));
            } else if (isAcknowledged && hasPendingRecords) {
                this.readAckConfigManager.reopenReadAck(page, readAckConfig);
            }
        } else {
            throw new ReadAckException("There is no Read Confirmation in page " + page.getId() + ", or it has already been completed, additional users can't be added");
        }
        return this.getPageStatus(readAckConfig, canViewWorkflows, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ReadAckPageStatus createOrUpdateReadAckDueDate(AbstractPage page, Long dueDate, boolean canViewWorkflows) throws ReadAckException {
        ReadAckConfig readAckConfig = this.readAckConfigManager.loadReadAckConfig(page);
        if (readAckConfig == null) throw new ReadAckException("There is no Read Confirmation in page " + page.getId());
        if (!readAckConfig.changeDueDate.booleanValue()) throw new ReadAckException("the expiration date cannot be changed");
        readAckConfig.status = this.calculateCurrentPageStatus(dueDate, readAckConfig);
        readAckConfig.dueDate = this.checkDueDate(dueDate, readAckConfig);
        this.readAckConfigManager.updateReadAckConfig(page, readAckConfig);
        ReadAckSearchCriteria criteria = new ReadAckSearchCriteria();
        criteria.setPageId(page.getId());
        criteria.setPageStateId(readAckConfig.pageStateId);
        criteria.setStatus(ReadAckStatusType.UserStatusType.PENDING);
        List<BaseReadAckRecord> readAckRecords = this.readAckRecordAccessor.search(criteria);
        if (readAckConfig.status == ReadAckStatusType.PageStatusType.ACKNOWLEDGED) return this.getPageStatus(readAckConfig, canViewWorkflows, true);
        for (BaseReadAckRecord record : readAckRecords) {
            record.setDueDateTimestamp(dueDate);
            this.readAckRecordAccessor.save(record);
        }
        this.eventPublisher.publish((Object)new ReadAckDueDateChangeEventImpl(this, page));
        return this.getPageStatus(readAckConfig, canViewWorkflows, true);
    }

    private ReadAckStatusType.PageStatusType calculateCurrentPageStatus(Long dueDate, ReadAckConfig readAckConfig) {
        if (!(dueDate != null && this.isExpired(dueDate) || readAckConfig.status == ReadAckStatusType.PageStatusType.ACKNOWLEDGED)) {
            return ReadAckStatusType.PageStatusType.PENDING;
        }
        return readAckConfig.status;
    }

    private Long checkDueDate(Long dueDate, ReadAckConfig readAckConfig) {
        if (readAckConfig.status != ReadAckStatusType.PageStatusType.ACKNOWLEDGED) {
            return dueDate;
        }
        return readAckConfig.dueDate;
    }

    private boolean isExpired(Long dueDate) {
        return new Date().after(new Date(dueDate));
    }

    private List<BaseReadAckRecord> createUserRecordsToAdd(ReadAckConfig readAckConfig, Map<ReadAckResource.UserUpdateCommand, List<String>> users) {
        if (users.containsKey((Object)ReadAckResource.UserUpdateCommand.ADDED_USERS) && CollectionUtils.isNotEmpty(users.get((Object)ReadAckResource.UserUpdateCommand.ADDED_USERS))) {
            Set<String> userKeys = this.getUserKeysFromNameAsString(users.get((Object)ReadAckResource.UserUpdateCommand.ADDED_USERS));
            ReadAckSearchCriteria userAssignedCriteria = this.createUserAssignedCriteria(readAckConfig.pageId, userKeys);
            Set<String> finalUserKeys = this.removePendingReadAckUsers(userAssignedCriteria, userKeys);
            return finalUserKeys.stream().map(userKey -> this.createRecord(readAckConfig, (String)userKey, BaseReadAckRecord.ReadAckAssignmentType.MANUAL)).collect(Collectors.toList());
        }
        return new ArrayList<BaseReadAckRecord>();
    }

    private List<BaseReadAckRecord> createUserRecordsToBeDeleted(ReadAckConfig readAckConfig, Map<ReadAckResource.UserUpdateCommand, List<String>> users) {
        if (users.containsKey((Object)ReadAckResource.UserUpdateCommand.REMOVED_USERS) && CollectionUtils.isNotEmpty(users.get((Object)ReadAckResource.UserUpdateCommand.REMOVED_USERS))) {
            Set<String> userKeys = this.getUserKeysFromNameAsString(users.get((Object)ReadAckResource.UserUpdateCommand.REMOVED_USERS));
            ReadAckSearchCriteria usersToDeleteCriteria = this.createUserDeleteCriteria(readAckConfig.pageId, userKeys);
            List<BaseReadAckRecord> usersToBeDeleted = this.readAckRecordAccessor.search(usersToDeleteCriteria);
            usersToBeDeleted.forEach(ackRecord -> ackRecord.setStatus(ReadAckStatusType.UserStatusType.DELETED));
            return usersToBeDeleted;
        }
        return new ArrayList<BaseReadAckRecord>();
    }

    private Set<String> removePendingReadAckUsers(ReadAckSearchCriteria criteria, Set<String> userKeys) {
        List<Object> pendingUsers = criteria != null ? this.readAckRecordAccessor.search(criteria) : new ArrayList();
        if (!pendingUsers.isEmpty()) {
            return pendingUsers.stream().map(BaseReadAckRecord::getUserKey).flatMap(existingKey -> userKeys.stream().filter(newUserKey -> !newUserKey.equals(existingKey))).collect(Collectors.toSet());
        }
        return userKeys;
    }

    private ReadAckSearchCriteria createUserAssignedCriteria(Long pageId, Set<String> userKeys) {
        ReadAckSearchCriteria criteria = null;
        if (CollectionUtils.isNotEmpty(userKeys)) {
            criteria = new ReadAckSearchCriteria();
            criteria.setPageId(pageId);
            criteria.setUserKeys(userKeys);
            criteria.setStatus(ReadAckStatusType.UserStatusType.PENDING);
        }
        return criteria;
    }

    private ReadAckSearchCriteria createUserDeleteCriteria(Long pageId, Set<String> userKeys) {
        ReadAckSearchCriteria criteria = null;
        if (CollectionUtils.isNotEmpty(userKeys)) {
            criteria = new ReadAckSearchCriteria();
            criteria.setPageId(pageId);
            criteria.setUserKeys(userKeys);
        }
        return criteria;
    }

    private Set<String> getUserKeysFromNameAsString(List<String> userNames) {
        HashSet<String> userKeys = new HashSet<String>();
        for (String username : userNames) {
            ConfluenceUser user = this.userAccessor.getUserByName(username);
            if (user == null) {
                userKeys.add(username);
                continue;
            }
            userKeys.add(user.getKey().getStringValue());
        }
        return userKeys;
    }

    @Override
    public ReadAckPageStatus resetReadConfirmation(AbstractPage page) throws ReadAckException {
        ReadAckConfig readAckConfig = this.readAckConfigManager.loadReadAckConfig(page);
        if (readAckConfig == null) {
            throw new ReadAckException("ReadAckConfig not found");
        }
        ReadAckSearchCriteria criteria = new ReadAckSearchCriteria();
        criteria.setPageId(page.getId());
        criteria.setPageStateId(readAckConfig.pageStateId);
        criteria.setStatusTypes(Arrays.asList(ReadAckStatusType.UserStatusType.ACKNOWLEDGED, ReadAckStatusType.UserStatusType.PENDING));
        LinkedHashMap<String, String> orderBy = new LinkedHashMap<String, String>();
        orderBy.put("CREATION_TIMESTAMP", "DESC");
        List<BaseReadAckRecord> readAckRecords = this.readAckRecordAccessor.search(criteria, new ReadAckSearchFilter(-1, 0, orderBy));
        ArrayList<String> usersProcessed = new ArrayList<String>();
        ArrayList<Map.Entry<ConfluenceUser, BaseReadAckRecord.ReadAckAssignmentType>> usersSet = new ArrayList<Map.Entry<ConfluenceUser, BaseReadAckRecord.ReadAckAssignmentType>>();
        for (BaseReadAckRecord record : readAckRecords) {
            ConfluenceUser user;
            if (!usersProcessed.contains(record.getUserKey()) && record.getStatus().equals(ReadAckStatusType.UserStatusType.ACKNOWLEDGED) && (user = this.userAccessor.getExistingUserByKey(new UserKey(record.getUserKey()))) != null) {
                usersSet.add((Map.Entry<ConfluenceUser, BaseReadAckRecord.ReadAckAssignmentType>)new AbstractMap.SimpleEntry<ConfluenceUser, BaseReadAckRecord.ReadAckAssignmentType>(user, BaseReadAckRecord.ReadAckAssignmentType.fromString(record.getAssignmentType())){});
            }
            usersProcessed.add(record.getUserKey());
        }
        readAckConfig = this.readAckConfigManager.resetReadAckConfig(page, readAckConfig);
        this.setupUsersReadAck(usersSet, readAckConfig);
        this.eventPublisher.publish((Object)new ReadAckCreatedEventImpl(this, page, usersSet.stream().map(Map.Entry::getKey).collect(Collectors.toSet())));
        this.eventPublisher.publish((Object)new ReadAckNewRequest(this));
        return this.getPageStatus(readAckConfig, true, true);
    }

    @Override
    public void appendManualUsers(ReadAckConfig readAckConfig, List<Map.Entry<ConfluenceUser, BaseReadAckRecord.ReadAckAssignmentType>> usersSet) {
        ReadAckSearchCriteria criteria = new ReadAckSearchCriteria();
        criteria.setPageId(readAckConfig.pageId);
        criteria.setPageStateId(readAckConfig.pageStateId);
        criteria.setStatusTypes(Arrays.asList(ReadAckStatusType.UserStatusType.PENDING, ReadAckStatusType.UserStatusType.ACKNOWLEDGED));
        criteria.setAssignmentType(BaseReadAckRecord.ReadAckAssignmentType.MANUAL.toString());
        LinkedHashMap<String, String> orderBy = new LinkedHashMap<String, String>();
        orderBy.put("CREATION_TIMESTAMP", "DESC");
        List<BaseReadAckRecord> records = this.readAckRecordAccessor.search(criteria, new ReadAckSearchFilter(-1, 0, orderBy));
        HashSet<String> userKeys = new HashSet<String>();
        usersSet.forEach(pair -> userKeys.add(((ConfluenceUser)pair.getKey()).getKey().getStringValue()));
        for (BaseReadAckRecord record : records) {
            ConfluenceUser user;
            if (!userKeys.contains(record.getUserKey()) && (user = this.userAccessor.getExistingUserByKey(new UserKey(record.getUserKey()))) != null) {
                usersSet.add((Map.Entry<ConfluenceUser, BaseReadAckRecord.ReadAckAssignmentType>)new AbstractMap.SimpleEntry<ConfluenceUser, BaseReadAckRecord.ReadAckAssignmentType>(user, BaseReadAckRecord.ReadAckAssignmentType.fromString(record.getAssignmentType())){});
            }
            userKeys.add(record.getUserKey());
        }
    }

    private boolean hasPendingRecords(ReadAckConfig readAckConfig) {
        ReadAckSearchCriteria criteria = new ReadAckSearchCriteria();
        criteria.setPageId(readAckConfig.pageId);
        criteria.setPageStateId(readAckConfig.pageStateId);
        criteria.setStatus(ReadAckStatusType.UserStatusType.PENDING);
        return this.readAckRecordAccessor.count(criteria) > 0L;
    }

    private boolean hasAcknowledgedRecords(ReadAckConfig readAckConfig) {
        ReadAckSearchCriteria criteria = new ReadAckSearchCriteria();
        criteria.setPageId(readAckConfig.pageId);
        criteria.setPageStateId(readAckConfig.pageStateId);
        criteria.setStatus(ReadAckStatusType.UserStatusType.ACKNOWLEDGED);
        return this.readAckRecordAccessor.count(criteria) > 0L;
    }

    private int getReadAckVersionWithStates(PageWorkflows pageWorkflows, AbstractPage page, ReadAckConfig readAckConfig) {
        String currentState;
        String finalState = pageWorkflows.getStatesContainer().getFinalState().getName();
        if (finalState.equals(currentState = pageWorkflows.getValueStore().getPageState().getState())) {
            return page.getVersion();
        }
        return readAckConfig.pageVersion;
    }

    private void closeExtraRecords(List<BaseReadAckRecord> records) {
        this.readAckRecordAccessor.closeExtraRecords(records.subList(0, records.size() - 1));
    }
}

