/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.documentActivity.upgrade.tasks;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.comalatech.confluence.documentActivity.ao.entity.ActivityRecordOrigin;
import com.comalatech.confluence.documentActivity.domain.entities.Activity;
import com.comalatech.confluence.documentActivity.service.DocumentActivityService;
import com.comalatech.confluence.documentActivity.upgrade.entity.domain.ContentUpgrade;
import com.comalatech.confluence.documentActivity.upgrade.entity.domain.Status;
import com.comalatech.confluence.documentActivity.upgrade.service.DocumentActivityUpgradeService;
import com.comalatech.confluence.documentActivity.upgrade.support.commands.UpgradeLog;
import com.comalatech.confluence.documentActivity.upgrade.support.model.UpgradeLogData;
import com.comalatech.confluence.documentActivity.upgrade.utils.SupportPackageFile;
import com.comalatech.confluence.documentActivity.usecases.contracts.GenerateDocumentActivity;
import com.comalatech.confluence.documentActivity.usecases.contracts.ValidateDocumentActivity;
import com.comalatech.confluence.states.StateAccessor;
import com.comalatech.confluence.states.model.PageState;
import com.comalatech.confluence.util.ReadWriteTransactionService;
import com.comalatech.confluence.workflow.ApprovalAccessor;
import com.comalatech.confluence.workflow.model.ApprovalCheck;
import com.comalatech.confluence.workflow.supportconsole.infrastructure.contract.SupportPresenter;
import com.comalatech.workflow.StateService;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractPageUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(AbstractPageUpgradeTask.class);
    private final AbstractPage content;
    private final ValidateDocumentActivity validateDocumentActivity;
    private final GenerateDocumentActivity generateDocumentActivity;
    private final ReadWriteTransactionService readWriteTransactionService;
    private final DocumentActivityService documentActivityService;
    private final DocumentActivityUpgradeService documentActivityUpgradeService;
    private final StateService stateService;
    private final StateAccessor stateAccessor;
    private final ApprovalAccessor approvalAccessor;
    private final boolean isUpgrading;
    private final UpgradeLog upgradeLog;

    public AbstractPageUpgradeTask(AbstractPage content, ValidateDocumentActivity validateDocumentActivity, GenerateDocumentActivity generateDocumentActivity, ReadWriteTransactionService readWriteTransactionService, DocumentActivityService documentActivityService, DocumentActivityUpgradeService documentActivityUpgradeService, SupportPresenter templateFileLayoutHelper, StateService stateService, StateAccessor stateAccessor, ApprovalAccessor approvalAccessor, boolean isUpgrading) {
        this.content = content;
        this.isUpgrading = isUpgrading;
        this.validateDocumentActivity = validateDocumentActivity;
        this.generateDocumentActivity = generateDocumentActivity;
        this.readWriteTransactionService = readWriteTransactionService;
        this.documentActivityService = documentActivityService;
        this.documentActivityUpgradeService = documentActivityUpgradeService;
        this.stateAccessor = stateAccessor;
        this.stateService = stateService;
        this.approvalAccessor = approvalAccessor;
        this.upgradeLog = new UpgradeLog(templateFileLayoutHelper);
    }

    public ContentUpgrade run() {
        ArrayList<String> messages = new ArrayList<String>();
        ContentUpgrade contentUpgrade = new ContentUpgrade();
        AtomicBoolean successfulProcessed = new AtomicBoolean(false);
        try {
            SupportPackageFile.deleteSpaceBaseFolder(this.content.getSpaceKey());
            log.debug(MessageFormat.format("Page {0} ({1}) processing...", this.content.getTitle(), this.content.getId()));
            this.readWriteTransactionService.executeInReadWriteTransaction(() -> {
                if (!this.documentActivityService.getById(this.content).isEmpty()) {
                    log.debug(MessageFormat.format("Page {0} ({1}) already upgraded: skipping.", this.content.getTitle(), this.content.getId()));
                    successfulProcessed.set(true);
                    this.documentActivityUpgradeService.removePageUpgradePendingFlag(this.content);
                    return null;
                }
                try {
                    List<Activity> activities = this.generateDocumentActivity.generate(this.content);
                    boolean successfulValidation = this.validateDocumentActivity.validate(this.content, activities, true, SupportPackageFile.getDataBasePath(this.content.getSpaceKey(), this.content.getId()));
                    if (successfulValidation && this.isUpgrading) {
                        activities.forEach(act -> this.documentActivityService.create((Activity)act, ActivityRecordOrigin.ORIGIN_UPGRADE));
                        this.storeNewContentProperties();
                    }
                }
                catch (Exception e) {
                    this.handleError(messages, MessageFormat.format("There has been an error doing the upgrade/pre-check process for the content with id {0}", this.content.getId()), e);
                    successfulProcessed.set(false);
                    return null;
                }
                successfulProcessed.set(true);
                if (this.isUpgrading) {
                    this.documentActivityUpgradeService.removePageUpgradePendingFlag(this.content);
                }
                return null;
            });
        }
        catch (Exception ex) {
            this.handleError(messages, MessageFormat.format("There has been an error doing the upgrade/pre-check process for the content with id {0}", this.content.getId()), ex);
        }
        contentUpgrade.setContentId(this.content.getId());
        if (successfulProcessed.get()) {
            contentUpgrade.setStatus(Status.getSuccessStatus(this.isUpgrading));
        } else {
            if (!messages.isEmpty()) {
                try {
                    this.upgradeLog.generateSupportFile(UpgradeLogData.builder().messages(messages).build(), SupportPackageFile.generateSpaceBaseFolder(this.content.getSpaceKey()));
                }
                catch (IOException e) {
                    log.error("Error during the creation of the support package", (Throwable)e);
                }
            }
            contentUpgrade.setStatus(Status.getFailStatus(this.isUpgrading));
            contentUpgrade.setSupport("/rest/cw/2/documentactivity/upgrade/support/" + this.content.getSpaceKey());
        }
        log.debug("Upgrade task finished for content " + this.content.getId());
        return contentUpgrade;
    }

    private void handleError(List<String> messages, String message, Exception ex) {
        messages.add(message);
        if (ex != null) {
            messages.add(ExceptionUtils.getStackTrace((Throwable)ex));
        }
        if (ex != null) {
            log.error(message, (Throwable)ex);
        } else {
            log.error(message);
        }
    }

    private void storeNewContentProperties() {
        List<ApprovalCheck> approvals;
        PageState previousStateToFinalState;
        PageState publishedState = (PageState)this.stateService.getPublishedState((ContentEntityObject)this.content);
        if (publishedState != null) {
            this.stateAccessor.setLatestFinalState(publishedState.getPage(), publishedState);
        }
        if ((previousStateToFinalState = this.stateAccessor.getPreviousStateToFinalState(this.content, publishedState)) != null && (approvals = this.approvalAccessor.getApprovalsPriorToLatestPublishedState(this.content, previousStateToFinalState)) != null && !approvals.isEmpty()) {
            this.approvalAccessor.saveApprovalChecksBeforeLastFinalState(this.content, approvals.toArray(ApprovalCheck.EMPTY_ARRAY));
        }
    }
}

