/*
 * Decompiled with CFR 0.152.
 */
package com.comalatech.confluence.documentActivity.statistics;

import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.core.bean.EntityObject;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.comalatech.confluence.documentActivity.ao.entity.BaseActivityDetailsRecord;
import com.comalatech.confluence.documentActivity.domain.entities.ActionDetailType;
import com.comalatech.confluence.documentActivity.domain.entities.ActionType;
import com.comalatech.confluence.documentActivity.statistics.accessor.WorkflowApprovalStatsRecordAccessor;
import com.comalatech.confluence.documentActivity.statistics.accessor.criteria.WorkflowStatsSearchCriteria;
import com.comalatech.confluence.documentActivity.statistics.validator.UsageStatsValidator;
import com.comalatech.workflow.WorkflowException;
import com.comalatech.workflow.model.statistics.ApprovalStatsFilter;
import com.comalatech.workflow.statistics.ApprovalStatsService;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class DefaultApprovalStatsService
implements ApprovalStatsService {
    private final UsageStatsValidator statsValidator;
    private final WorkflowApprovalStatsRecordAccessor workflowStatsRecordAccessor;
    private final UserAccessor userAccessor;

    public DefaultApprovalStatsService(UsageStatsValidator statsValidator, WorkflowApprovalStatsRecordAccessor workflowStatsRecordAccessor, @ComponentImport UserAccessor userAccessor) {
        this.statsValidator = statsValidator;
        this.workflowStatsRecordAccessor = workflowStatsRecordAccessor;
        this.userAccessor = userAccessor;
    }

    @Override
    public Long getMaximumTimeElapsedForApproval(ApprovalStatsFilter statsFilter) throws WorkflowException {
        List<BaseActivityDetailsRecord> activityDetailsRecordEntityList = this.getSpecificApprovalRecords(statsFilter);
        if (activityDetailsRecordEntityList.isEmpty()) {
            return null;
        }
        return activityDetailsRecordEntityList.stream().mapToLong(act -> Long.parseLong(act.getValue())).max().orElse(0L);
    }

    @Override
    public Long getMinimumTimeElapsedForApproval(ApprovalStatsFilter statsFilter) throws WorkflowException {
        List<BaseActivityDetailsRecord> activityDetailsRecordEntityList = this.getSpecificApprovalRecords(statsFilter);
        if (activityDetailsRecordEntityList.isEmpty()) {
            return null;
        }
        return activityDetailsRecordEntityList.stream().mapToLong(act -> Long.parseLong(act.getValue())).min().orElse(0L);
    }

    @Override
    public Double getAverageTimeElapsedForApproval(ApprovalStatsFilter statsFilter) throws WorkflowException {
        List<BaseActivityDetailsRecord> activityDetailsRecordEntityList = this.getSpecificApprovalRecords(statsFilter);
        if (activityDetailsRecordEntityList.isEmpty()) {
            return null;
        }
        return activityDetailsRecordEntityList.stream().mapToLong(act -> Long.parseLong(act.getValue())).average().orElse(0.0);
    }

    @Override
    public Long getMaximumTimeAssigneeTookToApprove(ApprovalStatsFilter statsFilter) throws WorkflowException {
        List<BaseActivityDetailsRecord> activityDetailsRecordEntityList = this.getAssigneeTimeRecords(statsFilter);
        if (activityDetailsRecordEntityList.isEmpty()) {
            return 0L;
        }
        return activityDetailsRecordEntityList.stream().mapToLong(act -> Long.parseLong(act.getValue())).max().orElse(0L);
    }

    @Override
    public Long getMinimumTimeAssigneeTookToApprove(ApprovalStatsFilter statsFilter) throws WorkflowException {
        List<BaseActivityDetailsRecord> activityDetailsRecordEntityList = this.getAssigneeTimeRecords(statsFilter);
        if (activityDetailsRecordEntityList.isEmpty()) {
            return 0L;
        }
        return activityDetailsRecordEntityList.stream().mapToLong(act -> Long.parseLong(act.getValue())).min().orElse(0L);
    }

    @Override
    public Double getAverageTimeAssigneeTookToApprove(ApprovalStatsFilter statsFilter) throws WorkflowException {
        List<BaseActivityDetailsRecord> activityDetailsRecordEntityList = this.getAssigneeTimeRecords(statsFilter);
        if (activityDetailsRecordEntityList.isEmpty()) {
            return 0.0;
        }
        return activityDetailsRecordEntityList.stream().mapToLong(act -> Long.parseLong(act.getValue())).average().orElse(0.0);
    }

    private List<BaseActivityDetailsRecord> getSpecificApprovalRecords(ApprovalStatsFilter statsFilter) throws WorkflowException {
        this.statsValidator.validateApprovalName(statsFilter.getApprovalName());
        return this.workflowStatsRecordAccessor.getApprovalStatsRecords(this.buildSearchCriteria(statsFilter, ActionType.Subtype.APPROVAL_FULLY_APPROVED.getValue(), ActionDetailType.APPROVAL_TIME_LAPSED.getValue()));
    }

    private List<BaseActivityDetailsRecord> getAssigneeTimeRecords(ApprovalStatsFilter statsFilter) throws WorkflowException {
        this.statsValidator.validateAssignee(statsFilter.getAssignee());
        statsFilter.setAssignee(this.userAccessor.getUserByName(statsFilter.getAssignee()).getKey().getStringValue());
        return this.workflowStatsRecordAccessor.getApprovalStatsRecords(this.buildSearchCriteria(statsFilter, ActionType.Subtype.APPROVAL_APPROVED.getValue(), ActionDetailType.ASSIGNEE_TIME_TO_APPROVE.getValue()));
    }

    private WorkflowStatsSearchCriteria buildSearchCriteria(ApprovalStatsFilter filter, String subType, String detailType) throws WorkflowException {
        List<Space> spaces = this.statsValidator.validateSpaces(filter.getSpaceKeys());
        this.statsValidator.validateDates(filter.getFromDate(), filter.getToDate());
        return ((WorkflowStatsSearchCriteria.WorkflowStatsSearchCriteriaBuilder)((WorkflowStatsSearchCriteria.WorkflowStatsSearchCriteriaBuilder)((WorkflowStatsSearchCriteria.WorkflowStatsSearchCriteriaBuilder)((WorkflowStatsSearchCriteria.WorkflowStatsSearchCriteriaBuilder)((WorkflowStatsSearchCriteria.WorkflowStatsSearchCriteriaBuilder)((WorkflowStatsSearchCriteria.WorkflowStatsSearchCriteriaBuilder)((WorkflowStatsSearchCriteria.WorkflowStatsSearchCriteriaBuilder)((WorkflowStatsSearchCriteria.WorkflowStatsSearchCriteriaBuilder)((WorkflowStatsSearchCriteria.WorkflowStatsSearchCriteriaBuilder)WorkflowStatsSearchCriteria.builder().stateName(filter.getStateName())).actionType(ActionType.Type.APPROVAL.getValue())).actionSubType(subType)).detailType(detailType)).spaceIds(spaces != null && !spaces.isEmpty() ? spaces.stream().map(EntityObject::getId).collect(Collectors.toList()) : null)).fromDate(filter.getFromDate())).toDate(filter.getToDate())).approvalName(filter.getApprovalName())).assignee(filter.getAssignee())).build();
    }
}

